/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;

public class JobTracker {
    private LinkedList<JobTracker> jobTrackers;
    private JobEntryResult result;
    private JobTracker parentJobTracker;
    private String jobName;
    private String jobFilename;
    private int maxChildren;
    private final ReentrantReadWriteLock lock;

    public JobTracker(JobMeta jobMeta) {
        this(jobMeta, Const.toInt((String)EnvUtil.getSystemProperty((String)"KETTLE_MAX_JOB_TRACKER_SIZE"), (int)5000));
    }

    public JobTracker(JobMeta jobMeta, int maxChildren) {
        if (jobMeta != null) {
            this.jobName = jobMeta.getName();
            this.jobFilename = jobMeta.getFilename();
        }
        this.jobTrackers = new LinkedList();
        this.maxChildren = maxChildren;
        this.lock = new ReentrantReadWriteLock();
    }

    public JobTracker(JobMeta jobMeta, JobEntryResult result) {
        this(jobMeta);
        this.result = result;
    }

    public JobTracker(JobMeta jobMeta, int maxChildren, JobEntryResult result) {
        this(jobMeta, maxChildren);
        this.result = result;
    }

    public void addJobTracker(JobTracker jobTracker) {
        this.lock.writeLock().lock();
        try {
            this.jobTrackers.add(jobTracker);
            while (this.jobTrackers.size() > this.maxChildren) {
                this.jobTrackers.removeFirst();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public JobTracker getJobTracker(int i) {
        this.lock.readLock().lock();
        try {
            JobTracker jobTracker = this.jobTrackers.get(i);
            return jobTracker;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int nrJobTrackers() {
        this.lock.readLock().lock();
        try {
            int n = this.jobTrackers.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<JobTracker> getJobTrackers() {
        this.lock.readLock().lock();
        try {
            ArrayList<JobTracker> arrayList = new ArrayList<JobTracker>(this.jobTrackers);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setJobTrackers(List<JobTracker> jobTrackers) {
        this.lock.writeLock().lock();
        try {
            this.jobTrackers.clear();
            this.jobTrackers.addAll(jobTrackers);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public JobEntryResult getJobEntryResult() {
        return this.result;
    }

    public void setJobEntryResult(JobEntryResult result) {
        this.result = result;
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.jobTrackers.clear();
            this.result = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobTracker findJobTracker(JobEntryCopy jobEntryCopy) {
        if (jobEntryCopy.getName() == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            ListIterator<JobTracker> it = this.jobTrackers.listIterator(this.jobTrackers.size());
            while (it.hasPrevious()) {
                JobTracker tracker = it.previous();
                JobEntryResult result = tracker.getJobEntryResult();
                if (result == null || !jobEntryCopy.getName().equals(result.getJobEntryName()) || jobEntryCopy.getNr() != result.getJobEntryNr()) continue;
                JobTracker jobTracker = tracker;
                return jobTracker;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    public JobTracker getParentJobTracker() {
        return this.parentJobTracker;
    }

    public void setParentJobTracker(JobTracker parentJobTracker) {
        this.parentJobTracker = parentJobTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalNumberOfItems() {
        this.lock.readLock().lock();
        try {
            int total = 1;
            for (JobTracker jobTracker : this.jobTrackers) {
                total += jobTracker.getTotalNumberOfItems();
            }
            int n = total;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getJobFilename() {
        return this.jobFilename;
    }

    public void setJobFilename(String jobFilename) {
        this.jobFilename = jobFilename;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }
}

