/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.attributes.metastore;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.pentaho.di.core.attributes.metastore.AttributesInterfaceEntry;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreAttribute;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElement;
import org.pentaho.metastore.stores.memory.MemoryMetaStoreElementOwner;

@JsonIgnoreProperties(value={"elementType"})
public class JsonElement
extends MemoryMetaStoreElement
implements AttributesInterfaceEntry {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonElement() {
        SimpleModule module = new SimpleModule("MetaStore Elements", Version.unknownVersion());
        module.addAbstractTypeMapping(IMetaStoreAttribute.class, MemoryMetaStoreAttribute.class);
        module.addAbstractTypeMapping(IMetaStoreElementOwner.class, EmptyOwner.class);
        this.objectMapper.registerModule((Module)module);
    }

    public JsonElement(IMetaStoreElement element) {
        super(element);
        SimpleModule module = new SimpleModule("MetaStore Elements", Version.unknownVersion());
        module.addAbstractTypeMapping(IMetaStoreAttribute.class, MemoryMetaStoreAttribute.class);
        module.addAbstractTypeMapping(IMetaStoreElementOwner.class, EmptyOwner.class);
        this.objectMapper.registerModule((Module)module);
    }

    static JsonElement from(IMetaStoreElement element) {
        return element instanceof JsonElement ? (JsonElement)element : new JsonElement(element);
    }

    public String getId() {
        if (Strings.isNullOrEmpty((String)super.getId())) {
            this.setId(this.getName());
        }
        return Strings.emptyToNull((String)super.getId());
    }

    public static String groupName(IMetaStoreElementType elementType) {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        objectNode.put("_", "Embedded MetaStore Elements");
        objectNode.put("namespace", (String)Preconditions.checkNotNull((Object)elementType.getNamespace()));
        objectNode.put("type", (String)Preconditions.checkNotNull((Object)elementType.getId()));
        return objectNode.toString();
    }

    @Override
    public String groupName() {
        return JsonElement.groupName((IMetaStoreElementType)Preconditions.checkNotNull((Object)this.getElementType()));
    }

    @Override
    public String key() {
        return (String)Preconditions.checkNotNull((Object)this.getId());
    }

    @Override
    public String jsonValue() throws IOException {
        return this.objectMapper.writeValueAsString((Object)this);
    }

    public JsonElement load(String jsonData) throws IOException {
        return (JsonElement)this.objectMapper.readerForUpdating((Object)this).readValue(jsonData);
    }

    private static class EmptyOwner
    extends MemoryMetaStoreElementOwner {
        public EmptyOwner() {
            super(null, null);
        }
    }
}

