/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.base.IMetaFileCache;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.TransMeta;

public class MetaFileCacheImpl
implements IMetaFileCache {
    private LogChannelInterface logger;
    protected Map<String, MetaFileCacheEntry<? extends AbstractMeta>> cacheMap = new ConcurrentHashMap<String, MetaFileCacheEntry<? extends AbstractMeta>>();

    MetaFileCacheImpl(LogChannelInterface logger) {
        this.logger = logger;
    }

    @Override
    public JobMeta getCachedJobMeta(String key) {
        return this.cacheMap.get(key) == null ? null : (JobMeta)this.cacheMap.get(key).getMeta();
    }

    @Override
    public TransMeta getCachedTransMeta(String key) {
        return this.cacheMap.get(key) == null ? null : (TransMeta)this.cacheMap.get(key).getMeta();
    }

    @Override
    public void cacheMeta(String key, JobMeta meta) {
        this.cacheMap.put(key, new MetaFileCacheEntry(this, key, (AbstractMeta)((JobMeta)meta.realClone(false))));
    }

    @Override
    public void cacheMeta(String key, TransMeta meta) {
        this.cacheMap.put(key, new MetaFileCacheEntry(this, key, (AbstractMeta)((TransMeta)meta.realClone(false))));
    }

    @Override
    public void logCacheSummary(LogChannelInterface log) {
        if (log == null) {
            log = this.logger;
        }
        int lines = 0;
        for (MetaFileCacheEntry<? extends AbstractMeta> entry : this.cacheMap.values()) {
            if (lines == 0) {
                log.logDetailed("MetaFileCache Loading Summary");
            }
            ++lines;
            log.logDetailed(entry.getKey() + " was loaded " + entry.timesUsed + " times from the cache.");
        }
    }

    public static class MetaFileCacheEntry<T extends AbstractMeta> {
        T meta;
        Timestamp created = new Timestamp(System.currentTimeMillis());
        Timestamp lastAccessed;
        int timesUsed;
        String key;
        final /* synthetic */ MetaFileCacheImpl this$0;

        MetaFileCacheEntry(String key, T meta) {
            this.this$0 = this$0;
            this.key = key;
            if (meta instanceof JobMeta) {
                this.meta = (AbstractMeta)((JobMeta)meta).realClone(false);
            } else if (meta instanceof TransMeta) {
                this.meta = (AbstractMeta)((TransMeta)meta).realClone(false);
            }
        }

        public T getMeta() {
            ++this.timesUsed;
            if (this.this$0.logger.isDetailed()) {
                String fileType = this.meta instanceof JobMeta ? "Job" : "Transformation";
                this.this$0.logger.logDetailed("Loading " + fileType + " from cache with key " + this.key + " - count " + this.timesUsed);
            }
            this.lastAccessed = new Timestamp(System.currentTimeMillis());
            return this.meta;
        }

        public Timestamp getCreated() {
            return this.created;
        }

        public Timestamp getLastAccessed() {
            return this.lastAccessed;
        }

        public int getTimesUsed() {
            return this.timesUsed;
        }

        public String getKey() {
            return this.key;
        }
    }
}

