/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.base.Params;

public class KettleConstants {
    public static final String LOG = "log";
    public static final String DIR = "dir";
    public static final String JOB = "job";
    public static final String REPO = "rep";
    public static final String FILE = "file";
    public static final String USER = "user";
    public static final String PASS = "pass";
    public static final String LEVEL = "level";
    public static final String TRANS = "trans";
    public static final String PARAM = "param";
    public static final String NO_REPO = "norep";
    public static final String CUSTOM = "custom";
    public static final String VERSION = "version";
    public static final String JARFILE = "jarFile";
    public static final String METRICS = "metrics";
    public static final String LOGFILE = "logfile";
    public static final String SAFEMODE = "safemode";
    public static final String LIST_JOBS = "listjob";
    public static final String LIST_DIRS = "listdir";
    public static final String LIST_REPOS = "listrep";
    public static final String TRUST_USER = "trustuser";
    public static final String LIST_TRANS = "listtrans";
    public static final String LIST_PARAMS = "listparam";
    public static final String EXPORT_REPO_JOB = "export";
    public static final String INITIAL_DIR = "initialDir";
    public static final String EXPORT_REPO_TRANS = "exprep";
    public static final String MAX_LOG_LINES = "maxloglines";
    public static final String MAX_LOG_TIMEOUT = "maxlogtimeout";
    public static final String RESULT_SET_STEP_NAME = "stepname";
    public static final String RESULT_SET_COPY_NUMBER = "copynum";
    public static final String BASE64_ZIP = "base64zip";
    public static final String UUID = "uuid";

    public static Map<String, String> toJobMap(Params params) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.putIfAbsent(UUID, params.getUuid());
        arguments.putIfAbsent(REPO, params.getRepoName());
        arguments.putIfAbsent(NO_REPO, params.getBlockRepoConns());
        arguments.putIfAbsent(USER, params.getRepoUsername());
        arguments.putIfAbsent(TRUST_USER, params.getTrustRepoUser());
        arguments.putIfAbsent(PASS, params.getRepoPassword());
        arguments.putIfAbsent(DIR, params.getInputDir());
        arguments.putIfAbsent(FILE, params.getLocalFile());
        arguments.putIfAbsent(JARFILE, params.getLocalJarFile());
        arguments.putIfAbsent(JOB, params.getInputFile());
        arguments.putIfAbsent(LIST_JOBS, params.getListRepoFiles());
        arguments.putIfAbsent(LIST_DIRS, params.getListRepoDirs());
        arguments.putIfAbsent(EXPORT_REPO_JOB, params.getExportRepo());
        arguments.putIfAbsent(INITIAL_DIR, params.getLocalInitialDir());
        arguments.putIfAbsent(LIST_REPOS, params.getListRepos());
        arguments.putIfAbsent(SAFEMODE, params.getSafeMode());
        arguments.putIfAbsent(METRICS, params.getMetrics());
        arguments.putIfAbsent(LIST_PARAMS, params.getListFileParams());
        arguments.putIfAbsent(LEVEL, params.getLogLevel());
        arguments.putIfAbsent(MAX_LOG_LINES, params.getMaxLogLines());
        arguments.putIfAbsent(MAX_LOG_TIMEOUT, params.getMaxLogTimeout());
        arguments.putIfAbsent(LOGFILE, params.getLogFile());
        arguments.putIfAbsent(LOG, params.getOldLogFile());
        arguments.putIfAbsent(VERSION, params.getVersion());
        arguments.putIfAbsent(RESULT_SET_STEP_NAME, params.getResultSetStepName());
        arguments.putIfAbsent(RESULT_SET_COPY_NUMBER, params.getResultSetCopyNumber());
        if (params.getParams() != null && !params.getParams().isEmpty()) {
            params.getParams().keySet().stream().forEach(paramKey -> arguments.putIfAbsent("param:" + paramKey, params.getParams().get(paramKey)));
        }
        if (params.getCustomParams() != null && !params.getCustomParams().isEmpty()) {
            params.getCustomParams().keySet().stream().forEach(paramKey -> arguments.putIfAbsent("custom:" + paramKey, params.getParams().get(paramKey)));
        }
        return arguments;
    }

    public static Map<String, String> toTransMap(Params params) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.putIfAbsent(UUID, params.getUuid());
        arguments.putIfAbsent(REPO, params.getRepoName());
        arguments.putIfAbsent(NO_REPO, params.getBlockRepoConns());
        arguments.putIfAbsent(USER, params.getRepoUsername());
        arguments.putIfAbsent(TRUST_USER, params.getTrustRepoUser());
        arguments.putIfAbsent(PASS, params.getRepoPassword());
        arguments.putIfAbsent(DIR, params.getInputDir());
        arguments.putIfAbsent(FILE, params.getLocalFile());
        arguments.putIfAbsent(JARFILE, params.getLocalJarFile());
        arguments.putIfAbsent(TRANS, params.getInputFile());
        arguments.putIfAbsent(LIST_TRANS, params.getListRepoFiles());
        arguments.putIfAbsent(LIST_DIRS, params.getListRepoDirs());
        arguments.putIfAbsent(EXPORT_REPO_TRANS, params.getExportRepo());
        arguments.putIfAbsent(INITIAL_DIR, params.getLocalInitialDir());
        arguments.putIfAbsent(LIST_REPOS, params.getListRepos());
        arguments.putIfAbsent(SAFEMODE, params.getSafeMode());
        arguments.putIfAbsent(METRICS, params.getMetrics());
        arguments.putIfAbsent(LIST_PARAMS, params.getListFileParams());
        arguments.putIfAbsent(LEVEL, params.getLogLevel());
        arguments.putIfAbsent(MAX_LOG_LINES, params.getMaxLogLines());
        arguments.putIfAbsent(MAX_LOG_TIMEOUT, params.getMaxLogTimeout());
        arguments.putIfAbsent(LOGFILE, params.getLogFile());
        arguments.putIfAbsent(LOG, params.getOldLogFile());
        arguments.putIfAbsent(VERSION, params.getVersion());
        arguments.putIfAbsent(RESULT_SET_STEP_NAME, params.getResultSetStepName());
        arguments.putIfAbsent(RESULT_SET_COPY_NUMBER, params.getResultSetCopyNumber());
        arguments.putIfAbsent(BASE64_ZIP, params.getBase64Zip());
        if (params.getParams() != null && !params.getParams().isEmpty()) {
            params.getParams().keySet().stream().forEach(paramKey -> arguments.putIfAbsent("param:" + paramKey, params.getParams().get(paramKey)));
        }
        return arguments;
    }
}

