/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import org.pentaho.di.base.MetaFileCacheImpl;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;

public interface IMetaFileCache {
    public static IMetaFileCache initialize(Job parentJob, LogChannelInterface logger) {
        IMetaFileCache cache = null;
        cache = parentJob != null ? parentJob.getJobMeta().getMetaFileCache() : new MetaFileCacheImpl(logger);
        return cache;
    }

    public static IMetaFileCache initialize(Trans parentTrans, LogChannelInterface logger) {
        IMetaFileCache cache = null;
        cache = parentTrans != null && parentTrans.getTransMeta() != null ? parentTrans.getTransMeta().getMetaFileCache() : new MetaFileCacheImpl(logger);
        return cache;
    }

    public static void setCacheInstance(JobMeta jobMeta, IMetaFileCache cache) {
        jobMeta.setMetaFileCache(cache);
    }

    public static void setCacheInstance(TransMeta transMeta, IMetaFileCache cache) {
        transMeta.setMetaFileCache(cache);
    }

    public JobMeta getCachedJobMeta(String var1);

    public TransMeta getCachedTransMeta(String var1);

    public void cacheMeta(String var1, JobMeta var2);

    public void cacheMeta(String var1, TransMeta var2);

    public void logCacheSummary(LogChannelInterface var1);

    default public String getKey(ObjectLocationSpecificationMethod specificationMethod, String realFilenameOrId) {
        return specificationMethod.name() + ":" + realFilenameOrId;
    }
}

