/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import org.keycloak.authorization.client.representation.EntitlementRequest;
import org.keycloak.authorization.client.representation.EntitlementResponse;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.util.JsonSerialization;

public class EntitlementResource {
    private final Http http;
    private final String eat;

    public EntitlementResource(Http http, String eat) {
        this.http = http;
        this.eat = eat;
    }

    public EntitlementResponse getAll(String resourceServerId) {
        try {
            return this.http.get("/authz/entitlement/" + resourceServerId).authorizationBearer(this.eat).response().json(EntitlementResponse.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Failed to obtain entitlements", cause);
        }
    }

    public EntitlementResponse get(String resourceServerId, EntitlementRequest request) {
        try {
            return this.http.post("/authz/entitlement/" + resourceServerId).authorizationBearer(this.eat).json(JsonSerialization.writeValueAsBytes(request)).response().json(EntitlementResponse.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Failed to obtain entitlements", cause);
        }
    }
}

