/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import org.keycloak.authorization.client.representation.AuthorizationRequest;
import org.keycloak.authorization.client.representation.AuthorizationResponse;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.util.JsonSerialization;

public class AuthorizationResource {
    private final Http http;
    private final String accessToken;

    public AuthorizationResource(Http http, String aat) {
        this.http = http;
        this.accessToken = aat;
    }

    public AuthorizationResponse authorize(AuthorizationRequest request) {
        try {
            return this.http.post("/authz/authorize").authorizationBearer(this.accessToken).json(JsonSerialization.writeValueAsBytes(request)).response().json(AuthorizationResponse.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Failed to obtain authorization data", cause);
        }
    }
}

