/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.BasicAuthHelper;

public class Configuration
extends AdapterConfig {
    @JsonIgnore
    private HttpClient httpClient;
    @JsonIgnore
    private ClientAuthenticator clientAuthenticator = new ClientAuthenticator(){

        @Override
        public void configureClientCredentials(HashMap<String, String> requestParams, HashMap<String, String> requestHeaders) {
            String secret = (String)Configuration.this.getCredentials().get("secret");
            if (secret == null) {
                throw new RuntimeException("Client secret not provided.");
            }
            requestHeaders.put("Authorization", BasicAuthHelper.createHeader(Configuration.this.getResource(), secret));
        }
    };

    public Configuration() {
    }

    public Configuration(String authServerUrl, String realm, String clientId, Map<String, Object> clientCredentials, HttpClient httpClient) {
        this.authServerUrl = authServerUrl;
        this.setAuthServerUrl(authServerUrl);
        this.setRealm(realm);
        this.setResource(clientId);
        this.setCredentials(clientCredentials);
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClients.createDefault();
        }
        return this.httpClient;
    }

    public ClientAuthenticator getClientAuthenticator() {
        return this.clientAuthenticator;
    }
}

