/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.reader;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.jsoninput.JsonInput;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.exception.JsonInputException;
import org.pentaho.di.trans.steps.jsoninput.reader.IJsonReader;

public class FastJsonReader
implements IJsonReader {
    private static Class<?> PKG = JsonInputMeta.class;
    private static final String JSON_CHARSET = "UTF-8";
    private static final JsonInputField[] ZERO_INPUT_FIELDS = new JsonInputField[0];
    private ReadContext jsonReadContext;
    private Configuration jsonConfiguration;
    private final boolean defaultPathLeafToNull;
    private final boolean ignoreMissingPath;
    private boolean includeNulls = false;
    private final JsonInput step;
    private JsonInputField[] inputFields;
    private JsonPath[] compiledJsonPaths = null;
    private LogChannelInterface log;

    public FastJsonReader(JsonInput step, JsonInputField[] inputFields, boolean defaultPathLeafToNull, boolean ignoreMissingPath, LogChannelInterface log) throws KettleException {
        this.defaultPathLeafToNull = defaultPathLeafToNull;
        this.ignoreMissingPath = ignoreMissingPath;
        this.step = step;
        this.log = log;
        this.setJsonConfiguration(defaultPathLeafToNull);
        this.setInputFields(inputFields);
    }

    public FastJsonReader(JsonInput step, JsonInputField[] inputFields, boolean defaultPathLeafToNull, boolean ignoreMissingPath, boolean includeNulls, LogChannelInterface log) throws KettleException {
        this.defaultPathLeafToNull = defaultPathLeafToNull;
        this.ignoreMissingPath = ignoreMissingPath;
        this.includeNulls = includeNulls;
        this.step = step;
        this.log = log;
        this.setJsonConfiguration(defaultPathLeafToNull);
        this.setInputFields(inputFields);
    }

    private void setJsonConfiguration(boolean defaultPathLeafToNull) {
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(Option.SUPPRESS_EXCEPTIONS);
        options.add(Option.ALWAYS_RETURN_LIST);
        if (defaultPathLeafToNull) {
            options.add(Option.DEFAULT_PATH_LEAF_TO_NULL);
        }
        this.jsonConfiguration = Configuration.defaultConfiguration().addOptions(options.toArray(new Option[0]));
    }

    public boolean isDefaultPathLeafToNull() {
        return this.defaultPathLeafToNull;
    }

    Configuration getJsonConfiguration() {
        return this.jsonConfiguration;
    }

    private ParseContext getParseContext() {
        return JsonPath.using((Configuration)this.jsonConfiguration);
    }

    private ReadContext getReadContext() {
        return this.jsonReadContext;
    }

    protected void readInput(InputStream is) throws KettleException {
        this.jsonReadContext = this.getParseContext().parse(is, JSON_CHARSET);
        if (this.jsonReadContext == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadUrl.Null", (String[])new String[0]));
        }
    }

    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    public void setInputFields(JsonInputField[] inputFields) {
        if (null != inputFields) {
            this.inputFields = inputFields;
            this.compiledJsonPaths = new JsonPath[inputFields.length];
            int i = 0;
            for (JsonInputField inputField : inputFields) {
                this.compiledJsonPaths[i++] = JsonPath.compile((String)this.step.environmentSubstitute(inputField.getPath(), true), (Predicate[])new Predicate[0]);
            }
        } else {
            this.inputFields = ZERO_INPUT_FIELDS;
        }
    }

    @Override
    public RowSet parse(InputStream in) throws KettleException {
        int len;
        this.readInput(in);
        List<List<?>> results = this.evalCombinedResult();
        int n = len = results.isEmpty() ? 0 : FastJsonReader.getMaxRowSize(results);
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.NrRecords", (Object[])new Object[]{len}));
        }
        if (len == 0) {
            return this.getEmptyResponse();
        }
        return new TransposedRowSet(results, this.includeNulls);
    }

    protected static int getMaxRowSize(List<List<?>> results) {
        return results.stream().mapToInt(List::size).max().getAsInt();
    }

    private RowSet getEmptyResponse() {
        SingleRowRowSet nullInputResponse = new SingleRowRowSet();
        nullInputResponse.putRow(null, new Object[this.inputFields.length]);
        nullInputResponse.setDone();
        return nullInputResponse;
    }

    private List<List<?>> evalCombinedResult() throws JsonInputException {
        int lastSize = -1;
        String prevPath = null;
        ArrayList results = new ArrayList(this.compiledJsonPaths.length);
        int i = 0;
        for (JsonPath path : this.compiledJsonPaths) {
            List result = (List)this.getReadContext().read(path);
            if (result.size() != lastSize && lastSize > 0 && !result.isEmpty()) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonInput.Error.BadStructure", (Object[])new Object[]{result.size(), this.inputFields[i].getPath(), prevPath, lastSize}));
            }
            if (!this.isIgnoreMissingPath() && (FastJsonReader.isAllNull(result) || result.isEmpty())) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{this.inputFields[i].getPath()}));
            }
            results.add(result);
            lastSize = result.size();
            prevPath = this.inputFields[i].getPath();
            ++i;
        }
        return results;
    }

    public static boolean isAllNull(Iterable<?> list) {
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    private static class TransposedRowSet
    extends SingleRowRowSet {
        private List<List<?>> results;
        private final int rowCount;
        private int rowNbr;
        private boolean cullNulls = true;
        private boolean includeNulls;

        public TransposedRowSet(List<List<?>> results, boolean includeNulls) {
            this.includeNulls = includeNulls;
            this.results = results;
            this.rowCount = results.isEmpty() ? 0 : FastJsonReader.getMaxRowSize(results);
        }

        public Object[] getRow() {
            boolean allNulls = this.cullNulls && this.rowCount > 1;
            Object[] rowData = null;
            do {
                if (this.rowNbr >= this.rowCount) {
                    this.results.clear();
                    return null;
                }
                rowData = new Object[this.results.size()];
                for (int col = 0; col < this.results.size(); ++col) {
                    if (this.results.get(col).isEmpty()) {
                        rowData[col] = null;
                        continue;
                    }
                    Object val = this.results.get(col).get(this.rowNbr);
                    rowData[col] = val;
                    allNulls &= val == null && !this.includeNulls;
                }
                ++this.rowNbr;
            } while (allNulls);
            return rowData;
        }

        public int size() {
            return this.rowCount - this.rowNbr;
        }

        public boolean isDone() {
            return true;
        }

        public void clear() {
            this.results.clear();
        }
    }
}

