/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLine3DRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.CollectorFunctionResult;
import org.pentaho.plugin.jfreereport.reportcharts.ICollectorFunction;
import org.pentaho.plugin.jfreereport.reportcharts.MultiPlotChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.XYAreaChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.ExtTimeTableXYDataset;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FastNumberTickUnit;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public class XYAreaLineChartExpression
extends XYAreaChartExpression
implements MultiPlotChartExpression {
    private static final long serialVersionUID = 7082583397390897215L;
    private String secondValueAxisLabel = "";
    private ArrayList lineSeriesColor = new ArrayList();
    private Font linesLabelFont;
    private Font linesTickLabelFont;
    private String lineTicksLabelFormat;
    private boolean sharedRangeAxis;
    private double linePeriodCount = 0.0;
    private Class lineTimePeriod;
    private Font lineTitleFont;
    private Font lineTickFont;
    private Double lineRangeMinimum;
    private Double lineRangeMaximum;
    private boolean lineAxisAutoRange;
    private String secondaryDataSet;
    private boolean lineAxisIncludesZero = true;
    private boolean lineAxisStickyZero = true;

    public boolean isLineAxisIncludesZero() {
        return this.lineAxisIncludesZero;
    }

    public void setLineAxisIncludesZero(boolean lineAxisIncludesZero) {
        this.lineAxisIncludesZero = lineAxisIncludesZero;
    }

    public boolean isLineAxisStickyZero() {
        return this.lineAxisStickyZero;
    }

    public void setLineAxisStickyZero(boolean lineAxisStickyZero) {
        this.lineAxisStickyZero = lineAxisStickyZero;
    }

    public Font getLineTitleFont() {
        return this.lineTitleFont;
    }

    public void setLineTitleFont(Font lineTitleFont) {
        this.lineTitleFont = lineTitleFont;
    }

    public Font getLineTickFont() {
        return this.lineTickFont;
    }

    public void setLineTickFont(Font lineTickFont) {
        this.lineTickFont = lineTickFont;
    }

    public Double getLineRangeMinimum() {
        return this.lineRangeMinimum;
    }

    public void setLineRangeMinimum(Double lineRangeMinimum) {
        this.lineRangeMinimum = lineRangeMinimum;
    }

    public Double getLineRangeMaximum() {
        return this.lineRangeMaximum;
    }

    public void setLineRangeMaximum(Double lineRangeMaximum) {
        this.lineRangeMaximum = lineRangeMaximum;
    }

    public double getLinePeriodCount() {
        return this.linePeriodCount;
    }

    public void setLinePeriodCount(double linePeriodCount) {
        this.linePeriodCount = linePeriodCount;
    }

    public Class getLineTimePeriod() {
        return this.lineTimePeriod;
    }

    public void setLineTimePeriod(Class lineTimePeriod) {
        this.lineTimePeriod = lineTimePeriod;
    }

    public boolean isSharedRangeAxis() {
        return this.sharedRangeAxis;
    }

    public void setSharedRangeAxis(boolean sharedRangeAxis) {
        this.sharedRangeAxis = sharedRangeAxis;
    }

    @Override
    public Expression getInstance() {
        XYAreaLineChartExpression chartExpression = (XYAreaLineChartExpression)super.getInstance();
        chartExpression.lineSeriesColor = (ArrayList)this.lineSeriesColor.clone();
        return chartExpression;
    }

    @Override
    public String getSecondaryDataSet() {
        return this.secondaryDataSet;
    }

    @Override
    public void setSecondaryDataSet(String dataset) {
        this.secondaryDataSet = dataset;
    }

    public String getSecondValueAxisLabel() {
        return this.secondValueAxisLabel;
    }

    public void setSecondValueAxisLabel(String secondValueAxisLabel) {
        this.secondValueAxisLabel = secondValueAxisLabel;
    }

    public Font getLinesLabelFont() {
        return this.linesLabelFont;
    }

    public void setLinesLabelFont(Font linesLabelFont) {
        this.linesLabelFont = linesLabelFont;
    }

    public Font getLinesTickLabelFont() {
        return this.linesTickLabelFont;
    }

    public void setLinesTickLabelFont(Font linesTickLabelFont) {
        this.linesTickLabelFont = linesTickLabelFont;
    }

    public String getLineTicksLabelFormat() {
        return this.lineTicksLabelFormat;
    }

    public void setLineTicksLabelFormat(String lineTicksLabelFormat) {
        this.lineTicksLabelFormat = lineTicksLabelFormat;
    }

    public void setLineSeriesColor(int index, String field) {
        if (this.lineSeriesColor.size() == index) {
            this.lineSeriesColor.add(field);
        } else {
            this.lineSeriesColor.set(index, field);
        }
    }

    public String getLineSeriesColor(int index) {
        return (String)this.lineSeriesColor.get(index);
    }

    public int getLineSeriesColorCount() {
        return this.lineSeriesColor.size();
    }

    public String[] getLineSeriesColor() {
        String[] toArray = this.lineSeriesColor.toArray(new String[this.lineSeriesColor.size()]);
        return toArray;
    }

    public void setLineSeriesColor(String[] fields) {
        this.lineSeriesColor.clear();
        this.lineSeriesColor.addAll(Arrays.asList(fields));
    }

    private XYDataset createLinesDataset() {
        Dataset dataset;
        Object collector;
        Object maybeCollector = this.getDataRow().get(this.getSecondaryDataSet());
        if (maybeCollector instanceof ICollectorFunction) {
            collector = (ICollectorFunction)maybeCollector;
            dataset = (Dataset)collector.getDatasourceValue();
        } else if (maybeCollector instanceof CollectorFunctionResult) {
            collector = (CollectorFunctionResult)maybeCollector;
            dataset = collector.getDataSet();
        } else {
            dataset = null;
        }
        XYDataset linesDataset = dataset instanceof XYDataset ? (XYDataset)dataset : null;
        return linesDataset;
    }

    @Override
    protected JFreeChart computeXYChart(XYDataset xyDataset) {
        JFreeChart chart;
        if (xyDataset instanceof TimeSeriesCollection) {
            if (this.isStacked()) {
                ExtTimeTableXYDataset tableXYDataset = this.convertToTable(xyDataset);
                chart = XYAreaLineChartExpression.createTimeSeriesChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), (XYDataset)tableXYDataset, this.isShowLegend(), false, false, this.isStacked());
            } else {
                chart = XYAreaLineChartExpression.createTimeSeriesChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), xyDataset, this.isShowLegend(), false, false, this.isStacked());
            }
        } else {
            PlotOrientation orientation = this.computePlotOrientation();
            chart = this.isStacked() ? XYAreaLineChartExpression.createStackedXYAreaChart(this.computeTitle(), this.getDomainTitle(), this.getRangeTitle(), xyDataset, orientation, this.isShowLegend(), false, false) : ChartFactory.createXYAreaChart((String)this.computeTitle(), (String)this.getDomainTitle(), (String)this.getRangeTitle(), (XYDataset)xyDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
        }
        this.configureLogarithmicAxis(chart.getXYPlot());
        this.configureLineChart(chart.getXYPlot());
        return chart;
    }

    protected void configureLineChart(XYPlot plot) {
        XYDataset linesDataset = this.createLinesDataset();
        if (linesDataset == null || linesDataset.getSeriesCount() == 0) {
            return;
        }
        Object linesAxis = this.isSharedRangeAxis() ? plot.getRangeAxis() : (this.isThreeD() ? new NumberAxis3D(this.getSecondValueAxisLabel()) : new NumberAxis(this.getSecondValueAxisLabel()));
        Object lineRenderer = this.isThreeD() ? new XYLine3DRenderer() : new XYLineAndShapeRenderer();
        plot.setRenderer(1, (XYItemRenderer)lineRenderer);
        plot.setDataset(1, linesDataset);
        plot.setRangeAxis(1, linesAxis);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        XYLineAndShapeRenderer linesRenderer;
        super.configureChart(chart);
        XYPlot plot = chart.getXYPlot();
        if (!this.isSharedRangeAxis()) {
            Format formatter;
            NumberAxis numberAxis;
            ValueAxis linesAxis = plot.getRangeAxis(1);
            if (linesAxis instanceof NumberAxis) {
                numberAxis = (NumberAxis)linesAxis;
                numberAxis.setAutoRangeIncludesZero(this.isLineAxisIncludesZero());
                numberAxis.setAutoRangeStickyZero(this.isLineAxisStickyZero());
                if (this.getLinePeriodCount() > 0.0) {
                    if (this.getLineTicksLabelFormat() != null) {
                        formatter = new FastDecimalFormat(this.getLineTicksLabelFormat(), this.getResourceBundleFactory().getLocale());
                        numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getLinePeriodCount(), (FastDecimalFormat)formatter));
                    } else {
                        numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getLinePeriodCount()));
                    }
                } else if (this.getLineTicksLabelFormat() != null) {
                    formatter = new DecimalFormat(this.getLineTicksLabelFormat(), new DecimalFormatSymbols(this.getResourceBundleFactory().getLocale()));
                    numberAxis.setNumberFormatOverride((NumberFormat)formatter);
                }
            } else if (linesAxis instanceof DateAxis) {
                numberAxis = (DateAxis)linesAxis;
                if (this.getLinePeriodCount() > 0.0 && this.getLineTimePeriod() != null) {
                    if (this.getLineTicksLabelFormat() != null) {
                        formatter = new SimpleDateFormat(this.getLineTicksLabelFormat(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                        numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getLineTimePeriod()), (int)this.getLinePeriodCount(), (DateFormat)formatter));
                    } else {
                        numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getLineTimePeriod()), (int)this.getLinePeriodCount()));
                    }
                } else if (this.getRangeTickFormatString() != null) {
                    formatter = new SimpleDateFormat(this.getRangeTickFormatString(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                    numberAxis.setDateFormatOverride((DateFormat)formatter);
                }
            }
            if (linesAxis != null) {
                int level;
                Font labelFont = Font.decode(this.getLabelFont());
                linesAxis.setLabelFont(labelFont);
                linesAxis.setTickLabelFont(labelFont);
                if (this.getLineTitleFont() != null) {
                    linesAxis.setLabelFont(this.getLineTitleFont());
                }
                if (this.getLineTickFont() != null) {
                    linesAxis.setTickLabelFont(this.getLineTickFont());
                }
                if (ClassicEngineBoot.isEnforceCompatibilityFor((int)(level = this.getRuntime().getProcessingContext().getCompatibilityLevel()), (int)3, (int)8)) {
                    double lineRangeMaximumVal;
                    double lineRangeMinimumVal = this.lineRangeMinimum == null ? 0.0 : this.lineRangeMinimum;
                    double d = lineRangeMaximumVal = this.lineRangeMaximum == null ? 0.0 : this.lineRangeMaximum;
                    if (this.lineRangeMinimum != null) {
                        linesAxis.setLowerBound(this.getLineRangeMinimum().doubleValue());
                    }
                    if (this.lineRangeMaximum != null) {
                        linesAxis.setUpperBound(this.getRangeMaximum());
                    }
                    if (lineRangeMinimumVal == 0.0 && lineRangeMaximumVal == 1.0) {
                        linesAxis.setLowerBound(0.0);
                        linesAxis.setUpperBound(1.0);
                        linesAxis.setAutoRange(true);
                    }
                } else {
                    if (this.lineRangeMinimum != null) {
                        linesAxis.setLowerBound(this.lineRangeMinimum.doubleValue());
                    }
                    if (this.lineRangeMaximum != null) {
                        linesAxis.setUpperBound(this.lineRangeMaximum.doubleValue());
                    }
                    linesAxis.setAutoRange(this.isLineAxisAutoRange());
                }
            }
        }
        if ((linesRenderer = (XYLineAndShapeRenderer)plot.getRenderer(1)) != null) {
            linesRenderer.setStroke(XYAreaLineChartExpression.translateLineStyle(this.getLineWidth(), this.getLineStyle()));
            linesRenderer.setShapesVisible(this.isMarkersVisible());
            linesRenderer.setBaseShapesFilled(this.isMarkersVisible());
            for (int i = 0; i < this.lineSeriesColor.size(); ++i) {
                String s = (String)this.lineSeriesColor.get(i);
                linesRenderer.setSeriesPaint(i, (Paint)this.parseColorFromString(s));
            }
        }
    }

    public boolean isLineAxisAutoRange() {
        return this.lineAxisAutoRange;
    }

    public void setLineAxisAutoRange(boolean lineAxisAutoRange) {
        this.lineAxisAutoRange = lineAxisAutoRange;
    }

    protected int getDateUnitAsInt(Class domainTimePeriod) {
        if (Second.class.equals((Object)domainTimePeriod)) {
            return 5;
        }
        if (Minute.class.equals((Object)domainTimePeriod)) {
            return 4;
        }
        if (Hour.class.equals((Object)domainTimePeriod)) {
            return 3;
        }
        if (Day.class.equals((Object)domainTimePeriod)) {
            return 2;
        }
        if (Month.class.equals((Object)domainTimePeriod)) {
            return 1;
        }
        if (Year.class.equals((Object)domainTimePeriod)) {
            return 0;
        }
        if (Second.class.equals((Object)domainTimePeriod)) {
            return 6;
        }
        return 2;
    }
}

