/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.vfs.model;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseEntity;
import org.pentaho.di.plugins.fileopensave.api.providers.File;

public class VFSFile
extends BaseEntity
implements File {
    public static final String TYPE = "file";
    public static final String DOMAIN_ROOT = "[\\w]+:///?";
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String DELIMITER = "/";
    private String connection;
    private String domain;

    public String getType() {
        return TYPE;
    }

    public String getProvider() {
        return "vfs";
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getConnectionPath() {
        return this.getConnectionPath(this.getPath());
    }

    public String getConnectionParentPath() {
        return this.getConnectionPath(this.getParent());
    }

    private String getConnectionPath(String root) {
        if (root == null || this.connection == null) {
            return null;
        }
        String replacement = DOMAIN_ROOT + (Utils.isEmpty((CharSequence)this.domain) ? "" : this.domain);
        StringBuilder path = new StringBuilder();
        path.append("pvfs");
        path.append(PROTOCOL_SEPARATOR);
        path.append(this.connection);
        if (Utils.isEmpty((CharSequence)this.domain)) {
            path.append(DELIMITER);
        }
        path.append(root.replaceAll(replacement, ""));
        return path.toString();
    }

    public static VFSFile create(String parent, FileObject fileObject, String connection, String domain) {
        VFSFile vfsFile = new VFSFile();
        vfsFile.setName(fileObject.getName().getBaseName());
        vfsFile.setPath(fileObject.getName().getURI());
        vfsFile.setParent(parent);
        if (connection != null) {
            vfsFile.setConnection(connection);
            vfsFile.setRoot("VFS Connections");
        }
        vfsFile.setDomain(domain != null ? domain : "");
        vfsFile.setCanEdit(true);
        try {
            vfsFile.setDate(new Date(fileObject.getContent().getLastModifiedTime()));
        }
        catch (FileSystemException ignored) {
            vfsFile.setDate(new Date());
        }
        return vfsFile;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int hashCode() {
        return Objects.hash(this.getProvider(), this.getConnection(), this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VFSFile)) {
            return false;
        }
        VFSFile compare = (VFSFile)((Object)obj);
        return compare.getProvider().equals(this.getProvider()) && (compare.getConnection() == null && this.getConnection() == null || compare.getConnection().equals(this.getConnection())) && (compare.getPath() == null && this.getPath() == null || compare.getPath().equals(this.getPath()));
    }
}

