/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.repository.model;

import org.pentaho.di.plugins.fileopensave.api.providers.Directory;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryFile;
import org.pentaho.di.repository.RepositoryDirectoryInterface;

public class RepositoryDirectory
extends RepositoryFile
implements Directory {
    public static final String DIRECTORY = "folder";
    private boolean canAddChildren;

    public RepositoryDirectory() {
        this.setHasChildren(true);
    }

    public String getType() {
        return DIRECTORY;
    }

    public static RepositoryDirectory build(String parentPath, RepositoryDirectoryInterface repositoryDirectoryInterface) {
        RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
        repositoryDirectory.setParent(parentPath);
        repositoryDirectory.setName(repositoryDirectoryInterface.getName());
        repositoryDirectory.setPath(repositoryDirectoryInterface.getPath());
        repositoryDirectory.setObjectId(repositoryDirectoryInterface.getObjectId().getId());
        repositoryDirectory.setHidden(!repositoryDirectoryInterface.isVisible());
        repositoryDirectory.setRoot("Pentaho Repository");
        repositoryDirectory.setCanAddChildren(true);
        repositoryDirectory.setCanEdit(true);
        return repositoryDirectory;
    }

    public static RepositoryDirectory build(String parentPath, org.pentaho.platform.api.repository2.unified.RepositoryFile repositoryFile, Boolean isAdmin) {
        RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
        repositoryDirectory.setParent(parentPath);
        repositoryDirectory.setName(repositoryFile.getName());
        repositoryDirectory.setPath(repositoryFile.getPath());
        repositoryDirectory.setObjectId((String)((Object)repositoryFile.getId()));
        repositoryDirectory.setHidden(repositoryFile.isHidden() != false && isAdmin == false);
        repositoryDirectory.setDate(repositoryFile.getLastModifiedDate() != null ? repositoryFile.getLastModifiedDate() : repositoryFile.getCreatedDate());
        repositoryDirectory.setRoot("Pentaho Repository");
        repositoryDirectory.setCanAddChildren(true);
        repositoryDirectory.setCanEdit(true);
        return repositoryDirectory;
    }

    public boolean isCanAddChildren() {
        return this.canAddChildren;
    }

    public void setCanAddChildren(boolean canAddChildren) {
        this.canAddChildren = canAddChildren;
    }
}

