/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.plugins.fileopensave.api.file.FileDetails;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseFileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileExistsException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.InvalidFileOperationException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.InvalidFileTypeException;
import org.pentaho.di.plugins.fileopensave.controllers.RepositoryBrowserController;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryDirectory;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryFile;
import org.pentaho.di.plugins.fileopensave.providers.repository.model.RepositoryTree;
import org.pentaho.di.plugins.fileopensave.util.Util;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryExtended;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.FileDialogOperation;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;

public class RepositoryFileProvider
extends BaseFileProvider<RepositoryFile> {
    public static final String PENTAHO_ENTERPRISE_REPOSITORY = "PentahoEnterpriseRepository";
    public static Repository repository;
    public static final String TRANSFORMATION = "transformation";
    public static final String JOB = "job";
    public static final String FOLDER = "folder";
    public static final String FILTER = "*.ktr|*.kjb";
    private RepositoryDirectoryInterface rootDirectory;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    public static final String NAME = "Pentaho Repository";
    public static final String TYPE = "repository";

    public Class<RepositoryFile> getFileClass() {
        return RepositoryFile.class;
    }

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    public RepositoryTree getTree() {
        RepositoryTree repositoryTree = new RepositoryTree(NAME);
        repositoryTree.setChildren(this.loadDirectoryTree().getChildren());
        return repositoryTree;
    }

    public List<RepositoryFile> getFiles(RepositoryFile file, String filters) {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(file.getType().equalsIgnoreCase(FOLDER) ? file.getPath() : file.getParent());
        RepositoryDirectory repositoryDirectory = RepositoryDirectory.build(null, repositoryDirectoryInterface);
        this.populateFolders(repositoryDirectory, repositoryDirectoryInterface);
        try {
            this.populateFiles(repositoryDirectory, repositoryDirectoryInterface, FILTER);
        }
        catch (KettleException ke) {
            ke.printStackTrace();
        }
        return repositoryDirectory.getChildren();
    }

    public boolean isAvailable() {
        return this.spoonSupplier.get() != null && this.spoonSupplier.get().rep != null;
    }

    public List<RepositoryFile> delete(List<RepositoryFile> files) {
        ArrayList<RepositoryFile> deletedFiles = new ArrayList<RepositoryFile>();
        for (RepositoryFile repositoryFile : files) {
            try {
                if (!this.deleteFile(repositoryFile)) continue;
                deletedFiles.add(repositoryFile);
            }
            catch (Exception exception) {}
        }
        return deletedFiles;
    }

    private void deleteJob(RepositoryFile repositoryFile) throws KettleException {
        StringObjectId objectId = new StringObjectId(repositoryFile.getObjectId());
        if (this.isJobOpened(repositoryFile.getObjectId(), repositoryFile.getParent(), repositoryFile.getName())) {
            throw new KettleJobException();
        }
        this.getRepository().deleteJob((ObjectId)objectId);
    }

    private void deleteTrans(RepositoryFile repositoryFile) throws KettleException {
        StringObjectId objectId = new StringObjectId(repositoryFile.getObjectId());
        if (this.isTransOpened(repositoryFile.getObjectId(), repositoryFile.getParent(), repositoryFile.getName())) {
            throw new KettleTransException();
        }
        this.getRepository().deleteTransformation((ObjectId)objectId);
    }

    private void deleteFolder(RepositoryFile repositoryFile) throws KettleException {
        this.isFileOpenedInFolder(repositoryFile.getPath());
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(repositoryFile.getPath());
        if (this.getRepository() instanceof RepositoryExtended) {
            ((RepositoryExtended)this.getRepository()).deleteRepositoryDirectory(repositoryDirectoryInterface, true);
        } else {
            this.getRepository().deleteRepositoryDirectory(repositoryDirectoryInterface);
        }
    }

    private boolean deleteFile(RepositoryFile repositoryFile) throws Exception {
        try {
            switch (repositoryFile.getType()) {
                case "job": {
                    this.deleteJob(repositoryFile);
                    break;
                }
                case "transformation": {
                    this.deleteTrans(repositoryFile);
                    break;
                }
                case "folder": {
                    this.deleteFolder(repositoryFile);
                }
            }
            return true;
        }
        catch (KettleJobException | KettleTransException ke) {
            throw ke;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isTransOpened(String id, String path, String name) {
        List openedTransFiles = this.getSpoon().delegates.trans.getTransformationList();
        for (TransMeta t : openedTransFiles) {
            if ((t.getObjectId() == null || !id.equals(t.getObjectId().getId())) && (!path.equals(t.getRepositoryDirectory().getPath()) || !name.equals(t.getName()))) continue;
            return true;
        }
        return false;
    }

    private boolean isJobOpened(String id, String path, String name) {
        List openedJobFiles = this.getSpoon().delegates.jobs.getJobList();
        for (JobMeta j : openedJobFiles) {
            if ((j.getObjectId() == null || !id.equals(j.getObjectId().getId())) && (!path.equals(j.getRepositoryDirectory().getPath()) || !name.equals(j.getName()))) continue;
            return true;
        }
        return false;
    }

    private void isFileOpenedInFolder(String path) throws KettleException {
        List openedTransFiles = this.getSpoon().delegates.trans.getTransformationList();
        for (TransMeta t : openedTransFiles) {
            if (t.getRepositoryDirectory().getPath() == null || !(t.getRepositoryDirectory().getPath() + "/").startsWith(path + "/")) continue;
            throw new KettleTransException();
        }
        List openedJobFiles = this.getSpoon().delegates.jobs.getJobList();
        for (JobMeta j : openedJobFiles) {
            if (j.getRepositoryDirectory().getPath() == null || !(j.getRepositoryDirectory().getPath() + "/").startsWith(path + "/")) continue;
            throw new KettleJobException();
        }
    }

    public RepositoryFile add(RepositoryFile folder) throws FileException {
        if (this.hasDupeFolder(folder.getParent(), folder.getName())) {
            throw new FileExistsException();
        }
        try {
            RepositoryDirectoryInterface repositoryDirectoryInterface = this.getRepository().createRepositoryDirectory(this.findDirectory(folder.getParent()), folder.getName());
            RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
            repositoryDirectory.setName(repositoryDirectoryInterface.getName());
            repositoryDirectory.setPath(repositoryDirectoryInterface.getPath());
            repositoryDirectory.setObjectId(repositoryDirectoryInterface.getObjectId().getId());
            repositoryDirectory.setParent(folder.getParent());
            return RepositoryDirectory.build(folder.getPath(), repositoryDirectoryInterface);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean hasDupeFolder(String parent, String name) {
        try {
            RepositoryDirectoryInterface rdi = this.getRepository().findDirectory(parent).findChild(name);
            return rdi != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RepositoryFile rename(RepositoryFile file, String newPath, boolean overwrite) {
        String newName = newPath.substring(newPath.lastIndexOf("/") + 1);
        try {
            return this.doRename(file, newName);
        }
        catch (KettleException e) {
            return null;
        }
    }

    public RepositoryFile doRename(RepositoryFile file, String newName) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = this.findDirectory(file.getParent());
        ObjectId objectId = null;
        switch (file.getType()) {
            case "job": {
                if (this.getRepository().exists(newName, repositoryDirectoryInterface, RepositoryObjectType.JOB)) {
                    throw new KettleObjectExistsException();
                }
                if (this.isJobOpened(file.getObjectId(), file.getParent(), file.getName())) {
                    throw new KettleJobException();
                }
                objectId = this.getRepository().renameJob(file::getObjectId, repositoryDirectoryInterface, newName);
                break;
            }
            case "transformation": {
                if (this.getRepository().exists(newName, repositoryDirectoryInterface, RepositoryObjectType.TRANSFORMATION)) {
                    throw new KettleObjectExistsException();
                }
                if (this.isTransOpened(file.getObjectId(), file.getParent(), file.getName())) {
                    throw new KettleJobException();
                }
                objectId = this.getRepository().renameTransformation(file::getObjectId, repositoryDirectoryInterface, newName);
                break;
            }
            case "folder": {
                RepositoryDirectoryInterface child;
                this.isFileOpenedInFolder(file.getPath());
                RepositoryDirectoryInterface parent = this.findDirectory(file.getPath()).getParent();
                if (parent == null) {
                    parent = this.findDirectory(file.getPath());
                }
                if ((child = parent.findChild(newName)) != null) {
                    throw new KettleObjectExistsException();
                }
                if (this.getRepository() instanceof RepositoryExtended) {
                    objectId = ((RepositoryExtended)this.getRepository()).renameRepositoryDirectory(file::getObjectId, null, newName, true);
                    break;
                }
                objectId = this.getRepository().renameRepositoryDirectory(file::getObjectId, null, newName);
            }
        }
        RepositoryFile repositoryFile = new RepositoryFile();
        return repositoryFile;
    }

    public RepositoryFile move(RepositoryFile file, String toPath, boolean overwrite) {
        return null;
    }

    private RepositoryElementInterface getObject(String objectId, String type) {
        if (type.equals(TRANSFORMATION)) {
            try {
                return this.getRepository().loadTransformation(() -> objectId, null);
            }
            catch (KettleException e) {
                return null;
            }
        }
        if (type.equals(JOB)) {
            try {
                return this.getRepository().loadJob(() -> objectId, null);
            }
            catch (KettleException e) {
                return null;
            }
        }
        return null;
    }

    public RepositoryFile copy(RepositoryFile file, String toPath, boolean overwrite) throws FileException {
        RepositoryElementInterface repositoryElementInterface = this.getObject(file.getObjectId(), file.getType());
        if (repositoryElementInterface != null) {
            repositoryElementInterface.setName(Util.getName(toPath));
            repositoryElementInterface.setObjectId(null);
            try {
                this.getRepository().save(repositoryElementInterface, null, null);
            }
            catch (KettleException kettleException) {}
        } else {
            throw new InvalidFileOperationException();
        }
        RepositoryFile repositoryFile = new RepositoryFile();
        return repositoryFile;
    }

    public boolean fileExists(RepositoryFile dir, String path) {
        RepositoryDirectoryInterface directoryInterface;
        try {
            directoryInterface = this.getRepository().findDirectory(dir.getPath());
        }
        catch (KettleException e) {
            return true;
        }
        if (directoryInterface != null) {
            RepositoryObjectType type = path.endsWith(".ktr") ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB;
            try {
                return this.getRepository().exists(Util.getName(path), directoryInterface, type);
            }
            catch (KettleException e) {
                return true;
            }
        }
        return true;
    }

    public boolean isSame(File file1, File file2) {
        return file1.getProvider().equals(file2.getProvider());
    }

    public InputStream readFile(RepositoryFile file) throws FileException {
        RepositoryElementInterface repositoryElementInterface = this.getObject(file.getObjectId(), file.getType());
        if (repositoryElementInterface != null) {
            String xml = null;
            if (repositoryElementInterface instanceof TransMeta) {
                TransMeta transMeta = (TransMeta)repositoryElementInterface;
                try {
                    xml = transMeta.getXML();
                }
                catch (KettleException e) {
                    return null;
                }
            }
            if (repositoryElementInterface instanceof JobMeta) {
                JobMeta jobMeta = (JobMeta)repositoryElementInterface;
                xml = jobMeta.getXML();
            }
            if (xml != null) {
                return new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            }
        }
        return null;
    }

    public RepositoryFile writeFile(InputStream inputStream, RepositoryFile destDir, String path, boolean overwrite) throws FileException {
        RepositoryObjectType type = this.getType(path);
        String name = Util.getName(path).replace(" ", "_");
        TransMeta repositoryElementInterface = null;
        if (type != null) {
            if (type.equals((Object)RepositoryObjectType.TRANSFORMATION)) {
                try {
                    repositoryElementInterface = new TransMeta(inputStream, null, false, null, null);
                }
                catch (KettleException e) {
                    return null;
                }
            } else if (type.equals((Object)RepositoryObjectType.JOB)) {
                try {
                    repositoryElementInterface = new JobMeta(inputStream, null, null);
                }
                catch (KettleException e) {
                    return null;
                }
            } else {
                throw new InvalidFileTypeException();
            }
        }
        try {
            RepositoryDirectoryInterface directoryInterface = this.getRepository().findDirectory(destDir.getPath());
            if (repositoryElementInterface != null) {
                repositoryElementInterface.setRepositoryDirectory(directoryInterface);
                this.getRepository().save((RepositoryElementInterface)repositoryElementInterface, null, null);
                return null;
            }
            return null;
        }
        catch (KettleException e) {
            return null;
        }
    }

    private RepositoryObjectType getType(String path) {
        if (path.endsWith(".ktr")) {
            return RepositoryObjectType.TRANSFORMATION;
        }
        if (path.endsWith(".kjb")) {
            return RepositoryObjectType.JOB;
        }
        return null;
    }

    public String getNewName(RepositoryFile destDir, String newPath) {
        RepositoryDirectoryInterface directoryInterface = null;
        RepositoryObjectType type = this.getType(newPath);
        try {
            directoryInterface = this.getRepository().findDirectory(destDir.getPath());
        }
        catch (KettleException e) {
            return newPath;
        }
        int index = 1;
        String name = Util.getName(newPath);
        String test = name + "_" + index;
        if (directoryInterface != null && type != null) {
            try {
                while (this.getRepository().exists(test, directoryInterface, type)) {
                    test = name + "_" + ++index;
                }
            }
            catch (KettleException e) {
                return test;
            }
        }
        test = newPath.replace(name, test);
        return test;
    }

    public RepositoryTree loadDirectoryTree() {
        if (this.getRepository() != null) {
            try {
                this.rootDirectory = this.getRepository() instanceof RepositoryExtended ? ((RepositoryExtended)this.getRepository()).loadRepositoryDirectoryTree(false) : this.getRepository().loadRepositoryDirectoryTree();
                RepositoryTree repositoryTree = new RepositoryTree(null);
                RepositoryDirectory repositoryDirectory = RepositoryDirectory.build(null, this.rootDirectory);
                this.populateFolders(repositoryDirectory, this.rootDirectory);
                boolean isPentahoRepository = this.getRepository().getRepositoryMeta().getId().equals(PENTAHO_ENTERPRISE_REPOSITORY);
                if (!isPentahoRepository) {
                    this.populateFiles(repositoryDirectory, this.rootDirectory, FILTER);
                }
                for (RepositoryFile child : repositoryDirectory.getChildren()) {
                    repositoryTree.addChild(child);
                }
                return repositoryTree;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void populateFiles(RepositoryDirectory repositoryDirectory, RepositoryDirectoryInterface repositoryDirectoryInterface, String filter) throws KettleException {
        if (this.getRepository() instanceof RepositoryExtended && !repositoryDirectory.getPath().equals("/")) {
            this.populateFilesLazy(repositoryDirectory, filter);
        } else {
            Date latestDate = null;
            for (RepositoryObjectInterface repositoryObjectInterface : this.getRepositoryElements(repositoryDirectoryInterface)) {
                RepositoryObject ro = (RepositoryObject)repositoryObjectInterface;
                String extension = ro.getObjectType().getExtension();
                if (!Util.isFiltered(extension, filter)) {
                    RepositoryFile repositoryFile = RepositoryFile.build(ro);
                    repositoryDirectory.addChild(repositoryFile);
                }
                if (latestDate != null && !ro.getModifiedDate().after(latestDate)) continue;
                latestDate = ro.getModifiedDate();
            }
            repositoryDirectory.setDate(latestDate);
        }
    }

    public void populateFilesLazy(RepositoryDirectory repositoryDirectory, String filter) {
        RepositoryRequest repositoryRequest = new RepositoryRequest();
        repositoryRequest.setPath(repositoryDirectory.getPath());
        repositoryRequest.setDepth(Integer.valueOf(1));
        repositoryRequest.setShowHidden(true);
        repositoryRequest.setTypes(RepositoryRequest.FILES_TYPE_FILTER.FILES);
        repositoryRequest.setChildNodeFilter(filter);
        RepositoryFileTree tree = this.getRepository().getUnderlyingRepository().getTree(repositoryRequest);
        for (RepositoryFileTree repositoryFileTree : tree.getChildren()) {
            org.pentaho.platform.api.repository2.unified.RepositoryFile repositoryFile = repositoryFileTree.getFile();
            RepositoryFile repositoryFile1 = RepositoryFile.build(repositoryDirectory.getPath(), repositoryFile, this.isAdmin());
            repositoryDirectory.addChild(repositoryFile1);
        }
    }

    private List<RepositoryElementMetaInterface> getRepositoryElements(RepositoryDirectoryInterface repositoryDirectoryInterface) {
        List elements = repositoryDirectoryInterface.getRepositoryObjects();
        if (elements == null) {
            try {
                return this.getRepository().getJobAndTransformationObjects(repositoryDirectoryInterface.getObjectId(), false);
            }
            catch (KettleException ke) {
                ke.printStackTrace();
            }
        } else {
            return elements;
        }
        return Collections.emptyList();
    }

    private void populateFolders(RepositoryDirectory repositoryDirectory, RepositoryDirectoryInterface repositoryDirectoryInterface) {
        if (this.getRepository() instanceof RepositoryExtended) {
            this.populateFoldersLazy(repositoryDirectory);
        } else {
            List children = repositoryDirectoryInterface.getChildren();
            repositoryDirectory.setHasChildren(!Utils.isEmpty((List)children));
            if (!Utils.isEmpty((List)children)) {
                for (RepositoryDirectoryInterface child : children) {
                    repositoryDirectory.addChild(RepositoryDirectory.build(repositoryDirectory.getPath(), child));
                }
            }
        }
    }

    public void populateFoldersLazy(RepositoryDirectory repositoryDirectory) {
        RepositoryRequest repositoryRequest = new RepositoryRequest(repositoryDirectory.getPath(), Boolean.valueOf(true), Integer.valueOf(1), null);
        repositoryRequest.setTypes(RepositoryRequest.FILES_TYPE_FILTER.FOLDERS);
        repositoryRequest.setIncludeSystemFolders(false);
        RepositoryFileTree tree = this.getRepository().getUnderlyingRepository().getTree(repositoryRequest);
        for (RepositoryFileTree repositoryFileTree : tree.getChildren()) {
            org.pentaho.platform.api.repository2.unified.RepositoryFile repositoryFile = repositoryFileTree.getFile();
            RepositoryDirectory repositoryDirectory1 = RepositoryDirectory.build(repositoryDirectory.getPath(), repositoryFile, this.isAdmin());
            repositoryDirectory.addChild(repositoryDirectory1);
        }
    }

    private Spoon getSpoon() {
        return this.spoonSupplier.get();
    }

    private RepositoryDirectoryInterface findDirectory(String path) {
        return this.rootDirectory.findDirectory(path);
    }

    private Boolean isAdmin() {
        return this.getRepository().getUserInfo().isAdmin();
    }

    public RepositoryFile getParent(RepositoryFile file) {
        RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
        repositoryDirectory.setPath(file.getParent());
        return repositoryDirectory;
    }

    public void clearProviderCache() {
    }

    public RepositoryFile getFile(RepositoryFile file) {
        return null;
    }

    public void setFileProperties(FileDetails fileDetails, FileDialogOperation fileDialogOperation) {
        RepositoryObject repositoryObject = new RepositoryObject();
        repositoryObject.setObjectId(() -> ((FileDetails)fileDetails).getObjectId());
        repositoryObject.setName(fileDetails.getName());
        try {
            repositoryObject.setRepositoryDirectory(this.getRepository().findDirectory(fileDetails.getParentPath()));
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        if (fileDetails.getType() != null) {
            repositoryObject.setObjectType(fileDetails.getType().equals(TRANSFORMATION) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB);
        }
        fileDialogOperation.setRepositoryObject((RepositoryObjectInterface)repositoryObject);
        fileDialogOperation.setProvider(fileDetails.getProvider());
        fileDialogOperation.setFilename(fileDetails.getName());
    }

    private Repository getRepository() {
        return RepositoryBrowserController.repository != null ? RepositoryBrowserController.repository : this.spoonSupplier.get().getRepository();
    }
}

