/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.local.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseEntity;
import org.pentaho.di.plugins.fileopensave.api.providers.File;

public class LocalFile
extends BaseEntity
implements File {
    private static final String TYPE = "file";

    public String getType() {
        return TYPE;
    }

    public String getProvider() {
        return "local";
    }

    public static LocalFile create(String parent, Path path) {
        LocalFile localFile = new LocalFile();
        localFile.setName(path.getFileName().toString());
        localFile.setPath(path.toString());
        localFile.setParent(parent);
        try {
            localFile.setDate(new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
        }
        catch (IOException e) {
            localFile.setDate(new Date());
        }
        localFile.setRoot("Local");
        localFile.setCanEdit(true);
        return localFile;
    }
}

