/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.extension;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public abstract class MetaStoreCopyExtensionPoint
implements ExtensionPointInterface {
    public static final String VFS_CONNECTIONS = "VFS Connections";
    private final MetastoreLocator metastoreLocator;
    private final Supplier<ConnectionManager> connectionManagerSupplier = ConnectionManager::getInstance;

    public MetaStoreCopyExtensionPoint(MetastoreLocator metastoreLocator) {
        this.metastoreLocator = metastoreLocator;
    }

    protected void asyncImportAll(AbstractMeta meta, Runnable callback) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.submit(() -> {
            this.importAll(meta);
            callback.run();
        });
    }

    protected void importAll(AbstractMeta meta) {
        if (meta.getEmbeddedMetaStore() != null && this.metastoreLocator != null) {
            this.getConnectionManager().copy((IMetaStore)meta.getEmbeddedMetaStore(), this.metastoreLocator.getMetastore());
        }
    }

    protected void exportAll(AbstractMeta meta) {
        if (meta.getEmbeddedMetaStore() != null && this.metastoreLocator != null) {
            this.getConnectionManager().clear((IMetaStore)meta.getEmbeddedMetaStore());
            this.getConnectionManager().copy(this.metastoreLocator.getMetastore(), (IMetaStore)meta.getEmbeddedMetaStore());
        }
    }

    private ConnectionManager getConnectionManager() {
        return this.connectionManagerSupplier.get();
    }
}

