/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.endpoints;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.IOException;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.InvalidFileProviderException;
import org.pentaho.di.plugins.fileopensave.providers.ProviderService;

@Provider
@Produces(value={"application/json"})
public class JsonProvider
extends JacksonJaxbJsonProvider {
    public static final String PROVIDER = "provider";

    public JsonProvider(ProviderService providerService) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(File.class, (JsonDeserializer)new FileDeserializer(providerService));
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)simpleModule);
        this.setMapper(objectMapper);
    }

    public static class FileDeserializer
    extends StdDeserializer<File> {
        private transient ProviderService providerService;

        public FileDeserializer(ProviderService providerService) {
            this(File.class);
            this.providerService = providerService;
        }

        public FileDeserializer(Class<?> vc) {
            super(vc);
        }

        public File deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            String type = jsonNode.get(JsonProvider.PROVIDER).asText();
            try {
                Class clazz = this.providerService.get(type).getFileClass();
                if (clazz != null) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    return (File)objectMapper.readValue(objectMapper.treeAsTokens((TreeNode)jsonNode), clazz);
                }
            }
            catch (InvalidFileProviderException e) {
                return null;
            }
            return null;
        }
    }
}

