/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.plugins.fileopensave.api.file.FileDetails;
import org.pentaho.di.ui.core.FileDialogOperation;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class FileOpenSaveDialog
extends ThinDialog
implements FileDetails {
    private static final Class<?> PKG = FileOpenSaveDialog.class;
    public static final String STATE_SAVE = "save";
    public static final String STATE_OPEN = "open";
    public static final String SELECT_FOLDER = "selectFolder";
    private Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final int OPTIONS = 68720;
    private static final String THIN_CLIENT_HOST = "THIN_CLIENT_HOST";
    private static final String THIN_CLIENT_PORT = "THIN_CLIENT_PORT";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String HELP_URL = Const.getDocUrl((String)"Products/Work_with_transformations#Open_a_transformation");
    public static final String PATH_PARAM = "path";
    public static final String USE_SCHEMA_PARAM = "useSchema";
    public static final String CONNECTION_PARAM = "connection";
    public static final String PROVIDER_PARAM = "provider";
    public static final String PROVIDER_FILTER_PARAM = "providerFilter";
    public static final String FILTER_PARAM = "filter";
    public static final String DEFAULT_FILTER_PARAM = "defaultFilter";
    public static final String CONNECTION_FILTER_PARAM = "connectionTypes";
    public static final String ORIGIN_PARAM = "origin";
    public static final String FILENAME_PARAM = "filename";
    public static final String FILE_TYPE_PARM = "fileType";
    public static final String OBJECT_ID_PARAM = "objectId";
    public static final String NAME_PARAM = "name";
    public static final String PARENT_PARAM = "parent";
    public static final String TYPE_PARAM = "type";
    private String objectId;
    private String name;
    private String path;
    private String parentPath;
    private String type;
    private String connection;
    private String provider;
    private LogChannelInterface log;

    public FileOpenSaveDialog(Shell shell, int width, int height, LogChannelInterface logger) {
        super(shell, width, height);
        this.log = logger;
    }

    private void addParameter(List<NameValuePair> parameters, String name, String value) {
        if (!Utils.isEmpty((CharSequence)value)) {
            parameters.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    public void open(FileDialogOperation fileDialogOperation) {
        String dialogPath = fileDialogOperation.getPath() != null ? fileDialogOperation.getPath() : fileDialogOperation.getStartDir();
        try {
            dialogPath = URLEncoder.encode(dialogPath, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder clientPath = new StringBuilder();
        String cmd = fileDialogOperation.getCommand();
        clientPath.append(FileOpenSaveDialog.getClientPath());
        clientPath.append(!Utils.isEmpty((CharSequence)cmd) ? "#!/" + cmd : "");
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        this.addParameter(parameters, PATH_PARAM, dialogPath);
        this.addParameter(parameters, CONNECTION_PARAM, fileDialogOperation.getConnection());
        this.addParameter(parameters, PROVIDER_PARAM, fileDialogOperation.getProvider());
        this.addParameter(parameters, PROVIDER_FILTER_PARAM, fileDialogOperation.getProviderFilter());
        this.addParameter(parameters, FILTER_PARAM, fileDialogOperation.getFilter());
        this.addParameter(parameters, DEFAULT_FILTER_PARAM, fileDialogOperation.getDefaultFilter());
        this.addParameter(parameters, ORIGIN_PARAM, fileDialogOperation.getOrigin());
        this.addParameter(parameters, FILENAME_PARAM, fileDialogOperation.getFilename());
        this.addParameter(parameters, FILE_TYPE_PARM, fileDialogOperation.getFileType());
        this.addParameter(parameters, CONNECTION_FILTER_PARAM, fileDialogOperation.getConnectionTypeFilter());
        if (fileDialogOperation.getUseSchemaPath()) {
            this.addParameter(parameters, USE_SCHEMA_PARAM, "true");
        }
        String queryParams = URLEncodedUtils.format(parameters, (String)"UTF-8");
        clientPath.append("?").append(queryParams);
        String title = Utils.isEmpty((CharSequence)cmd) ? "" : BaseMessages.getString(PKG, (String)("FileOpenSaveDialog.dialog." + cmd + ".title"), (String[])new String[0]);
        super.createDialog(fileDialogOperation.getTitle() != null ? fileDialogOperation.getTitle() : StringUtils.capitalize((String)title), FileOpenSaveDialog.getRepoURL(clientPath.toString()), 68720, this.LOGO);
        this.dialog.setMinimumSize(545, 458);
        new BrowserFunction(this.browser, "close"){

            public Object function(Object[] arguments) {
                if (Const.isRunningOnWebspoonMode()) {
                    Runnable execute = () -> FileOpenSaveDialog.this.closeBrowser(FileOpenSaveDialog.this.browser);
                    FileOpenSaveDialog.this.display.asyncExec(execute);
                } else {
                    FileOpenSaveDialog.this.closeBrowser(FileOpenSaveDialog.this.browser);
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "select"){

            public Object function(Object[] arguments) {
                if (Const.isRunningOnWebspoonMode()) {
                    Runnable execute = () -> FileOpenSaveDialog.this.closeBrowserWithParameters(arguments);
                    FileOpenSaveDialog.this.display.asyncExec(execute);
                } else {
                    FileOpenSaveDialog.this.closeBrowserWithParameters(arguments);
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "help"){

            public Object function(Object[] arguments) {
                FileOpenSaveDialog.this.openHelpDialog();
                return true;
            }
        };
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void closeBrowserWithParameters(Object[] arguments) {
        try {
            this.setProperties(arguments);
            this.closeBrowser(this.browser);
        }
        catch (Exception e) {
            this.log.logError("Error in processing select() from file-open-save app: ", (Throwable)e);
        }
    }

    private void closeBrowser(Browser browser) {
        browser.dispose();
        this.dialog.close();
        this.dialog.dispose();
    }

    private void openHelpDialog() {
        HelpUtils.openHelpDialog((Shell)this.dialog, (String)"", (String)HELP_URL);
    }

    private void setProperties(Object[] arguments) throws ParseException {
        if (arguments.length == 1) {
            String jsonString = (String)arguments[0];
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse(jsonString);
            this.objectId = (String)jsonObject.get((Object)OBJECT_ID_PARAM);
            this.name = (String)jsonObject.get((Object)NAME_PARAM);
            this.path = (String)jsonObject.get((Object)PATH_PARAM);
            this.parentPath = (String)jsonObject.get((Object)PARENT_PARAM);
            this.connection = (String)jsonObject.get((Object)CONNECTION_PARAM);
            this.provider = (String)jsonObject.get((Object)PROVIDER_PARAM);
            this.type = (String)jsonObject.get((Object)TYPE_PARAM);
        }
    }

    private static String getClientPath() {
        Properties properties = new Properties();
        try (InputStream inputStream = FileOpenSaveDialog.class.getClassLoader().getResourceAsStream("project.properties");){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties.getProperty("CLIENT_PATH");
    }

    private static Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    private static String getRepoURL(String path) {
        Integer port;
        String host;
        if (Const.isRunningOnWebspoonMode()) {
            return System.getProperty("KETTLE_CONTEXT_PATH", "") + "/osgi" + path;
        }
        try {
            host = FileOpenSaveDialog.getKettleProperty(THIN_CLIENT_HOST);
            port = Integer.valueOf(FileOpenSaveDialog.getKettleProperty(THIN_CLIENT_PORT));
        }
        catch (Exception e) {
            host = LOCALHOST;
            port = FileOpenSaveDialog.getOsgiServicePort();
        }
        return "http://" + host + ":" + port + path;
    }

    private static String getKettleProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }
}

