/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osjava.sj.loader.util.BaseProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlProperties
extends BaseProperties {
    public XmlProperties() {
    }

    public XmlProperties(Properties props) {
        super(props);
    }

    @Override
    public void load(InputStream in) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document document = null;
        try {
            builder = factory.newDocumentBuilder();
            document = builder.parse(in);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Unable to get DocumentBuilder from factory. " + pce.getMessage());
        }
        catch (SAXException se) {
            throw new IOException("Unable to parse document. " + se.getMessage());
        }
        if (document != null) {
            this.loadDocument(document);
        }
    }

    private void loadDocument(Document document) {
        Element root = document.getDocumentElement();
        String level = root.getNodeName();
        this.processChildren(level, root);
    }

    private void processChildren(String level, Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.addNode(level, child);
            if (!child.hasAttributes()) continue;
            String attributeLevel = level + this.getDelimiter() + child.getNodeName();
            this.addAttributes(attributeLevel, child.getAttributes());
        }
    }

    private void addNode(String level, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                level = level + this.getDelimiter() + node.getNodeName();
                break;
            }
            case 3: {
                this.store(level, node.getNodeValue());
            }
        }
        this.processChildren(level, node);
    }

    private void addAttributes(String level, NamedNodeMap map) {
        for (int i = 0; i < map.getLength(); ++i) {
            Node attribute = map.item(i);
            String attributeLevel = level + this.getDelimiter() + attribute.getNodeName();
            this.store(attributeLevel, attribute.getNodeValue());
        }
    }

    private void store(String name, String value) {
        if (value.trim().length() > 0) {
            this.setProperty(name, value);
        }
    }
}

