/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import com.mongodb.BasicDBList;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ReplicaSetStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.mongo.BaseMessages;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.MongoUtilLogger;
import org.pentaho.mongo.Util;
import org.pentaho.mongo.wrapper.DefaultMongoClientFactory;
import org.pentaho.mongo.wrapper.MongoClientFactory;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoDBAction;
import org.pentaho.mongo.wrapper.collection.DefaultMongoCollectionWrapper;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;

public class ConnectionStringMongoClientWrapper
implements MongoClientWrapper {
    static MongoClientFactory clientFactory = new DefaultMongoClientFactory();
    private final MongoClient mongo;
    private final MongoUtilLogger log;
    private final String connectionString;
    private static Class<?> PKG = ConnectionStringMongoClientWrapper.class;
    public static final String LOCAL_DB = "local";
    public static final String REPL_SET_COLLECTION = "system.replset";
    public static final String REPL_SET_SETTINGS = "settings";
    public static final String REPL_SET_LAST_ERROR_MODES = "getLastErrorModes";
    public static final String REPL_SET_MEMBERS = "members";

    ConnectionStringMongoClientWrapper(String connectionString, MongoUtilLogger log) throws MongoDbException {
        this.connectionString = connectionString;
        this.log = log;
        this.mongo = this.getClientFactory(connectionString).getConnectionStringMongoClient(connectionString);
    }

    public MongoClientFactory getClientFactory(String connectionString) {
        return clientFactory;
    }

    MongoClient getMongo() {
        return this.mongo;
    }

    @Override
    public Set<String> getCollectionsNames(String dB) throws MongoDbException {
        try {
            return this.getDb(dB).getCollectionNames();
        }
        catch (Exception e) {
            if (e instanceof MongoDbException) {
                throw (MongoDbException)e;
            }
            throw new MongoDbException(e);
        }
    }

    @Override
    public List<String> getIndexInfo(String dbName, String collection) throws MongoDbException {
        try {
            DBCollection coll;
            DB db = this.getDb(dbName);
            if (db == null) {
                throw new MongoDbException(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.ErrorMessage.NonExistentDB", dbName));
            }
            if (Util.isEmpty(collection)) {
                throw new MongoDbException(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.ErrorMessage.NoCollectionSpecified"));
            }
            if (!db.collectionExists(collection)) {
                db.createCollection(collection, null);
            }
            if ((coll = db.getCollection(collection)) == null) {
                throw new MongoDbException(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.ErrorMessage.UnableToGetInfoForCollection", collection));
            }
            List collInfo = coll.getIndexInfo();
            ArrayList<String> result = new ArrayList<String>();
            if (collInfo == null || collInfo.isEmpty()) {
                throw new MongoDbException(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.ErrorMessage.UnableToGetInfoForCollection", collection));
            }
            for (DBObject index : collInfo) {
                result.add(index.toString());
            }
            return result;
        }
        catch (Exception e) {
            this.log.error(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.ErrorMessage.GeneralError.Message") + ":\n\n" + e.getMessage(), e);
            if (e instanceof MongoDbException) {
                throw (MongoDbException)e;
            }
            throw new MongoDbException(e);
        }
    }

    @Override
    public List<String> getDatabaseNames() throws MongoDbException {
        try {
            return this.getMongo().getDatabaseNames();
        }
        catch (Exception e) {
            throw new MongoDbException(e);
        }
    }

    protected DB getDb(String dbName) throws MongoDbException {
        try {
            return this.getMongo().getDB(dbName);
        }
        catch (Exception e) {
            throw new MongoDbException(e);
        }
    }

    @Override
    public List<String> getAllTags() throws MongoDbException {
        return this.setupAllTags(this.getRepSetMemberRecords());
    }

    protected List<String> setupAllTags(BasicDBList members) {
        HashSet<String> tempTags = new HashSet<String>();
        if (members != null && members.size() > 0) {
            for (Object member : members) {
                DBObject tags;
                if (member == null || (tags = (DBObject)((DBObject)member).get("tags")) == null) continue;
                for (String tagName : tags.keySet()) {
                    String tagVal = tags.get(tagName).toString();
                    String combined = ConnectionStringMongoClientWrapper.quote(tagName) + " : " + ConnectionStringMongoClientWrapper.quote(tagVal);
                    tempTags.add(combined);
                }
            }
        }
        return new ArrayList<String>(tempTags);
    }

    private void logInfo(String message) {
        if (this.log != null) {
            this.log.info(message);
        }
    }

    protected static String quote(String string) {
        if (string.indexOf(34) >= 0) {
            string = string.replace("\"", "\\\"");
        }
        string = "\"" + string + "\"";
        return string;
    }

    private BasicDBList getRepSetMemberRecords() throws MongoDbException {
        String noReplicaSetMembersDefined = BaseMessages.getString(PKG, "MongoConnectionStringWrapper.Message.Warning.NoReplicaSetMembersDefined");
        BasicDBList setMembers = null;
        try {
            DB local = this.getDb(LOCAL_DB);
            if (local != null) {
                DBCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    DBObject config = replset.findOne();
                    if (config != null) {
                        Object members = config.get(REPL_SET_MEMBERS);
                        if (members instanceof BasicDBList) {
                            if (((BasicDBList)members).size() == 0) {
                                this.logInfo(noReplicaSetMembersDefined);
                            } else {
                                setMembers = (BasicDBList)members;
                            }
                        } else {
                            this.logInfo(noReplicaSetMembersDefined);
                        }
                    } else {
                        this.logInfo(noReplicaSetMembersDefined);
                    }
                } else {
                    this.logInfo(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.Message.Warning.ReplicaSetCollectionUnavailable"));
                }
            } else {
                this.logInfo(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.Message.Warning.LocalDBNotAvailable"));
            }
        }
        catch (Exception ex) {
            throw new MongoDbException(ex);
        }
        finally {
            if (this.getMongo() != null) {
                this.getMongo().close();
            }
        }
        return setMembers;
    }

    @Override
    public List<String> getReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets) throws MongoDbException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (DBObject object : this.checkForReplicaSetMembersThatSatisfyTagSets(tagSets, this.getRepSetMemberRecords())) {
                result.add(object.toString());
            }
            return result;
        }
        catch (Exception ex) {
            if (ex instanceof MongoDbException) {
                throw (MongoDbException)ex;
            }
            throw new MongoDbException(BaseMessages.getString(PKG, "MongoConnectionStringWrapper.ErrorMessage.UnableToGetReplicaSetMembers"), ex);
        }
    }

    protected List<DBObject> checkForReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets, BasicDBList members) {
        ArrayList<DBObject> satisfy = new ArrayList<DBObject>();
        if (members != null && !members.isEmpty()) {
            for (Object m : members) {
                DBObject tags;
                if (m == null || (tags = (DBObject)((DBObject)m).get("tags")) == null) continue;
                for (DBObject toMatch : tagSets) {
                    boolean match = true;
                    for (String tagName : toMatch.keySet()) {
                        String tagValue = toMatch.get(tagName).toString();
                        Object matchVal = tags.get(tagName);
                        if (matchVal != null && matchVal.toString().equals(tagValue)) continue;
                        match = false;
                        break;
                    }
                    if (!match || satisfy.contains(m)) continue;
                    satisfy.add((DBObject)m);
                }
            }
        }
        return satisfy;
    }

    @Override
    public List<String> getLastErrorModes() throws MongoDbException {
        ArrayList<String> customLastErrorModes = new ArrayList<String>();
        DB local = this.getDb(LOCAL_DB);
        if (local != null) {
            try {
                DBCollection replset = local.getCollection(REPL_SET_COLLECTION);
                DBObject config = replset.findOne();
                this.extractLastErrorModes(config, customLastErrorModes);
            }
            catch (Exception e) {
                throw new MongoDbException(e);
            }
        }
        return customLastErrorModes;
    }

    protected void extractLastErrorModes(DBObject config, List<String> customLastErrorModes) {
        Object getLastErrModes;
        Object settings;
        if (config != null && (settings = config.get(REPL_SET_SETTINGS)) != null && (getLastErrModes = ((DBObject)settings).get(REPL_SET_LAST_ERROR_MODES)) != null) {
            for (String m : ((DBObject)getLastErrModes).keySet()) {
                customLastErrorModes.add(m);
            }
        }
    }

    @Override
    public List<MongoCredential> getCredentialList() {
        return this.getMongo().getCredentialsList();
    }

    protected MongoCollectionWrapper wrap(DBCollection collection) {
        return new DefaultMongoCollectionWrapper(collection);
    }

    @Override
    public MongoCollectionWrapper createCollection(String db, String name) throws MongoDbException {
        return this.wrap(this.getDb(db).createCollection(name, null));
    }

    @Override
    public MongoCollectionWrapper getCollection(String db, String name) throws MongoDbException {
        return this.wrap(this.getDb(db).getCollection(name));
    }

    @Override
    public void dispose() throws MongoDbException {
        this.getMongo().close();
    }

    @Override
    public <ReturnType> ReturnType perform(String db, MongoDBAction<ReturnType> action) throws MongoDbException {
        return action.perform(this.getDb(db));
    }

    @Override
    public ReplicaSetStatus getReplicaSetStatus() {
        return this.getMongo().getReplicaSetStatus();
    }
}

