/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.util;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import flexjson.JSONDeserializer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.pentaho.di.core.Const;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IClonableDocumentAnalyzer;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IDocumentAnalyzer;
import org.pentaho.metaverse.api.IDocumentController;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.model.Operation;
import org.pentaho.metaverse.api.model.Operations;
import org.pentaho.metaverse.graph.LineageGraphCompletionService;
import org.pentaho.metaverse.graph.LineageGraphMap;
import org.pentaho.metaverse.impl.MetaverseBuilder;
import org.pentaho.metaverse.impl.MetaverseConfig;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseBeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaverseUtil {
    private static final Logger log = LoggerFactory.getLogger(MetaverseUtil.class);
    public static final String MESSAGE_PREFIX_NODETYPE = "USER.nodetype.";
    public static final String MESSAGE_PREFIX_LINKTYPE = "USER.linktype.";
    public static final String MESSAGE_PREFIX_CATEGORY = "USER.category.";
    public static final String MESSAGE_FAILED_PREFIX = "!";
    protected static IDocumentController documentController = null;

    public static IDocumentController getDocumentController() {
        if (documentController != null) {
            return documentController;
        }
        try {
            documentController = (IDocumentController)MetaverseBeanUtil.getInstance().get("IDocumentController");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return documentController;
    }

    public static void setDocumentController(IDocumentController docController) {
        documentController = docController;
    }

    public static IDocument createDocument(INamespace namespace, Object content, String id, String name, String extension, String mimeType) {
        IDocument metaverseDocument = MetaverseUtil.getDocumentController().getMetaverseObjectFactory().createDocumentObject();
        metaverseDocument.setNamespace(namespace);
        metaverseDocument.setContent(content);
        metaverseDocument.setStringID(id);
        metaverseDocument.setName(name);
        metaverseDocument.setExtension(extension);
        metaverseDocument.setMimeType(mimeType);
        metaverseDocument.setProperty("path", (Object)id);
        metaverseDocument.setProperty("namespace", (Object)namespace.getNamespaceId());
        return metaverseDocument;
    }

    public static void addLineageGraph(IDocument document, Graph graph) throws MetaverseException {
        if (document == null) {
            throw new MetaverseException(Messages.getString("ERROR.Document.IsNull"));
        }
        IDocumentController docController = MetaverseUtil.getDocumentController();
        if (docController != null) {
            MetaverseBuilder metaverseBuilder = new MetaverseBuilder(graph);
            docController.setMetaverseBuilder((IMetaverseBuilder)metaverseBuilder);
            List matchingAnalyzers = docController.getDocumentAnalyzers("ktr");
            if (matchingAnalyzers != null) {
                for (IDocumentAnalyzer analyzer : matchingAnalyzers) {
                    if (analyzer instanceof IClonableDocumentAnalyzer) {
                        analyzer = ((IClonableDocumentAnalyzer)analyzer).cloneAnalyzer();
                    } else {
                        log.debug(Messages.getString("WARNING.CannotCloneAnalyzer"), (Object)analyzer);
                    }
                    Runnable analyzerRunner = MetaverseUtil.getAnalyzerRunner(analyzer, document);
                    Graph g = graph != null ? graph : new TinkerGraph();
                    Future<Graph> transAnalysis = LineageGraphCompletionService.getInstance().submit(analyzerRunner, g);
                    LineageGraphMap.getInstance().put(document.getContent(), transAnalysis);
                }
            }
        }
    }

    public static void enhanceEdge(Edge edge) {
        String type = edge.getLabel();
        String localizedType = Messages.getString(MESSAGE_PREFIX_LINKTYPE + type);
        if (!localizedType.startsWith(MESSAGE_FAILED_PREFIX)) {
            edge.setProperty("typeLocale", (Object)localizedType);
        }
    }

    public static void enhanceVertex(Vertex vertex) {
        String type = (String)vertex.getProperty("type");
        String localizedType = Messages.getString(MESSAGE_PREFIX_NODETYPE + type);
        if (!localizedType.startsWith(MESSAGE_FAILED_PREFIX)) {
            vertex.setProperty("typeLocale", (Object)localizedType);
        }
        String category = DictionaryHelper.getCategoryForType((String)type);
        vertex.setProperty("category", (Object)category);
        String color = DictionaryHelper.getColorForCategory((String)category);
        vertex.setProperty("color", (Object)color);
        String localizedCat = Messages.getString(MESSAGE_PREFIX_CATEGORY + category);
        if (!localizedCat.startsWith(MESSAGE_FAILED_PREFIX)) {
            vertex.setProperty("categoryLocale", (Object)localizedCat);
        }
    }

    public static Operations convertOperationsStringToMap(String operations) {
        Operations resultOps = null;
        if (!Const.isEmpty((String)operations)) {
            try {
                Map rawOpsMap = (Map)new JSONDeserializer().use("values.values", Operation.class).deserialize(operations);
                resultOps = new Operations();
                for (String key : rawOpsMap.keySet()) {
                    resultOps.put((Enum)ChangeType.forValue((String)key), (Object)((List)rawOpsMap.get(key)));
                }
            }
            catch (Exception e) {
                resultOps = null;
            }
        }
        return resultOps;
    }

    public static Runnable getAnalyzerRunner(final IDocumentAnalyzer analyzer, final IDocument document) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    MetaverseComponentDescriptor docDescriptor = new MetaverseComponentDescriptor(document.getName(), "Transformation", document.getNamespace());
                    if (document.getContext() != null) {
                        docDescriptor.setContext(document.getContext());
                    }
                    analyzer.analyze((IComponentDescriptor)docDescriptor, (Object)document);
                }
                catch (MetaverseAnalyzerException mae) {
                    throw new RuntimeException(Messages.getString("ERROR.AnalyzingDocument", document.getNamespaceId()), mae);
                }
            }
        };
    }

    public static void delay() {
        MetaverseConfig metaverseConfig = MetaverseConfig.getInstance();
        if (metaverseConfig != null && metaverseConfig.getLineageDelay() > 0) {
            try {
                Thread.sleep(metaverseConfig.getLineageDelay() * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

