/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.util;

import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.metaverse.messages.Messages;

@Deprecated
public class DateRangeFolderFilenameFilter
implements FilenameFilter {
    protected SimpleDateFormat format;
    private Date startingDate;
    private Date endingDate;

    public DateRangeFolderFilenameFilter(SimpleDateFormat format) {
        this.format = format;
    }

    public DateRangeFolderFilenameFilter(SimpleDateFormat format, Date startingDate) {
        this.format = format;
        this.startingDate = startingDate;
    }

    public DateRangeFolderFilenameFilter(SimpleDateFormat format, String startingDate) {
        this.format = format;
        this.setStartingDate(startingDate);
    }

    public DateRangeFolderFilenameFilter(SimpleDateFormat format, Date startingDate, Date endingDate) {
        this.format = format;
        this.startingDate = startingDate;
        this.endingDate = endingDate;
    }

    public DateRangeFolderFilenameFilter(SimpleDateFormat format, String startingDate, String endingDate) {
        this.format = format;
        this.setStartingDate(startingDate);
        this.setEndingDate(endingDate);
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
    }

    public void setEndingDate(String endingDate) {
        this.endingDate = this.parseDateString(endingDate);
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public void setStartingDate(String startingDate) {
        this.startingDate = this.parseDateString(startingDate);
    }

    protected Date parseDateString(String dateString) throws IllegalArgumentException {
        if (dateString == null) {
            return null;
        }
        try {
            return this.format.parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(Messages.getString("ERROR.CouldNotParseDateFromString", dateString), e);
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        if (dir.isDirectory()) {
            try {
                Date folderDate = this.format.parse(name);
                int startCompare = 0;
                int endCompare = 0;
                if (this.startingDate != null) {
                    startCompare = folderDate.compareTo(this.startingDate);
                }
                if (this.endingDate != null) {
                    endCompare = folderDate.compareTo(this.endingDate);
                }
                return startCompare >= 0 && endCompare <= 0;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return false;
    }
}

