/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.metaverse.api.AnalysisContext;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.model.BaseResourceInfo;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class MongoDbResourceInfo
extends BaseResourceInfo
implements IExternalResourceInfo {
    public static final String JSON_PROPERTY_PORT = "port";
    public static final String JSON_PROPERTY_USERNAME = "username";
    public static final String JSON_PROPERTY_PASSWORD = "password";
    public static final String JSON_PROPERTY_DATABASE_NAME = "databaseName";
    public static final String JSON_PROPERTY_CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String JSON_PROPERTY_HOST_NAMES = "hostNames";
    public static final String JSON_PROPERTY_SOCKET_TIMEOUT = "socketTimeout";
    public static final String JSON_PROPERTY_USE_ALL_REPLICA_SET_MEMBERS = "useAllReplicaSetMembers";
    public static final String JSON_PROPERTY_USE_KERBEROS_AUTHENTICATION = "useKerberosAuthentication";
    public static final String JSON_PROPERTY_COLLECTION = "collection";
    private String database;
    private String port;
    private String hostNames;
    private String user;
    private String password;
    private boolean useAllReplicaSetMembers;
    private boolean useKerberosAuthentication;
    private String connectTimeout;
    private String socketTimeout;
    private String collection;

    public MongoDbResourceInfo(MongoDbMeta mongoDbMeta) {
        this(mongoDbMeta, (IAnalysisContext)new AnalysisContext("runtime"));
    }

    public MongoDbResourceInfo(MongoDbMeta mongoDbMeta, IAnalysisContext context) {
        this.setName(this.substituteIfNeeded(mongoDbMeta.getDbName(), mongoDbMeta, context));
        this.setDatabase(this.substituteIfNeeded(mongoDbMeta.getDbName(), mongoDbMeta, context));
        this.setPort(this.substituteIfNeeded(mongoDbMeta.getPort(), mongoDbMeta, context));
        this.setHostNames(this.substituteIfNeeded(mongoDbMeta.getHostnames(), mongoDbMeta, context));
        this.setUser(this.substituteIfNeeded(mongoDbMeta.getAuthenticationUser(), mongoDbMeta, context));
        this.setPassword(this.substituteIfNeeded(mongoDbMeta.getAuthenticationPassword(), mongoDbMeta, context));
        this.setUseAllReplicaSetMembers(mongoDbMeta.getUseAllReplicaSetMembers());
        this.setUseKerberosAuthentication(mongoDbMeta.getUseKerberosAuthentication());
        this.setConnectTimeout(this.substituteIfNeeded(mongoDbMeta.getConnectTimeout(), mongoDbMeta, context));
        this.setSocketTimeout(this.substituteIfNeeded(mongoDbMeta.getSocketTimeout(), mongoDbMeta, context));
        this.setCollection(this.substituteIfNeeded(mongoDbMeta.getCollection(), mongoDbMeta, context));
    }

    public MongoDbResourceInfo(String hostNames, String port, String database) {
        this.setHostNames(hostNames);
        this.setPort(port);
        this.setDatabase(database);
    }

    private String substituteIfNeeded(String value, MongoDbMeta meta, IAnalysisContext context) {
        String contextName = context != null ? context.getContextName() : "";
        String ret = contextName.equals("runtime") ? meta.getParentStepMeta().getParentTransMeta().environmentSubstitute(value) : value;
        return ret;
    }

    public String getType() {
        return "MongoDbResource";
    }

    @JsonProperty(value="connectionTimeout")
    public String getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(String connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @JsonProperty(value="databaseName")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @JsonProperty(value="hostNames")
    public String getHostNames() {
        return this.hostNames;
    }

    public void setHostNames(String hostNames) {
        this.hostNames = hostNames;
    }

    @JsonProperty(value="port")
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @JsonProperty(value="socketTimeout")
    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @JsonProperty(value="useAllReplicaSetMembers")
    public boolean isUseAllReplicaSetMembers() {
        return this.useAllReplicaSetMembers;
    }

    public void setUseAllReplicaSetMembers(boolean useAllReplicaSetMembers) {
        this.useAllReplicaSetMembers = useAllReplicaSetMembers;
    }

    @JsonProperty(value="useKerberosAuthentication")
    public boolean isUseKerberosAuthentication() {
        return this.useKerberosAuthentication;
    }

    public void setUseKerberosAuthentication(boolean useKerberosAuthentication) {
        this.useKerberosAuthentication = useKerberosAuthentication;
    }

    @JsonProperty(value="username")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)password);
    }

    @JsonProperty(value="password")
    protected String getEncryptedPassword() {
        if (StringUtils.isEmpty((String)this.password)) {
            return "";
        }
        return "Encrypted " + Encr.encryptPassword((String)this.password);
    }

    @JsonProperty(value="collection")
    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void cleanupSensitiveData() {
        this.password = null;
    }
}

