/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.transexecutor;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.ProgressNullMonitorListener;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.SubtransAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransExecutorStepAnalyzer
extends StepAnalyzer<TransExecutorMeta> {
    static final String TRANSFORMATION_TO_EXECUTE = "transformationToExecute";
    public static final String EXECUTION_RESULTS_TARGET = "executionResultsTarget";
    public static final String OUTPUT_ROWS_TARGET = "outputRowsTarget";
    public static final String RESULT_FILES_TARGET = "resultFilesTarget";
    private Logger log = LoggerFactory.getLogger(TransExecutorStepAnalyzer.class);
    private SubtransAnalyzer<TransExecutorMeta> subtransAnalyzer = new SubtransAnalyzer((StepAnalyzer)this, this.log);

    void setSubtransAnalyzer(SubtransAnalyzer<TransExecutorMeta> subtransAnalyzer) {
        this.subtransAnalyzer = subtransAnalyzer;
    }

    protected Set<StepField> getUsedFields(TransExecutorMeta meta) {
        return this.getInputs().getFieldNames();
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        return false;
    }

    protected IMetaverseNode analyzerSubTransformation(TransExecutorMeta meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        return KettleAnalyzerUtil.analyze((StepAnalyzer)this, (TransMeta)this.parentTransMeta, (ISubTransAwareMeta)meta, (IMetaverseNode)node);
    }

    protected TransMeta getSubTransMeta(TransExecutorMeta meta) throws MetaverseAnalyzerException {
        return KettleAnalyzerUtil.getSubTransMeta((ISubTransAwareMeta)meta);
    }

    protected void customAnalyze(TransExecutorMeta meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        IMetaverseNode subTransNode = this.analyzerSubTransformation(meta, node);
        TransMeta subTransMeta = this.getSubTransMeta(meta);
        String transformationPath = KettleAnalyzerUtil.getSubTransMetaPath((ISubTransAwareMeta)meta, (TransMeta)subTransMeta);
        if (transformationPath != null) {
            transformationPath = this.parentTransMeta.environmentSubstitute(transformationPath);
        }
        this.connectToSubTransInputFields(subTransMeta, subTransNode, this.descriptor);
        this.connectToSubTransOutputFields(meta, subTransMeta, subTransNode, this.descriptor);
        node.setProperty(TRANSFORMATION_TO_EXECUTE, (Object)transformationPath);
        if (StringUtils.isNotEmpty((String)meta.getExecutionResultTargetStep())) {
            node.setProperty(EXECUTION_RESULTS_TARGET, (Object)meta.getExecutionResultTargetStep());
        }
        if (StringUtils.isNotEmpty((String)meta.getOutputRowsSourceStep())) {
            node.setProperty(OUTPUT_ROWS_TARGET, (Object)meta.getOutputRowsSourceStep());
        }
        if (StringUtils.isNotEmpty((String)meta.getResultFilesTargetStep())) {
            node.setProperty(RESULT_FILES_TARGET, (Object)meta.getResultFilesTargetStep());
        }
    }

    protected TransMeta getSubTransMeta(String filePath) throws FileNotFoundException, KettleXMLException, KettleMissingPluginsException {
        return KettleAnalyzerUtil.getSubTransMeta((String)filePath);
    }

    public void connectToSubTransOutputFields(TransExecutorMeta meta, TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        IMetaverseNode outNode;
        String fieldName;
        int i;
        String outputStep;
        if (meta.getOutputRowsSourceStep() != null) {
            outputStep = meta.getOutputRowsSourceStep();
            for (i = 0; i < meta.getOutputRowsField().length; ++i) {
                fieldName = meta.getOutputRowsField()[i];
                outNode = this.getOutputs().findNode(outputStep, fieldName);
                if (outNode == null) continue;
                this.subtransAnalyzer.linkResultFieldToSubTrans(outNode, subTransMeta, subTransNode, descriptor);
            }
        }
        if (meta.getExecutorsOutputStep() != null) {
            outputStep = meta.getExecutorsOutputStep();
            for (i = 0; i < meta.getOutputRowsField().length; ++i) {
                fieldName = meta.getOutputRowsField()[i];
                outNode = this.getOutputs().findNode(outputStep, fieldName);
                if (outNode == null) continue;
                this.subtransAnalyzer.linkResultFieldToSubTrans(outNode, subTransMeta, subTransNode, descriptor);
            }
        }
    }

    public void connectToSubTransInputFields(TransMeta subTransMeta, IMetaverseNode subTransNode, IComponentDescriptor descriptor) {
        Set incomingFields = this.getInputs().getFieldNames();
        for (StepField field : incomingFields) {
            IMetaverseNode inputNode = this.getInputs().findNode(field);
            this.subtransAnalyzer.linkUsedFieldToSubTrans(inputNode, subTransMeta, subTransNode, descriptor);
        }
    }

    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(TransExecutorMeta meta) {
        String[] nextStepNames;
        HashMap<String, RowMetaInterface> outputFields = new HashMap<String, RowMetaInterface>();
        for (String nextStepName : nextStepNames = this.parentTransMeta.getNextStepNames(this.parentStepMeta)) {
            StepMeta step = this.parentTransMeta.findStep(nextStepName);
            ProgressNullMonitorListener progressMonitor = new ProgressNullMonitorListener();
            try {
                RowMetaInterface prevStepFields = this.parentTransMeta.getPrevStepFields(step, (ProgressMonitorListener)progressMonitor);
                outputFields.put(nextStepName, prevStepFields);
                progressMonitor.done();
            }
            catch (KettleStepException e) {
                this.log.warn("Could not get step fields for " + nextStepName, (Throwable)e);
            }
        }
        return outputFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(TransExecutorMeta.class);
        return supportedSteps;
    }

    protected void setParentTransMeta(TransMeta parentTransMeta) {
        this.parentTransMeta = parentTransMeta;
    }

    protected void setParentStepMeta(StepMeta parentStepMeta) {
        this.parentStepMeta = parentStepMeta;
    }

    protected IMetaverseNode createFieldNode(IComponentDescriptor fieldDescriptor, ValueMetaInterface fieldMeta, String targetStepName, boolean addTheNode) {
        return super.createFieldNode(fieldDescriptor, fieldMeta, targetStepName, addTheNode);
    }

    public IClonableStepAnalyzer newInstance() {
        return new TransExecutorStepAnalyzer();
    }
}

