/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransExtensionPointUtil;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.impl.MetaverseConfig;

@ExtensionPoint(description="Transformation Lineage Graph creator", extensionPointId="TransChanged", id="transChangeLineageGraph")
public class TransChangedExtensionPoint
implements ExtensionPointInterface,
ContentChangedListener {
    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        TransMeta transMeta;
        if (!MetaverseConfig.isLineageExecutionEnabled()) {
            return;
        }
        if (object instanceof TransMeta && !(transMeta = (TransMeta)object).getContentChangedListeners().contains(this)) {
            transMeta.addContentChangedListener((ContentChangedListener)this);
        }
    }

    public void contentChanged(Object object) {
        this.updateLineage(object);
    }

    public void contentSafe(Object object) {
        this.updateLineage(object);
    }

    protected void updateLineage(Object object) {
        if (object instanceof TransMeta) {
            try {
                TransMeta transMeta = (TransMeta)object;
                TransExtensionPointUtil.addLineageGraph(transMeta);
            }
            catch (MetaverseException metaverseException) {
                // empty catch block
            }
        }
    }
}

