/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.job;

import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Map;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransLineageHolderMap;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.util.MetaverseBeanUtil;

public class JobLineageHolderMap {
    private static JobLineageHolderMap INSTANCE = new JobLineageHolderMap();
    private IMetaverseBuilder defaultMetaverseBuilder;
    private Map<Job, LineageHolder> lineageHolderMap = Collections.synchronizedMap(new MapMaker().weakKeys().makeMap());

    private JobLineageHolderMap() {
    }

    public static JobLineageHolderMap getInstance() {
        return INSTANCE;
    }

    protected static void setInstance(JobLineageHolderMap instance) {
        INSTANCE = instance;
    }

    public LineageHolder getLineageHolder(Job job) {
        LineageHolder holder = this.lineageHolderMap.get(job);
        if (holder == null) {
            holder = new LineageHolder();
            this.lineageHolderMap.put(job, holder);
        }
        return holder;
    }

    public void putLineageHolder(Job job, LineageHolder holder) {
        this.lineageHolderMap.put(job, holder);
    }

    public LineageHolder removeLineageHolderImpl(Job job) {
        LineageHolder holder = this.lineageHolderMap.remove(job);
        for (Object subExecutable : holder.getSubTransAndJobs()) {
            if (subExecutable instanceof Trans) {
                TransLineageHolderMap.getInstance().removeLineageHolderImpl((Trans)subExecutable);
                continue;
            }
            if (!(subExecutable instanceof Job)) continue;
            this.removeLineageHolderImpl((Job)subExecutable);
        }
        return holder;
    }

    public LineageHolder removeLineageHolder(Job job) {
        if (job.getParentTrans() == null && job.getParentJob() == null) {
            return this.removeLineageHolderImpl(job);
        }
        if (job.getParentTrans() != null) {
            TransLineageHolderMap.getInstance().getLineageHolder(job.getParentTrans()).addSubTransOrJob((Object)job);
        } else if (job.getParentJob() != null) {
            this.getLineageHolder(job.getParentJob()).addSubTransOrJob((Object)job);
        }
        return null;
    }

    public IMetaverseBuilder getMetaverseBuilder(Job job) {
        if (job != null) {
            if (job.getParentJob() == null && job.getParentTrans() == null) {
                IMetaverseBuilder builder = this.getLineageHolder(job).getMetaverseBuilder();
                if (builder == null) {
                    return this.getDefaultMetaverseBuilder();
                }
                return builder;
            }
            if (job.getParentJob() != null) {
                return this.getMetaverseBuilder(job.getParentJob());
            }
            return TransLineageHolderMap.getInstance().getMetaverseBuilder(job.getParentTrans());
        }
        return null;
    }

    protected IMetaverseBuilder getDefaultMetaverseBuilder() {
        IMetaverseBuilder newBuilder = (IMetaverseBuilder)MetaverseBeanUtil.getInstance().get("IMetaverseBuilderPrototype");
        if (newBuilder == null) {
            return this.defaultMetaverseBuilder;
        }
        return newBuilder;
    }

    protected void setDefaultMetaverseBuilder(IMetaverseBuilder builder) {
        this.defaultMetaverseBuilder = builder;
    }
}

