/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.georss.GMLModuleImpl;
import com.sun.syndication.feed.module.georss.GeoRSSModule;
import com.sun.syndication.feed.module.georss.GeoRSSUtils;
import com.sun.syndication.feed.module.georss.geometries.Envelope;
import com.sun.syndication.feed.module.georss.geometries.LineString;
import com.sun.syndication.feed.module.georss.geometries.LinearRing;
import com.sun.syndication.feed.module.georss.geometries.Point;
import com.sun.syndication.feed.module.georss.geometries.Polygon;
import com.sun.syndication.feed.module.georss.geometries.Position;
import com.sun.syndication.feed.module.georss.geometries.PositionList;
import com.sun.syndication.io.ModuleParser;
import org.jdom.Element;

public class GMLParser
implements ModuleParser {
    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    public Module parse(Element element) {
        Module module = GMLParser.parseGML(element);
        return module;
    }

    private static PositionList parsePosList(Element element) {
        String string = element.getText();
        String[] stringArray = GeoRSSUtils.trimWhitespace(string).split(" ");
        PositionList positionList = new PositionList();
        for (int i = 0; i < stringArray.length; i += 2) {
            positionList.add(Double.parseDouble(stringArray[i]), Double.parseDouble(stringArray[i + 1]));
        }
        return positionList;
    }

    static Module parseGML(Element element) {
        GMLModuleImpl gMLModuleImpl = null;
        Element element2 = element.getChild("Point", GeoRSSModule.GML_NS);
        Element element3 = element.getChild("LineString", GeoRSSModule.GML_NS);
        Element element4 = element.getChild("Polygon", GeoRSSModule.GML_NS);
        Element element5 = element.getChild("Envelope", GeoRSSModule.GML_NS);
        if (element2 != null) {
            Element element6 = element2.getChild("pos", GeoRSSModule.GML_NS);
            if (element6 != null) {
                gMLModuleImpl = new GMLModuleImpl();
                String string = element6.getText();
                String[] stringArray = GeoRSSUtils.trimWhitespace(string).split(" ");
                Position position = new Position(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                gMLModuleImpl.setGeometry(new Point(position));
            }
        } else if (element3 != null) {
            Element element7 = element3.getChild("posList", GeoRSSModule.GML_NS);
            if (element7 != null) {
                gMLModuleImpl = new GMLModuleImpl();
                gMLModuleImpl.setGeometry(new LineString(GMLParser.parsePosList(element7)));
            }
        } else if (element4 != null) {
            Element element8;
            Object object;
            Polygon polygon = null;
            Element element9 = element4.getChild("exterior", GeoRSSModule.GML_NS);
            if (element9 != null && (object = element9.getChild("LinearRing", GeoRSSModule.GML_NS)) != null && (element8 = object.getChild("posList", GeoRSSModule.GML_NS)) != null) {
                if (polygon == null) {
                    polygon = new Polygon();
                }
                polygon.setExterior(new LinearRing(GMLParser.parsePosList(element8)));
            }
            object = element4.getChildren("interior", GeoRSSModule.GML_NS);
            element8 = object.iterator();
            while (element8.hasNext()) {
                Element element10;
                Element element11;
                Element element12 = (Element)element8.next();
                if (element12 == null || (element11 = element12.getChild("LinearRing", GeoRSSModule.GML_NS)) == null || (element10 = element11.getChild("posList", GeoRSSModule.GML_NS)) == null) continue;
                if (polygon == null) {
                    polygon = new Polygon();
                }
                polygon.getInterior().add(new LinearRing(GMLParser.parsePosList(element10)));
            }
            if (polygon != null) {
                gMLModuleImpl = new GMLModuleImpl();
                gMLModuleImpl.setGeometry(polygon);
            }
        } else if (element5 != null) {
            Element element13 = element5.getChild("lowerCorner", GeoRSSModule.GML_NS);
            Element element14 = element5.getChild("upperCorner", GeoRSSModule.GML_NS);
            if (element13 != null && element14 != null) {
                gMLModuleImpl = new GMLModuleImpl();
                String string = element13.getText();
                String[] stringArray = GeoRSSUtils.trimWhitespace(string).split(" ");
                String string2 = element14.getText();
                String[] stringArray2 = GeoRSSUtils.trimWhitespace(string2).split(" ");
                Envelope envelope = new Envelope(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray2[0]), Double.parseDouble(stringArray2[1]));
                gMLModuleImpl.setGeometry(envelope);
            }
        }
        return gMLModuleImpl;
    }
}

