/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.ui.endpoints;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.IOException;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;

@Provider
@Produces(value={"application/json"})
public class JsonProvider
extends JacksonJaxbJsonProvider {
    public static final String TYPE = "type";

    public JsonProvider() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(ConnectionDetails.class, (JsonDeserializer)new ConnectionDetailsDeserializer());
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)simpleModule);
        this.setMapper(objectMapper);
    }

    public static class ConnectionDetailsDeserializer
    extends StdDeserializer<ConnectionDetails> {
        public ConnectionDetailsDeserializer() {
            this(ConnectionDetails.class);
        }

        public ConnectionDetailsDeserializer(Class<?> vc) {
            super(vc);
        }

        public ConnectionDetails deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            String type = jsonNode.get(JsonProvider.TYPE).asText();
            Class<?> clazz = ConnectionManager.getInstance().createConnectionDetails(type).getClass();
            if (clazz != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                return (ConnectionDetails)objectMapper.readValue(objectMapper.treeAsTokens((TreeNode)jsonNode), clazz);
            }
            return null;
        }
    }
}

