/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.ui.dialog;

import java.util.function.Supplier;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.ui.dialog.ConnectionDeleteDialog;
import org.pentaho.di.connections.ui.dialog.ConnectionDialog;
import org.pentaho.di.connections.ui.tree.ConnectionFolderProvider;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;

public class ConnectionDelegate {
    private static final Class<?> PKG = ConnectionDelegate.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private static final int WIDTH = 630;
    private static final int HEIGHT = 630;

    public void openDialog() {
        ConnectionDialog connectionDialog = new ConnectionDialog(this.spoonSupplier.get().getShell(), 630, 630);
        connectionDialog.open(BaseMessages.getString(PKG, (String)"ConnectionDialog.dialog.new.title", (String[])new String[0]));
    }

    public void openDialog(String label) {
        ConnectionDialog connectionDialog = new ConnectionDialog(this.spoonSupplier.get().getShell(), 630, 630);
        connectionDialog.open(BaseMessages.getString(PKG, (String)"ConnectionDialog.dialog.edit.title", (String[])new String[0]), label);
    }

    public void delete(String label) {
        ConnectionDeleteDialog connectionDeleteDialog = new ConnectionDeleteDialog(this.spoonSupplier.get().getShell());
        if (connectionDeleteDialog.open(label) == 64) {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            connectionManager.delete(label);
            this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> this.spoonSupplier.get().refreshTree(ConnectionFolderProvider.STRING_VFS_CONNECTIONS));
            EngineMetaInterface engineMetaInterface = this.spoonSupplier.get().getActiveMeta();
            if (engineMetaInterface instanceof AbstractMeta) {
                ((AbstractMeta)engineMetaInterface).setChanged();
            }
        }
    }
}

