/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessinput;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.accessinput.AccessInputData;
import org.pentaho.di.trans.steps.accessinput.AccessInputField;
import org.pentaho.di.trans.steps.accessinput.AccessInputMeta;

public class AccessInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = AccessInput.class;
    private AccessInputMeta meta;
    private AccessInputData data;

    public AccessInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block5: {
            Object[] r = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                Object[] outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"AccessInput.ErrorInStepRunning", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "AccessInput001");
            }
        }
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        try {
            if (this.meta.isFileField()) {
                while (this.data.readrow == null || (this.data.rw = this.data.t.getNextRow()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (this.data.file == null || (this.data.rw = this.data.t.getNextRow()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception IO) {
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (this.meta.isFileField()) {
            System.arraycopy(this.data.readrow, 0, r, 0, this.data.readrow.length);
        }
        try {
            RowMetaInterface irow;
            for (int i = 0; i < this.data.nrFields; ++i) {
                AccessInputField field = this.meta.getInputFields()[i];
                Object obj = this.data.rw.get(field.getColumn());
                r[this.data.totalpreviousfields + i] = this.convert(obj, field, i);
                if (!field.isRepeated() || this.data.previousRow == null || obj != null) continue;
                r[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.data.totalpreviousfields + this.meta.getInputFields().length;
            if (this.meta.isIncludeFilename() && !Utils.isEmpty((CharSequence)this.meta.getFilenameField())) {
                r[rowIndex++] = AccessInputMeta.getFilename(this.data.file);
            }
            if (this.meta.isIncludeTablename() && !Utils.isEmpty((CharSequence)this.data.t.getName())) {
                r[rowIndex++] = this.data.t.getName();
            }
            if (this.meta.isIncludeRowNumber() && !Utils.isEmpty((CharSequence)this.meta.getRowNumberField())) {
                r[rowIndex++] = new Long(this.data.rownr);
            }
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                r[rowIndex++] = this.data.shortFilename;
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                r[rowIndex++] = this.data.extension;
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                r[rowIndex++] = this.data.path;
            }
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                r[rowIndex++] = new Long(this.data.size);
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                r[rowIndex++] = new Boolean(this.data.hidden);
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                r[rowIndex++] = this.data.lastModificationDateTime;
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                r[rowIndex++] = this.data.uriName;
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                r[rowIndex++] = this.data.rootUriName;
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? r : irow.cloneRow(r);
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AccessInput.Error.ErrorReadingFile", (String[])new String[0]), (Throwable)e);
        }
        return r;
    }

    private boolean openNextFile() {
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= this.data.files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"AccessInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
                this.data.file = this.data.files.getFile(this.data.filenr);
                ++this.data.filenr;
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"AccessInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (int i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        ValueMetaInterface valueMeta = this.data.convertRowMeta.getValueMeta(i);
                        this.data.convertRowMeta.setValueMeta(i, ValueMetaFactory.cloneValueMeta((ValueMetaInterface)valueMeta, (int)2));
                    }
                    if (Utils.isEmpty((CharSequence)this.meta.getDynamicFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"AccessInput.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AccessInput.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"AccessInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getDynamicFilenameField() + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"AccessInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"AccessInput.Log.FilenameInStream", (String[])new String[]{this.meta.getDynamicFilenameField(), filename}));
                }
                this.data.file = KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta());
            }
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                this.data.shortFilename = this.data.file.getName().getBaseName();
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                this.data.path = KettleVFS.getFilename((FileObject)this.data.file.getParent());
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                this.data.hidden = this.data.file.isHidden();
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                this.data.extension = this.data.file.getName().getExtension();
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                this.data.lastModificationDateTime = new Date(this.data.file.getContent().getLastModifiedTime());
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                this.data.uriName = this.data.file.getName().getURI();
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                this.data.rootUriName = this.data.file.getName().getRootURI();
            }
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                this.data.size = new Long(this.data.file.getContent().getSize());
            }
            if (this.meta.isResetRowNumber()) {
                this.data.rownr = 0L;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"AccessInput.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"AccessInput.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            this.data.file.getName().getPathDecoded();
            this.data.d = Database.open((File)new File(AccessInputMeta.getFilename(this.data.file)), (boolean)true);
            this.data.t = this.data.isTableSystem ? this.data.d.getSystemTable(this.data.tableName) : this.data.d.getTable(this.data.tableName);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"AccessInput.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"AccessInput.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"AccessInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"AccessInput.Log.RequiredFiles", (String[])new String[]{message})});
            throw new KettleException(BaseMessages.getString(PKG, (String)"AccessInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"AccessInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"AccessInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new KettleException(BaseMessages.getString(PKG, (String)"AccessInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AccessInputMeta)smi;
        this.data = (AccessInputData)sdi;
        if (super.init(smi, sdi)) {
            int i;
            this.data.tableName = this.environmentSubstitute(this.meta.getTableName());
            if (Utils.isEmpty((CharSequence)this.data.tableName)) {
                this.logError(BaseMessages.getString(PKG, (String)"AccessInput.Error.TableNameMissing", (String[])new String[0]));
                return false;
            }
            this.data.isTableSystem = this.data.tableName.startsWith("MSys");
            if (!this.meta.isFileField()) {
                this.data.files = this.meta.getFiles((VariableSpace)this);
                try {
                    this.handleMissingFiles();
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        ValueMetaInterface valueMeta = this.data.convertRowMeta.getValueMeta(i);
                        this.data.convertRowMeta.setValueMeta(i, ValueMetaFactory.cloneValueMeta((ValueMetaInterface)valueMeta, (int)2));
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"AccessInput.ErrorInit", (String[])new String[]{e.toString()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.nrFields = this.meta.getInputFields() == null ? 0 : this.meta.getInputFields().length;
            for (i = 0; i < this.data.nrFields; ++i) {
                this.meta.getInputFields()[i].setColumn(this.environmentSubstitute(this.meta.getInputFields()[i].getColumn()));
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AccessInputMeta)smi;
        this.data = (AccessInputData)sdi;
        if (this.data.t != null) {
            this.data.t = null;
        }
        if (this.data.rw != null) {
            this.data.rw = null;
        }
        if (this.data.readrow != null) {
            this.data.readrow = null;
        }
        try {
            if (this.data.d != null) {
                this.data.d.close();
                this.data.d = null;
            }
            if (this.data.file != null) {
                this.data.file.close();
                this.data.file = null;
            }
            this.data.daf = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }

    private Object convert(Object obj, AccessInputField field, int index) throws Exception {
        Column c = this.data.t.getColumn(field.getColumn());
        ValueMetaAndData sourceValueMetaAndData = AccessInputMeta.getValueMetaAndData(c, field.getName(), obj);
        ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + index);
        return targetValueMeta.convertData(sourceValueMetaAndData.getValueMeta(), sourceValueMetaAndData.getValueData());
    }
}

