/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.GenericExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.engine.classic.core.function.WrapperExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultProcessingContext;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;
import org.pentaho.reporting.engine.classic.extensions.drilldown.LinkCustomizer;
import org.pentaho.reporting.engine.classic.extensions.drilldown.ParameterEntry;
import org.pentaho.reporting.engine.classic.extensions.drilldown.PatternLinkCustomizer;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaLinkCustomizer
implements LinkCustomizer {
    private static final String TAB_ACTIVE_PARAMETER = "::TabActive";
    private static final String TAB_NAME_PARAMETER = "::TabName";

    private String computeMantleTabActive(FormulaContext formulaContext, ParameterEntry[] entries) throws EvaluationException {
        for (int i = 0; i < entries.length; ++i) {
            Object o;
            ParameterEntry parameterEntry = entries[i];
            String parameterName = parameterEntry.getParameterName();
            if (!TAB_ACTIVE_PARAMETER.equals(parameterName) || (o = parameterEntry.getParameterValue()) == null) continue;
            return String.valueOf(o);
        }
        Object o = formulaContext.resolveReference((Object)TAB_ACTIVE_PARAMETER);
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }

    private String computeMantleTabName(FormulaContext formulaContext, ParameterEntry[] entries) throws EvaluationException {
        for (int i = 0; i < entries.length; ++i) {
            Object o;
            ParameterEntry parameterEntry = entries[i];
            String parameterName = parameterEntry.getParameterName();
            if (!TAB_NAME_PARAMETER.equals(parameterName) || (o = parameterEntry.getParameterValue()) == null) continue;
            return String.valueOf(o);
        }
        Object o = formulaContext.resolveReference((Object)TAB_NAME_PARAMETER);
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }

    private ParameterEntry[] filterEntries(ParameterEntry[] entries) {
        ArrayList<ParameterEntry> list = new ArrayList<ParameterEntry>();
        for (int i = 0; i < entries.length; ++i) {
            ParameterEntry entry = entries[i];
            if (this.isFiltered(entry)) continue;
            list.add(entry);
        }
        return list.toArray(new ParameterEntry[list.size()]);
    }

    protected boolean isFiltered(ParameterEntry entry) {
        if (TAB_NAME_PARAMETER.equals(entry.getParameterName())) {
            return true;
        }
        return TAB_ACTIVE_PARAMETER.equals(entry.getParameterName());
    }

    private Object[][] createEntryTable(ParameterEntry[] entries) {
        Object[][] values = new Object[entries.length][2];
        for (int i = 0; i < entries.length; ++i) {
            ParameterEntry entry = entries[i];
            values[i][0] = entry.getParameterName();
            values[i][1] = entry.getParameterValue();
        }
        return values;
    }

    @Override
    public String format(FormulaContext formulaContext, String configIndicator, String reportPath, ParameterEntry[] entries) throws EvaluationException {
        try {
            WrapperExpressionRuntime expressionRuntime;
            Map<String, Object> parameterValues = this.createParameterMap(formulaContext, configIndicator, reportPath, entries);
            StaticDataRow staticDataRow = new StaticDataRow(parameterValues);
            if (formulaContext instanceof ReportFormulaContext) {
                ReportFormulaContext rfc = (ReportFormulaContext)formulaContext;
                expressionRuntime = new WrapperExpressionRuntime((DataRow)staticDataRow, rfc.getRuntime());
            } else {
                expressionRuntime = new GenericExpressionRuntime((DataRow)new CompoundDataRow((DataRow)staticDataRow, this.createDataRow(entries)), (TableModel)new DefaultTableModel(), -1, (ProcessingContext)new DefaultProcessingContext());
            }
            String formula = this.computeFormula(configIndicator);
            Formula compiledFormula = new Formula(formula);
            compiledFormula.initialize((FormulaContext)new ReportFormulaContext(formulaContext, (ExpressionRuntime)expressionRuntime));
            Object o = compiledFormula.evaluate();
            if (o instanceof ErrorValue) {
                throw EvaluationException.getInstance((ErrorValue)((ErrorValue)o));
            }
            if (o == null) {
                throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_NA_VALUE);
            }
            return String.valueOf(o);
        }
        catch (UnsupportedEncodingException e) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        catch (BeanException e) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        catch (ParseException e) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    protected Map<String, Object> createParameterMap(FormulaContext formulaContext, String configIndicator, String reportPath, ParameterEntry[] entries) throws UnsupportedEncodingException, BeanException, EvaluationException {
        String parameter = PatternLinkCustomizer.computeParameter(formulaContext, this.filterEntries(entries));
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        if (reportPath == null || reportPath.endsWith("/")) {
            parameterValues.put("::path", reportPath);
        } else {
            parameterValues.put("::path", reportPath + "/");
        }
        parameterValues.put("::parameter", parameter);
        parameterValues.put("::config", configIndicator);
        parameterValues.put("::entries", this.createEntryTable(entries));
        parameterValues.put(TAB_NAME_PARAMETER, this.computeMantleTabName(formulaContext, entries));
        parameterValues.put(TAB_ACTIVE_PARAMETER, this.computeMantleTabActive(formulaContext, entries));
        return parameterValues;
    }

    private String computeFormula(String configIndicator) throws EvaluationException {
        DrillDownProfile downProfile = DrillDownProfileMetaData.getInstance().getDrillDownProfile(configIndicator);
        return downProfile.getAttribute("formula");
    }

    private DataRow createDataRow(ParameterEntry[] parameterEntries) {
        String[] parameterNames = new String[parameterEntries.length];
        Object[] parameterValues = new Object[parameterEntries.length];
        for (int i = 0; i < parameterEntries.length; ++i) {
            ParameterEntry entry = parameterEntries[i];
            parameterNames[i] = entry.getParameterName();
            parameterValues[i] = entry.getParameterValue();
        }
        return new StaticDataRow(parameterNames, parameterValues);
    }
}

