/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui;

import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

public class NamedClusterWidgetImpl
extends Composite {
    private static Class<?> PKG = NamedClusterWidgetImpl.class;
    private NamedClusterService namedClusterService;
    private Combo nameClusterCombo;
    private HadoopClusterDelegateImpl ncDelegate;

    public NamedClusterWidgetImpl(Composite parent, boolean showLabel, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester clusterTester) {
        super(parent, 0);
        this.namedClusterService = namedClusterService;
        this.ncDelegate = new HadoopClusterDelegateImpl(Spoon.getInstance(), this.namedClusterService, runtimeTestActionService, clusterTester);
        PropsUI props = PropsUI.getInstance();
        props.setLook((Control)this);
        RowLayout layout = new RowLayout(256);
        this.setLayout((Layout)layout);
        if (showLabel) {
            Label nameLabel = new Label((Composite)this, 0);
            nameLabel.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Title", (String[])new String[0]) + ":");
            props.setLook((Control)nameLabel);
        }
        this.setNameClusterCombo(new Combo((Composite)this, 12));
        this.getNameClusterCombo().setLayoutData((Object)new RowData(150, -1));
        Button editButton = new Button((Composite)this, 0);
        editButton.setText(BaseMessages.getString(PKG, (String)"NamedClusterWidget.NamedCluster.Edit", (String[])new String[0]));
        editButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterWidgetImpl.this.editNamedCluster();
            }
        });
        props.setLook((Control)editButton);
        Button newButton = new Button((Composite)this, 0);
        newButton.setText(BaseMessages.getString(PKG, (String)"NamedClusterWidget.NamedCluster.New", (String[])new String[0]));
        newButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterWidgetImpl.this.newNamedCluster();
            }
        });
        props.setLook((Control)newButton);
        this.initiate();
    }

    private void newNamedCluster() {
        Spoon spoon = Spoon.getInstance();
        AbstractMeta meta = (AbstractMeta)spoon.getActiveMeta();
        this.ncDelegate.newNamedCluster((VariableSpace)meta, (IMetaStore)spoon.getMetaStore(), this.getShell());
        this.initiate();
    }

    private void editNamedCluster() {
        Spoon spoon = Spoon.getInstance();
        AbstractMeta meta = (AbstractMeta)spoon.getActiveMeta();
        if (meta != null) {
            List namedClusters = null;
            try {
                namedClusters = this.namedClusterService.list((IMetaStore)spoon.getMetaStore());
            }
            catch (MetaStoreException metaStoreException) {
                // empty catch block
            }
            int index = this.getNameClusterCombo().getSelectionIndex();
            if (index > -1 && namedClusters != null && namedClusters.size() > 0) {
                this.ncDelegate.editNamedCluster((IMetaStore)spoon.getMetaStore(), (NamedCluster)namedClusters.get(index), this.getShell());
                this.initiate();
            }
        }
    }

    protected String[] getNamedClusterNames() {
        try {
            return this.namedClusterService.listNames((IMetaStore)Spoon.getInstance().getMetaStore()).toArray(new String[0]);
        }
        catch (MetaStoreException e) {
            return new String[0];
        }
    }

    public void initiate() {
        int selectedIndex = this.getNameClusterCombo().getSelectionIndex();
        this.getNameClusterCombo().removeAll();
        this.getNameClusterCombo().setItems(this.getNamedClusterNames());
        this.getNameClusterCombo().select(selectedIndex);
    }

    public NamedCluster getSelectedNamedCluster() {
        Spoon spoon = Spoon.getInstance();
        int index = this.getNameClusterCombo().getSelectionIndex();
        if (index > -1) {
            String name = this.getNameClusterCombo().getItem(index);
            try {
                return this.namedClusterService.read(name, (IMetaStore)spoon.getMetaStore());
            }
            catch (MetaStoreException e) {
                return null;
            }
        }
        return null;
    }

    public void setSelectedNamedCluster(String name) {
        this.getNameClusterCombo().deselectAll();
        for (int i = 0; i < this.getNameClusterCombo().getItemCount(); ++i) {
            if (!this.getNameClusterCombo().getItem(i).equals(name)) continue;
            this.getNameClusterCombo().select(i);
            return;
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.getNameClusterCombo().addSelectionListener(selectionListener);
    }

    public Combo getNameClusterCombo() {
        return this.nameClusterCombo;
    }

    protected void setNameClusterCombo(Combo nameClusterCombo) {
        this.nameClusterCombo = nameClusterCombo;
    }
}

