/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.plugins.common.ui.CommonDialogFactory;
import org.pentaho.big.data.plugins.common.ui.NamedClusterDialogImpl;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;
import org.pentaho.metastore.stores.xml.XmlMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

public class HadoopClusterDelegateImpl
extends SpoonDelegate {
    public static final String SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_TITLE = "Spoon.Dialog.ErrorDeletingNamedCluster.Title";
    public static final String SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_MESSAGE = "Spoon.Dialog.ErrorDeletingNamedCluster.Message";
    public static final String SPOON_VARIOUS_DUPE_NAME = "Spoon.Various.DupeName";
    public static final String SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_TITLE = "Spoon.Dialog.ErrorSavingNamedCluster.Title";
    public static final String SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_MESSAGE = "Spoon.Dialog.ErrorSavingNamedCluster.Message";
    public static Class<?> PKG = HadoopClusterDelegateImpl.class;
    public static final String STRING_NAMED_CLUSTERS = BaseMessages.getString(PKG, (String)"NamedClusterDialog.HadoopClusters", (String[])new String[0]);
    public static final String SPOON_DIALOG_ERROR_ADDING_NEW_CONFIGURATION_FOR_CLUSTER_TITLE = "Spoon.Dialog.ErrorAddingNewConfigurationForCluster.Title";
    public static final String SPOON_DIALOG_ERROR_ADDING_NEW_CONFIGURATION_FOR_CLUSTER_MESSAGE = "Spoon.Dialog.ErrorAddingNewConfigurationForCluster.Message";
    public static final String SPOON_DIALOG_ERROR_RENAMING_PREVIOUS_CLUSTER_CONFIG_TITLE = "Spoon.Dialog.ErrorRenamingPreviousClusterConfig.Title";
    public static final String SPOON_DIALOG_ERROR_RENAMING_PREVIOUS_CLUSTER_CONFIG_MESSAGE = "Spoon.Dialog.ErrorRenamingPreviousClusterConfig.Message";
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private final CommonDialogFactory commonDialogFactory;

    public HadoopClusterDelegateImpl(Spoon spoon, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this(spoon, namedClusterService, runtimeTestActionService, runtimeTester, new CommonDialogFactory());
    }

    public HadoopClusterDelegateImpl(Spoon spoon, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, CommonDialogFactory commonDialogFactory) {
        super(spoon);
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.commonDialogFactory = commonDialogFactory;
    }

    public void dupeNamedCluster(IMetaStore metaStore, NamedCluster nc, Shell shell) {
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        if (nc == null) {
            return;
        }
        NamedCluster newNamedCluster = nc.clone();
        String duplicateName = BaseMessages.getString(Spoon.class, (String)SPOON_VARIOUS_DUPE_NAME, (String[])new String[0]) + nc.getName();
        newNamedCluster.setName(duplicateName);
        NamedClusterDialogImpl namedClusterDialogImpl = this.commonDialogFactory.createNamedClusterDialog(shell, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, newNamedCluster);
        namedClusterDialogImpl.setNewClusterCheck(true);
        String newClusterName = namedClusterDialogImpl.open();
        if (newClusterName == null) {
            return;
        }
        try {
            XmlMetaStore xmlMetaStore = this.getXmlMetastore(metaStore);
            if (xmlMetaStore != null) {
                if (newNamedCluster.getName() != null) {
                    this.delNamedCluster(metaStore, newNamedCluster);
                }
                File sourceClusterConfigDir = new File(this.getNamedClusterConfigsRootDir(xmlMetaStore) + "/" + nc.getName());
                File newClusterConfigDir = new File(this.getNamedClusterConfigsRootDir(xmlMetaStore) + "/" + newClusterName);
                this.saveNamedCluster(metaStore, newNamedCluster);
                FileUtils.copyDirectory((File)sourceClusterConfigDir, (File)newClusterConfigDir);
                if (!nc.getShimIdentifier().equals(newNamedCluster.getShimIdentifier())) {
                    this.addConfigProperties(newNamedCluster);
                }
            }
        }
        catch (Exception e) {
            this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_MESSAGE, (String[])new String[]{nc.getName()}), e);
            this.spoon.refreshTree();
            return;
        }
        this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
    }

    public void delNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        this.deleteNamedCluster(metaStore, namedCluster);
        this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
        this.spoon.setShellText();
    }

    private void backupAndAddShimConfiguration(IMetaStore metaStore, NamedCluster previousNamedCluster, NamedCluster selectedNamedCluster) {
        XmlMetaStore xmlMetaStore;
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        if (previousNamedCluster == null) {
            return;
        }
        if (selectedNamedCluster == null) {
            return;
        }
        try {
            xmlMetaStore = this.getXmlMetastore(metaStore);
        }
        catch (MetaStoreException ex) {
            xmlMetaStore = null;
        }
        String previousNamedClusterName = previousNamedCluster.getName();
        String selectedNamedClusterName = selectedNamedCluster.getName();
        File previousShimConfiguration = new File(this.getNamedClusterConfigsRootDir(xmlMetaStore) + File.separator + previousNamedClusterName + File.separator + "config.properties");
        File previousShimConfigurationBackup = new File(this.getNamedClusterConfigsRootDir(xmlMetaStore) + File.separator + previousNamedClusterName + File.separator + "old-config.bak");
        try {
            Files.move(previousShimConfiguration.toPath(), previousShimConfigurationBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String dialogTitle = BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_RENAMING_PREVIOUS_CLUSTER_CONFIG_TITLE, (String[])new String[0]);
            String dialogMessage = BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_RENAMING_PREVIOUS_CLUSTER_CONFIG_MESSAGE, (String[])new String[0]);
            this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), dialogTitle, dialogMessage, e);
            return;
        }
        try {
            this.addConfigProperties(selectedNamedCluster);
        }
        catch (Exception e) {
            String dialogTitle = BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_ADDING_NEW_CONFIGURATION_FOR_CLUSTER_TITLE, (String[])new String[0]);
            String dialogMessage = MessageFormat.format(BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_ADDING_NEW_CONFIGURATION_FOR_CLUSTER_MESSAGE, (String[])new String[0]), selectedNamedClusterName);
            this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), dialogTitle, dialogMessage, e);
        }
    }

    public String editNamedCluster(IMetaStore metaStore, NamedCluster namedCluster, Shell shell) {
        XmlMetaStore xmlMetaStore;
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        NamedClusterDialogImpl namedClusterDialogImpl = this.commonDialogFactory.createNamedClusterDialog(shell, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, namedCluster.clone());
        namedClusterDialogImpl.setNewClusterCheck(false);
        String result = namedClusterDialogImpl.open();
        if (result == null) {
            return null;
        }
        NamedCluster selectedNamedCluster = namedClusterDialogImpl.getNamedCluster();
        this.saveNamedCluster(metaStore, selectedNamedCluster);
        String previousNamedClusterName = namedCluster.getName();
        String selectedNamedClusterName = selectedNamedCluster.getName();
        String previousShimIdentifier = namedCluster.getShimIdentifier();
        String selectedShimIdentifier = selectedNamedCluster.getShimIdentifier();
        if (!previousShimIdentifier.equals(selectedShimIdentifier)) {
            this.backupAndAddShimConfiguration(metaStore, namedCluster, selectedNamedCluster);
        }
        if (previousNamedClusterName != null && previousNamedClusterName.equals(selectedNamedClusterName)) {
            return selectedNamedClusterName;
        }
        try {
            xmlMetaStore = this.getXmlMetastore(metaStore);
        }
        catch (MetaStoreException ex) {
            xmlMetaStore = null;
        }
        File source = new File(this.getNamedClusterConfigsRootDir(xmlMetaStore) + File.separator + previousNamedClusterName);
        File destination = new File(this.getNamedClusterConfigsRootDir(xmlMetaStore) + File.separator + selectedNamedClusterName);
        try {
            FileUtils.copyDirectory((File)source, (File)destination);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.deleteNamedCluster(metaStore, namedCluster);
        String shimIdentifier = namedClusterDialogImpl.getNamedCluster().getShimIdentifier();
        if (!namedCluster.getShimIdentifier().equals(shimIdentifier)) {
            try {
                this.addConfigProperties(namedClusterDialogImpl.getNamedCluster());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
        if (namedClusterDialogImpl.getNamedCluster() != null) {
            return namedClusterDialogImpl.getNamedCluster().getName();
        }
        return null;
    }

    private XmlMetaStore getXmlMetastore(IMetaStore metaStore) throws MetaStoreException {
        XmlMetaStore xmlMetaStore = null;
        if (metaStore instanceof DelegatingMetaStore) {
            IMetaStore activeMetastore = ((DelegatingMetaStore)metaStore).getActiveMetaStore();
            if (activeMetastore instanceof XmlMetaStore) {
                xmlMetaStore = (XmlMetaStore)activeMetastore;
            }
        } else if (metaStore instanceof XmlMetaStore) {
            xmlMetaStore = (XmlMetaStore)metaStore;
        }
        return xmlMetaStore;
    }

    private String getNamedClusterConfigsRootDir(XmlMetaStore metaStore) {
        String configsFolder = null != this.spoon.getRepository() ? "ServerConfigs" : "Configs";
        return System.getProperty("user.home") + File.separator + ".pentaho" + File.separator + "metastore" + File.separator + "pentaho" + File.separator + "NamedCluster" + File.separator + configsFolder;
    }

    public String newNamedCluster(VariableSpace variableSpace, IMetaStore metaStore, Shell shell) {
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        NamedCluster nc = this.namedClusterService.getClusterTemplate();
        NamedClusterDialogImpl namedClusterDialogImpl = this.commonDialogFactory.createNamedClusterDialog(shell, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, nc);
        namedClusterDialogImpl.setNewClusterCheck(true);
        String result = namedClusterDialogImpl.open();
        if (result != null) {
            if (variableSpace != null) {
                nc.shareVariablesWith(variableSpace);
            } else {
                nc.initializeVariablesFrom(null);
            }
            try {
                this.saveNamedCluster(metaStore, nc);
                this.addConfigProperties(nc);
            }
            catch (Exception e) {
                this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_MESSAGE, (String[])new String[]{nc.getName()}), e);
                this.spoon.refreshTree();
                return nc.getName();
            }
            this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
            return nc.getName();
        }
        return null;
    }

    private void addConfigProperties(NamedCluster namedCluster) throws Exception {
        Path clusterConfigDirPath = Paths.get(this.getNamedClusterConfigsRootDir(null) + "/" + namedCluster.getName(), new String[0]);
        Path configPropertiesPath = Paths.get(this.getNamedClusterConfigsRootDir(null) + "/" + namedCluster.getName() + "/config.properties", new String[0]);
        Files.createDirectories(clusterConfigDirPath, new FileAttribute[0]);
        String sampleConfigProperties = namedCluster.getShimIdentifier() + "sampleconfig.properties";
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(sampleConfigProperties);
        if (inputStream != null) {
            Files.copy(inputStream, configPropertiesPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void deleteNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        try {
            if (this.namedClusterService.read(namedCluster.getName(), metaStore) != null) {
                this.namedClusterService.delete(namedCluster.getName(), metaStore);
                XmlMetaStore xmlMetaStore = this.getXmlMetastore(metaStore);
                if (xmlMetaStore != null) {
                    String path = this.getNamedClusterConfigsRootDir(xmlMetaStore) + "/" + namedCluster.getName();
                    try {
                        FileUtils.deleteDirectory((File)new File(path));
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (MetaStoreException e) {
            this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_MESSAGE, (String[])new String[]{namedCluster.getName()}), (Exception)((Object)e));
        }
    }

    private void saveNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        try {
            this.namedClusterService.create(namedCluster, metaStore);
        }
        catch (MetaStoreException e) {
            this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_MESSAGE, (String[])new String[]{namedCluster.getName()}), (Exception)((Object)e));
        }
    }
}

