/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.services;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.kar.KarService;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.marketplace.domain.model.entities.MarketEntryType;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPluginVersion;
import org.pentaho.marketplace.domain.model.factories.interfaces.IDomainStatusMessageFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginVersionFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IVersionDataFactory;
import org.pentaho.marketplace.domain.services.BasePluginService;
import org.pentaho.marketplace.domain.services.interfaces.IRemotePluginProvider;
import org.pentaho.marketplace.util.XmlParserFactoryProducer;
import org.pentaho.marketplace.util.web.HttpUtil;
import org.pentaho.telemetry.ITelemetryService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DiPluginService
extends BasePluginService {
    private static final String BASE_PLUGINS_FOLDER_NAME = "plugins";

    private PluginRegistry getPluginRegistry() {
        return PluginRegistry.getInstance();
    }

    private BuildVersion getBuildVersion() {
        return BuildVersion.getInstance();
    }

    @Override
    protected String getServerVersion() {
        String version = super.getServerVersion();
        if (StringUtil.isEmpty((String)version)) {
            version = this.getBuildVersion().getVersion();
            this.setServerVersion(version);
        }
        return version;
    }

    public DiPluginService(IRemotePluginProvider metadataPluginsProvider, IVersionDataFactory versionDataFactory, IPluginVersionFactory pluginVersionFactory, KarService karService, FeaturesService featuresService, ConfigurationAdmin configurationAdmin, IDomainStatusMessageFactory domainStatusMessageFactory, ITelemetryService telemetryService) {
        super(metadataPluginsProvider, versionDataFactory, pluginVersionFactory, karService, featuresService, configurationAdmin, telemetryService, domainStatusMessageFactory);
    }

    @Override
    protected boolean hasMarketplacePermission() {
        return true;
    }

    @Override
    protected void unloadPlugin(IPlugin plugin) {
        List spoonPlugins;
        String parentFolderName = this.buildPluginsFolderPath(plugin);
        File pluginFolder = new File(parentFolderName + File.separator + plugin.getId());
        PluginRegistry pluginRegistry = this.getPluginRegistry();
        try {
            spoonPlugins = pluginRegistry.findPluginsByFolder(pluginFolder.toURI().toURL());
        }
        catch (MalformedURLException malformedUrlException) {
            this.getLogger().error((Object)("Malformed url from folder of plugin to uninstall: " + plugin.getId()), (Throwable)malformedUrlException);
            return;
        }
        for (PluginInterface spoonPlugin : spoonPlugins) {
            try {
                ClassLoader cl = pluginRegistry.getClassLoader(spoonPlugin);
                if (cl instanceof KettleURLClassLoader) {
                    ((KettleURLClassLoader)cl).closeClassLoader();
                }
            }
            catch (KettlePluginException e) {
                this.getLogger().debug((Object)"Unable to get classloader for plugin ");
            }
            pluginRegistry.removePlugin(spoonPlugin.getPluginType(), spoonPlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IPluginVersion getInstalledNonOsgiPluginVersion(IPlugin plugin) {
        String versionPath;
        File file;
        IPluginVersion pluginVersion = (IPluginVersion)this.getPluginVersionFactory().create();
        pluginVersion.setIsOsgi(false);
        String pluginFolder = this.buildPluginsFolderPath(plugin) + File.separator + plugin.getId();
        File pluginFolderFile = new File(pluginFolder);
        if (!pluginFolderFile.exists()) {
            this.getLogger().debug((Object)("Plugin " + plugin.getId() + " not found at expected folder " + pluginFolderFile.getPath()));
            pluginFolder = BASE_PLUGINS_FOLDER_NAME + File.separator + plugin.getId();
            pluginFolderFile = new File(pluginFolder);
            if (!pluginFolderFile.exists()) {
                this.getLogger().debug((Object)("Plugin " + plugin.getId() + " not found at expected folder " + pluginFolderFile.getPath()));
                return null;
            }
        }
        if (!(file = new File(versionPath = pluginFolder + File.separator + "version.xml")).exists()) {
            return pluginVersion;
        }
        InputStreamReader reader = null;
        try {
            DocumentBuilderFactory dbf = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            reader = new FileReader(versionPath);
            Document dom = db.parse(new InputSource(reader));
            NodeList versionElements = dom.getElementsByTagName("version");
            if (versionElements.getLength() >= 1) {
                Element versionElement = (Element)versionElements.item(0);
                pluginVersion.setBuildId(versionElement.getAttribute("buildId"));
                pluginVersion.setBranch(versionElement.getAttribute("branch"));
                pluginVersion.setVersion(versionElement.getTextContent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pluginVersion;
    }

    @Override
    protected Collection<String> getInstalledNonOsgiPluginIds() {
        Collection<String> pluginIds = this.getInstalledPluginIdsFromFolders();
        return pluginIds;
    }

    private Collection<String> getInstalledPluginIdsFromFolders() {
        HashSet<String> pluginIds = new HashSet<String>();
        for (MarketEntryType type : MarketEntryType.values()) {
            String pluginTypeFolderName = this.getInstallationSubfolder(type);
            pluginTypeFolderName = BASE_PLUGINS_FOLDER_NAME + (pluginTypeFolderName == null ? "" : Const.FILE_SEPARATOR + pluginTypeFolderName);
            File pluginTypeFolder = new File(pluginTypeFolderName);
            File[] files = pluginTypeFolder.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.isDirectory()) continue;
                String folderNamePotentialPluginId = file.getName();
                pluginIds.add(folderNamePotentialPluginId);
            }
        }
        return pluginIds;
    }

    @Override
    protected boolean executeNonOsgiInstall(IPlugin plugin, IPluginVersion version) {
        File bdPluginFolder;
        String parentFolderName = this.buildPluginsFolderPath(plugin);
        if (plugin.getType().equals((Object)MarketEntryType.HadoopShim) && ((bdPluginFolder = new File(parentFolderName).getParentFile()) == null || !bdPluginFolder.exists())) {
            return false;
        }
        File pluginFolder = new File(parentFolderName + File.separator + plugin.getId());
        this.getLogger().info((Object)("Installing plugin in folder: " + pluginFolder.getAbsolutePath()));
        try {
            if (pluginFolder.exists()) {
                DiPluginService.deleteDirectory(pluginFolder);
            }
            DiPluginService.unzipMarketEntry(parentFolderName, version.getDownloadUrl());
            this.createVersionXML(plugin, version);
        }
        catch (KettleException e) {
            this.getLogger().error((Object)"ERROR on delete or create", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean executeNonOsgiUninstall(IPlugin plugin) {
        String parentFolderName = this.buildPluginsFolderPath(plugin);
        File pluginFolder = new File(parentFolderName + File.separator + plugin.getId());
        this.getLogger().info((Object)("Uninstalling plugin in folder: " + pluginFolder.getAbsolutePath()));
        if (!pluginFolder.exists()) {
            File rootPluginFolder = new File(BASE_PLUGINS_FOLDER_NAME + File.separator + plugin.getId());
            if (!rootPluginFolder.exists()) {
                this.getLogger().error((Object)("No plugin was found in the expected folder : " + pluginFolder.getAbsolutePath()));
                return false;
            }
            pluginFolder = rootPluginFolder;
        }
        try {
            DiPluginService.deleteDirectory(pluginFolder);
        }
        catch (KettleException exception) {
            this.getLogger().error((Object)("Error deleting plugin folder on uninstall of plugin " + plugin.getId()));
            return false;
        }
        return true;
    }

    @Override
    public Map<String, IPlugin> getPlugins() {
        Map<String, IPlugin> plugins = super.getPlugins();
        CollectionUtils.filter(plugins.entrySet(), (Predicate)new Predicate(){

            public boolean evaluate(Object mapEntry) {
                Map.Entry mapEntryCasted = (Map.Entry)mapEntry;
                return ((IPlugin)mapEntryCasted.getValue()).getType() != MarketEntryType.Platform;
            }
        });
        return plugins;
    }

    public String buildPluginsFolderPath(IPlugin marketEntry) {
        PluginInterface plugin = this.getPluginObject(marketEntry.getId());
        if (plugin != null && plugin.getPluginDirectory() != null) {
            return new File(plugin.getPluginDirectory().getFile()).getParent();
        }
        String subfolder = this.getInstallationSubfolder(marketEntry.getType());
        return BASE_PLUGINS_FOLDER_NAME + (subfolder == null ? "" : Const.FILE_SEPARATOR + subfolder);
    }

    private PluginInterface getPluginObject(String pluginId) {
        PluginRegistry pluginRegistry = this.getPluginRegistry();
        for (Class pluginType : pluginRegistry.getPluginTypes()) {
            if (pluginRegistry.findPluginWithId(pluginType, pluginId) == null) continue;
            return pluginRegistry.findPluginWithId(pluginType, pluginId);
        }
        return null;
    }

    public String getInstallationSubfolder(MarketEntryType marketEntryType) {
        String subfolder;
        switch (marketEntryType) {
            case Step: {
                subfolder = "steps";
                break;
            }
            case JobEntry: {
                subfolder = "jobentries";
                break;
            }
            case Partitioner: {
                subfolder = "steps";
                break;
            }
            case SpoonPlugin: {
                subfolder = "spoon";
                break;
            }
            case Database: {
                subfolder = "databases";
                break;
            }
            case HadoopShim: {
                subfolder = "pentaho-big-data-plugin" + File.separator + "hadoop-configurations";
                break;
            }
            case Mixed: {
                subfolder = "";
                break;
            }
            default: {
                subfolder = null;
            }
        }
        return subfolder;
    }

    private static void deleteDirectory(File dir) throws KettleException {
        if (dir != null) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        DiPluginService.deleteDirectory(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new KettleException("Failed to delete " + files[i]);
                }
            }
            if (!dir.delete()) {
                throw new KettleException("Failed to delete directory " + dir);
            }
        }
    }

    private void createVersionXML(IPlugin marketEntry, IPluginVersion version) throws KettleException {
        String pluginFolder = this.buildPluginsFolderPath(marketEntry) + File.separator + marketEntry.getId();
        String versionPath = pluginFolder + File.separator + "version.xml";
        File parentFolder = new File(pluginFolder);
        File file = new File(versionPath);
        if (file != null) {
            BufferedWriter bufferedWriter = null;
            try {
                if (!parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                bufferedWriter = new BufferedWriter(fw);
                bufferedWriter.write("<version " + DiPluginService.buildAttribute("branch", version.getBranch()) + " " + DiPluginService.buildAttribute("buildId", version.getBuildId()) + ">" + version.getVersion() + "</version>");
            }
            catch (IOException ioe) {
                throw new KettleException((Throwable)ioe);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException ioe) {
                        throw new KettleException((Throwable)ioe);
                    }
                }
            }
        }
    }

    private static String buildAttribute(String name, String value) {
        return DiPluginService.nullOrEmpty(value) ? "" : name + "='" + value + "'";
    }

    private static boolean nullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private static void unzipMarketEntry(String folderName, String packageUrl) throws KettleException {
        File tmpFile = null;
        FileInputStream inputStream = null;
        ZipInputStream zis = null;
        try {
            InputStream urlInputStream = HttpUtil.getURLInputStream(packageUrl);
            if (urlInputStream == null) {
                throw new KettleException("Unable get file from " + packageUrl);
            }
            tmpFile = File.createTempFile("plugin", ".zip");
            FileUtils.copyInputStreamToFile((InputStream)urlInputStream, (File)tmpFile);
            inputStream = new FileInputStream(tmpFile);
            zis = new ZipInputStream(inputStream);
            ZipEntry zipEntry = null;
            try {
                zipEntry = zis.getNextEntry();
            }
            catch (IOException ioe) {
                throw new KettleException((Throwable)ioe);
            }
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            FileOutputStream fos = null;
            while (zipEntry != null) {
                try {
                    File file = new File(folderName + File.separator + zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        file.getParentFile().mkdirs();
                        fos = new FileOutputStream(file);
                        while ((bytesRead = zis.read(buffer)) != -1) {
                            fos.write(buffer, 0, bytesRead);
                        }
                    }
                    zipEntry = zis.getNextEntry();
                }
                catch (FileNotFoundException fnfe) {
                    throw new KettleException((Throwable)fnfe);
                }
                catch (IOException ioe) {
                    throw new KettleException((Throwable)ioe);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException e) {
            throw new KettleException("Unable to unzip file " + packageUrl, (Throwable)e);
        }
        finally {
            if (zis != null) {
                tmpFile.delete();
                try {
                    zis.close();
                }
                catch (Exception e) {
                    throw new KettleException("Unable to close zip file stream (corrupt file?) of file " + tmpFile, (Throwable)e);
                }
            }
        }
    }
}

