/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.services;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.kar.KarService;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDomainStatusMessage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPluginVersion;
import org.pentaho.marketplace.domain.model.entities.interfaces.IVersionData;
import org.pentaho.marketplace.domain.model.factories.interfaces.IDomainStatusMessageFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginVersionFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IVersionDataFactory;
import org.pentaho.marketplace.domain.services.interfaces.IPluginProvider;
import org.pentaho.marketplace.domain.services.interfaces.IPluginService;
import org.pentaho.marketplace.domain.services.interfaces.IRemotePluginProvider;
import org.pentaho.telemetry.ITelemetryService;
import org.pentaho.telemetry.TelemetryEvent;

public abstract class BasePluginService
implements IPluginService {
    protected static final String UNAUTHORIZED_ACCESS_MESSAGE = "Unauthorized Access.";
    protected static final String UNAUTHORIZED_ACCESS_ERROR_CODE = "ERROR_0002_UNAUTHORIZED_ACCESS";
    protected static final String NO_PLUGIN_ERROR_CODE = "ERROR_0001_NO_PLUGIN";
    protected static final String FAIL_ERROR_CODE = "ERROR_0003_FAIL";
    protected static final String PLUGIN_INSTALLED_CODE = "PLUGIN_INSTALLED";
    protected static final String PLUGIN_UNINSTALLED_CODE = "PLUGIN_UNINSTALLED";
    protected static final String KARAF_FEATURES_CONFIG_PID = "org.apache.karaf.features";
    protected static final String KARAF_FEATURES_BOOT_PROPERTY_ID = "featuresBoot";
    protected static final String PENTAHO_FEATURES_CONFIG_PID = "org.pentaho.features";
    protected static final String PENTAHO_RUNTIME_FEATURES_PROPERTY_ID = "runtimeFeatures";
    protected Log logger = LogFactory.getLog(this.getClass());
    private IPluginProvider metadataPluginsProvider;
    private IVersionDataFactory versionDataFactory;
    private IPluginVersionFactory pluginVersionFactory;
    private KarService karService;
    private FeaturesService featuresService;
    private ITelemetryService telemetryService;
    private IDomainStatusMessageFactory domainStatusMessageFactory;
    private String serverVersion;
    private ConfigurationAdmin configurationAdmin;

    protected Log getLogger() {
        return this.logger;
    }

    public IPluginProvider getMetadataPluginsProvider() {
        return this.metadataPluginsProvider;
    }

    protected BasePluginService setMetadataPluginsProvider(IPluginProvider provider) {
        this.metadataPluginsProvider = provider;
        return this;
    }

    public IVersionDataFactory getVersionDataFactory() {
        return this.versionDataFactory;
    }

    protected void setVersionDataFactory(IVersionDataFactory versionDataFactory) {
        this.versionDataFactory = versionDataFactory;
    }

    public IPluginVersionFactory getPluginVersionFactory() {
        return this.pluginVersionFactory;
    }

    protected void setPluginVersionFactory(IPluginVersionFactory pluginVersionFactory) {
        this.pluginVersionFactory = pluginVersionFactory;
    }

    public KarService getKarService() {
        return this.karService;
    }

    protected void setKarService(KarService karService) {
        this.karService = karService;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    protected void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public ITelemetryService getTelemetryService() {
        return this.telemetryService;
    }

    protected void setTelemetryService(ITelemetryService telemetryService) {
        this.telemetryService = telemetryService;
    }

    public IDomainStatusMessageFactory getDomainStatusMessageFactory() {
        return this.domainStatusMessageFactory;
    }

    protected BasePluginService setDomainStatusMessageFactory(IDomainStatusMessageFactory domainStatusMessageFactory) {
        this.domainStatusMessageFactory = domainStatusMessageFactory;
        return this;
    }

    protected String getServerVersion() {
        return this.serverVersion;
    }

    protected BasePluginService setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    protected BasePluginService setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
        return this;
    }

    protected BasePluginService(IRemotePluginProvider metadataPluginsProvider, IVersionDataFactory versionDataFactory, IPluginVersionFactory pluginVersionFactory, KarService karService, FeaturesService featuresService, ConfigurationAdmin configurationAdmin, ITelemetryService telemetryService, IDomainStatusMessageFactory domainStatusMessageFactory) {
        this.setMetadataPluginsProvider(metadataPluginsProvider);
        this.setVersionDataFactory(versionDataFactory);
        this.setPluginVersionFactory(pluginVersionFactory);
        this.setKarService(karService);
        this.setFeaturesService(featuresService);
        this.setConfigurationAdmin(configurationAdmin);
        this.setTelemetryService(telemetryService);
        this.setDomainStatusMessageFactory(domainStatusMessageFactory);
    }

    private boolean withinParentVersion(IPluginVersion pv) {
        String v = this.getServerVersion();
        IVersionData pvMax = this.getVersionDataFactory().create(pv.getMaxParentVersion());
        IVersionData pvMin = this.getVersionDataFactory().create(pv.getMinParentVersion());
        IVersionData version = this.getVersionDataFactory().create(v);
        return version.within(pvMin, pvMax);
    }

    private Collection<IPluginVersion> getCompatibleVersionsWithParent(Iterable<IPluginVersion> versions) {
        ArrayList<IPluginVersion> compatibleVersions = new ArrayList<IPluginVersion>();
        for (IPluginVersion version : versions) {
            if (!this.withinParentVersion(version)) continue;
            compatibleVersions.add(version);
        }
        return compatibleVersions;
    }

    private Map<String, IPlugin> removeNonCompatibleVersions(Iterable<IPlugin> plugins) {
        HashMap<String, IPlugin> pluginsWithCompatibleVersions = new HashMap<String, IPlugin>();
        for (IPlugin plugin : plugins) {
            Collection<IPluginVersion> compatibleVersions = this.getCompatibleVersionsWithParent(plugin.getVersions());
            if (compatibleVersions.size() <= 0) continue;
            plugin.setVersions(compatibleVersions);
            pluginsWithCompatibleVersions.put(plugin.getId(), plugin);
        }
        return pluginsWithCompatibleVersions;
    }

    private boolean isPluginIdValid(String pluginId) {
        return pluginId != null && pluginId.length() > 0 && pluginId.indexOf(".") < 0;
    }

    public IPlugin getPlugin(String id) {
        return this.getPlugins().get(id);
    }

    public IPluginVersion getPluginVersion(IPlugin plugin, String versionBranch) {
        if (versionBranch != null && versionBranch.length() > 0) {
            return plugin.getVersionByBranch(versionBranch);
        }
        return null;
    }

    private Map<String, IPlugin> filterPlugins(Map<String, IPlugin> plugins, Collection<String> pluginIds) {
        if (pluginIds.size() < 1) {
            return Collections.emptyMap();
        }
        HashMap<String, IPlugin> filteredPlugins = new HashMap<String, IPlugin>();
        for (String pluginId : pluginIds) {
            IPlugin plugin = plugins.get(pluginId);
            if (plugin == null) continue;
            filteredPlugins.put(pluginId, plugin);
        }
        return filteredPlugins;
    }

    private void setPluginsAsInstalled(Collection<IPlugin> plugins) {
        for (IPlugin plugin : plugins) {
            plugin.setInstalled(true);
            IPluginVersion installedVersion = this.getInstalledPluginVersion(plugin);
            if (installedVersion == null) continue;
            plugin.setInstalledBranch(installedVersion.getBranch());
            plugin.setInstalledVersion(installedVersion.getVersion());
            plugin.setInstalledBuildId(installedVersion.getBuildId());
        }
    }

    private void publishTelemetryEvent(TelemetryEvent.Type eventType, IPlugin plugin, IPluginVersion version) {
        try {
            ITelemetryService telemetryService = this.getTelemetryService();
            TelemetryEvent event = telemetryService.createEvent(eventType);
            event.getExtraInfo().put("installedPlugin", plugin.getId());
            event.getExtraInfo().put("installedBranch", version.getBranch());
            event.getExtraInfo().put("installedVersion", version.getVersion());
            telemetryService.publishEvent(event);
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().debug((Object)"Failed to find class definitions. Most likely reason is reinstalling marketplace.", (Throwable)e);
        }
    }

    private IDomainStatusMessage upgradePluginAux(String pluginId, String versionBranch) {
        if (!this.hasMarketplacePermission()) {
            return this.getDomainStatusMessageFactory().create(UNAUTHORIZED_ACCESS_ERROR_CODE, UNAUTHORIZED_ACCESS_MESSAGE);
        }
        if (!this.isPluginIdValid(pluginId)) {
            return this.getDomainStatusMessageFactory().create(NO_PLUGIN_ERROR_CODE, "Invalid plugin id");
        }
        IPlugin plugin = this.getPlugin(pluginId);
        if (plugin == null) {
            return this.getDomainStatusMessageFactory().create(NO_PLUGIN_ERROR_CODE, "Plugin not found");
        }
        IPluginVersion pluginVersionToInstall = plugin.getVersionByBranch(versionBranch);
        if (pluginVersionToInstall == null) {
            return this.getDomainStatusMessageFactory().create(NO_PLUGIN_ERROR_CODE, "Plugin version for branch " + versionBranch + " not found");
        }
        ITelemetryService telemetryService = this.getTelemetryService();
        TelemetryEvent event = telemetryService.createEvent(TelemetryEvent.Type.UPGRADE);
        event.getExtraInfo().put("installedPlugin", plugin.getId());
        event.getExtraInfo().put("installedVersion", pluginVersionToInstall.getVersion());
        event.getExtraInfo().put("installedBranch", versionBranch);
        IDomainStatusMessage successMessage = this.domainStatusMessageFactory.create(PLUGIN_INSTALLED_CODE, plugin.getName() + " was successfully Upgraded.  Please restart. \n" + plugin.getInstallationNotes());
        IDomainStatusMessage upgradeInstallFailureMessage = this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Failed to install on plugin upgrade, see log for details.");
        IDomainStatusMessage upgradeUninstallFailureMessage = this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Failed to uninstall on plugin upgrade, see log for details.");
        if (!this.executeUninstall(plugin)) {
            return upgradeUninstallFailureMessage;
        }
        if (!this.executeInstall(plugin, pluginVersionToInstall)) {
            return upgradeInstallFailureMessage;
        }
        try {
            telemetryService.publishEvent(event);
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().debug((Object)"Failed to find class definitions. Most likely reason is reinstalling marketplace.", (Throwable)e);
        }
        return successMessage;
    }

    private IDomainStatusMessage installPluginAux(String pluginId, String versionBranch) throws MarketplaceSecurityException {
        if (!this.hasMarketplacePermission()) {
            throw new MarketplaceSecurityException();
        }
        if (!this.isPluginIdValid(pluginId)) {
            return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Invalid Plugin Id.");
        }
        IPlugin toInstall = this.getPlugin(pluginId);
        if (toInstall == null) {
            return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Plugin Not Found");
        }
        IPluginVersion versionToInstall = null;
        if (versionBranch != null && versionBranch.length() > 0) {
            versionToInstall = toInstall.getVersionByBranch(versionBranch);
            if (versionToInstall == null) {
                return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Plugin version not found");
            }
        } else {
            return this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Version " + versionBranch + " not found for plugin " + pluginId + ", see log for details.");
        }
        ITelemetryService telemetryService = this.getTelemetryService();
        TelemetryEvent event = telemetryService.createEvent(TelemetryEvent.Type.INSTALLATION);
        event.getExtraInfo().put("installedPlugin", toInstall.getId());
        event.getExtraInfo().put("installedVersion", versionToInstall.getVersion());
        event.getExtraInfo().put("installedBranch", versionBranch);
        IDomainStatusMessage successMessage = this.domainStatusMessageFactory.create(PLUGIN_INSTALLED_CODE, toInstall.getName() + " was successfully installed.  Please restart your BI Server. \n" + toInstall.getInstallationNotes());
        IDomainStatusMessage failureMessage = this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Failed to execute install, see log for details.");
        if (!this.executeInstall(toInstall, versionToInstall)) {
            return failureMessage;
        }
        try {
            telemetryService.publishEvent(event);
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().debug((Object)"Failed to find class definitions. Most likely reason is reinstalling marketplace.", (Throwable)e);
        }
        return successMessage;
    }

    private IDomainStatusMessage uninstallPluginAux(String pluginId) throws MarketplaceSecurityException {
        if (!this.hasMarketplacePermission()) {
            throw new MarketplaceSecurityException();
        }
        IPlugin toUninstall = this.getPlugin(pluginId);
        if (toUninstall == null) {
            return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Plugin Not Found");
        }
        ITelemetryService telemetryService = this.getTelemetryService();
        TelemetryEvent event = telemetryService.createEvent(TelemetryEvent.Type.INSTALLATION);
        event.getExtraInfo().put("uninstalledPlugin", toUninstall.getId());
        event.getExtraInfo().put("uninstalledPluginVersion", toUninstall.getInstalledVersion());
        event.getExtraInfo().put("uninstalledPluginBranch", toUninstall.getInstalledBranch());
        IDomainStatusMessage successMessage = this.domainStatusMessageFactory.create(PLUGIN_UNINSTALLED_CODE, toUninstall.getName() + " was successfully uninstalled.  Please restart your BI Server.");
        IDomainStatusMessage failureMessage = this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Failed to execute uninstall, see log for details.");
        if (!this.executeUninstall(toUninstall)) {
            return failureMessage;
        }
        try {
            telemetryService.publishEvent(event);
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().debug((Object)"Failed to find class definitions. Most likely reason is uninstalling marketplace.", (Throwable)e);
        }
        return successMessage;
    }

    @Override
    public Map<String, IPlugin> getPlugins() {
        Map<String, IPlugin> marketplacePlugins = this.getMetadataPluginsProvider().getPlugins();
        Map<String, IPlugin> compatiblePlugins = this.removeNonCompatibleVersions(marketplacePlugins.values());
        Collection<String> installedPluginIds = this.getInstalledPluginIds();
        Map<String, IPlugin> installedPlugins = this.filterPlugins(compatiblePlugins, installedPluginIds);
        this.setPluginsAsInstalled(installedPlugins.values());
        return compatiblePlugins;
    }

    @Override
    public IDomainStatusMessage installPlugin(String pluginId, String versionBranch) {
        try {
            IPlugin plugin = this.getPlugin(pluginId);
            if (plugin != null && plugin.isInstalled()) {
                return this.upgradePluginAux(pluginId, versionBranch);
            }
            return this.installPluginAux(pluginId, versionBranch);
        }
        catch (MarketplaceSecurityException e) {
            this.getLogger().debug((Object)e.getMessage(), (Throwable)e);
            return this.domainStatusMessageFactory.create(UNAUTHORIZED_ACCESS_ERROR_CODE, UNAUTHORIZED_ACCESS_MESSAGE);
        }
    }

    @Override
    public IDomainStatusMessage uninstallPlugin(String pluginId) {
        try {
            return this.uninstallPluginAux(pluginId);
        }
        catch (MarketplaceSecurityException e) {
            this.getLogger().debug((Object)e.getMessage(), (Throwable)e);
            return this.domainStatusMessageFactory.create(UNAUTHORIZED_ACCESS_ERROR_CODE, UNAUTHORIZED_ACCESS_MESSAGE);
        }
    }

    protected boolean executeOsgiInstallViaKarService(IPlugin plugin, IPluginVersion versionToInstall) {
        if (versionToInstall.isOsgi()) {
            this.getLogger().debug((Object)"## Install Osgi Plugin ##");
            try {
                URI uri = new URL(versionToInstall.getDownloadUrl()).toURI();
                this.getKarService().install(uri);
                return true;
            }
            catch (Exception e) {
                this.getLogger().warn((Object)"Failed to install OSGi plugin.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private String getKarafDeployFolder() {
        return System.getProperty("karaf.base") + File.separator + "deploy";
    }

    protected boolean executeOsgiInstall(IPlugin plugin, IPluginVersion versionToInstall) {
        if (versionToInstall.isOsgi()) {
            this.getLogger().debug((Object)("Installing Osgi Plugin " + plugin.getId()));
            try {
                String deployFolderName = this.getKarafDeployFolder();
                String downloadUrl = versionToInstall.getDownloadUrl();
                File dlKarFile = new File(deployFolderName + File.separator + plugin.getId() + ".kar");
                FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)dlKarFile);
                return true;
            }
            catch (Exception e) {
                this.getLogger().warn((Object)("Failed to install OSGi plugin " + plugin.getId()), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean executeOsgiUninstallViaKarService(IPlugin plugin) {
        this.getLogger().debug((Object)("Uninstalling Osgi Plugin " + plugin.getId()));
        try {
            this.getKarService().uninstall(plugin.getId());
            return true;
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("Failed to uninstall OSGi plugin " + plugin.getId()), (Throwable)e);
            return false;
        }
    }

    protected boolean executeOsgiUninstall(IPlugin plugin) {
        String pluginId = plugin.getId();
        this.removeFeatureFromKarafBoot(pluginId);
        try {
            this.getFeaturesService().uninstallFeature(pluginId);
        }
        catch (Exception e) {
            this.getLogger().debug((Object)("No installed feature found with name " + pluginId + " when uninstalling OSGI plugin."));
        }
        String deployFolder = this.getKarafDeployFolder();
        File karFile = new File(deployFolder + File.separator + pluginId + ".kar");
        if (karFile.exists() && karFile.isFile()) {
            return FileUtils.deleteQuietly((File)karFile);
        }
        return true;
    }

    private void removeFeatureFromKarafBoot(String featureName) {
        this.removeFeatureFromKarafBoot(featureName, KARAF_FEATURES_CONFIG_PID, KARAF_FEATURES_BOOT_PROPERTY_ID);
        this.removeFeatureFromKarafBoot(featureName, PENTAHO_FEATURES_CONFIG_PID, PENTAHO_RUNTIME_FEATURES_PROPERTY_ID);
    }

    private void removeFeatureFromKarafBoot(String featureName, String configurationPid, String propertyId) {
        ConfigurationAdmin configurationAdmin = this.getConfigurationAdmin();
        Log logger = this.getLogger();
        try {
            Configuration configuration = configurationAdmin.getConfiguration(configurationPid);
            Dictionary properties = configuration.getProperties();
            if (properties == null) {
                logger.debug((Object)("Configuration " + configurationPid + " has no properties."));
                return;
            }
            String propertyValue = (String)properties.get(propertyId);
            if (propertyValue == null) {
                logger.debug((Object)("Property " + propertyId + " not set in configuration " + configurationPid + "."));
                return;
            }
            String newPropertyValue = propertyValue.replaceFirst("," + featureName, "");
            if (!propertyValue.equals(newPropertyValue)) {
                properties.put(propertyId, newPropertyValue);
                configuration.update(properties);
            }
        }
        catch (IOException e) {
            logger.debug((Object)("Unable to access configuration " + configurationPid + "."));
        }
    }

    private IPluginVersion getInstalledOsgiPluginVersion(IPlugin plugin) {
        this.getLogger().debug((Object)"Infer Version from installed Osgi Plugin");
        IPluginVersion installedOsgiPluginVersion = this.getInstalledOsgiPluginVersionFromFeatures(plugin);
        if (installedOsgiPluginVersion == null) {
            installedOsgiPluginVersion = this.getInstalledOsgiPluginVersionFromKars(plugin);
        }
        return installedOsgiPluginVersion;
    }

    private IPluginVersion getInstalledOsgiPluginVersionFromKars(IPlugin plugin) {
        try {
            if (this.getKarService().list().contains(plugin.getId())) {
                IPluginVersion installedPluginVersion = (IPluginVersion)this.getPluginVersionFactory().create();
                installedPluginVersion.setIsOsgi(true);
                return installedPluginVersion;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private IPluginVersion getInstalledOsgiPluginVersionFromFeatures(IPlugin plugin) {
        this.getLogger().debug((Object)"## Infer Version from Karaf features ##");
        try {
            String pluginId = plugin.getId();
            Feature feature = this.getFeaturesService().getFeature(pluginId);
            if (feature != null) {
                IPluginVersion installedPluginVersion = (IPluginVersion)this.getPluginVersionFactory().create();
                installedPluginVersion.setIsOsgi(true);
                installedPluginVersion.setVersion(feature.getVersion());
                installedPluginVersion.setBranch(null);
                installedPluginVersion.setBuildId(null);
                return installedPluginVersion;
            }
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"Failed to infer version of installed OSGi plugin from features.", (Throwable)e);
            return null;
        }
        return null;
    }

    private IPluginVersion getInstalledPluginVersion(IPlugin plugin) {
        IPluginVersion osgiPluginVersion = this.getInstalledOsgiPluginVersion(plugin);
        if (osgiPluginVersion != null) {
            return osgiPluginVersion;
        }
        return this.getInstalledNonOsgiPluginVersion(plugin);
    }

    private Collection<String> getInstalledOsgiPluginIds() {
        HashSet<String> potentialOsgiPluginIds = new HashSet<String>();
        try {
            for (String installedKar : this.getKarService().list()) {
                potentialOsgiPluginIds.add(installedKar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Feature feature : this.getFeaturesService().listInstalledFeatures()) {
                potentialOsgiPluginIds.add(feature.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return potentialOsgiPluginIds;
    }

    private Collection<String> getInstalledPluginIds() {
        Collection<String> installedPluginIds = this.getInstalledOsgiPluginIds();
        installedPluginIds.addAll(this.getInstalledNonOsgiPluginIds());
        return installedPluginIds;
    }

    private boolean executeInstall(IPlugin plugin, IPluginVersion version) {
        if (version.isOsgi()) {
            return this.executeOsgiInstall(plugin, version);
        }
        this.unloadPlugin(plugin);
        return this.executeNonOsgiInstall(plugin, version);
    }

    private boolean executeUninstall(IPlugin plugin) {
        IPluginVersion version = this.getInstalledPluginVersion(plugin);
        if (version == null) {
            this.getLogger().debug((Object)("Did not find plugin version for installed plugin: " + plugin.getId()));
            return false;
        }
        if (version.isOsgi()) {
            return this.executeOsgiUninstall(plugin);
        }
        this.unloadPlugin(plugin);
        return this.executeNonOsgiUninstall(plugin);
    }

    protected abstract boolean hasMarketplacePermission();

    protected abstract void unloadPlugin(IPlugin var1);

    protected abstract boolean executeNonOsgiInstall(IPlugin var1, IPluginVersion var2);

    protected abstract boolean executeNonOsgiUninstall(IPlugin var1);

    protected abstract IPluginVersion getInstalledNonOsgiPluginVersion(IPlugin var1);

    protected abstract Collection<String> getInstalledNonOsgiPluginIds();

    protected static class MarketplaceSecurityException
    extends Exception {
        private static final long serialVersionUID = -1852471739131561628L;

        protected MarketplaceSecurityException() {
        }
    }
}

