/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.pdi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.platform.api.engine.IPlatformWebResource;

public class WebContextServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map<String, Set<IPlatformWebResource>> contextResourcesMap = new HashMap<String, Set<IPlatformWebResource>>();
    static final String WEB_CONTEXT_JS = "webcontext.js";
    static final String CONTEXT_PATH = Const.isRunningOnWebspoonMode() ? "/spoon/osgi" : "/";
    private static final String REQUIREJS_INIT_LOCATION = Const.isRunningOnWebspoonMode() ? "requirejs-manager/js/require-init.js?useFullyQualifiedUrl=false" : "requirejs-manager/js/require-init.js";
    private static final String DEFAULT_SERVICES_ROOT = "cxf/";
    private static final Integer DEFAULT_WAIT_TIME = 30;
    static final String CONTEXT = "context";
    static final String LOCALE = "locale";
    static final String APPLICATION = "application";
    private Integer requireWaitTime;
    private String servicesRoot;

    public void setRequireWaitTime(Integer value) {
        this.requireWaitTime = value;
    }

    public Integer getRequireWaitTime() {
        Integer waitTime = this.requireWaitTime;
        if (waitTime == null) {
            waitTime = DEFAULT_WAIT_TIME;
        }
        return waitTime;
    }

    public void setServicesRoot(String value) {
        this.servicesRoot = value;
    }

    public String getServicesRoot() {
        String servicesRoot = this.servicesRoot;
        if (StringUtils.isEmpty((String)servicesRoot)) {
            servicesRoot = DEFAULT_SERVICES_ROOT;
        }
        return servicesRoot;
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        String requestStr = httpRequest.getRequestURI();
        if (requestStr != null && requestStr.contains(WEB_CONTEXT_JS)) {
            httpResponse.setContentType("text/javascript");
            try (PrintWriter printWriter = new PrintWriter((OutputStream)httpResponse.getOutputStream());){
                this.writeWebContextVar(printWriter, "dojoConfig", "[]", false, false);
                this.writeWebContextVar(printWriter, "CONTEXT_PATH", CONTEXT_PATH);
                this.writeWebContextVar(printWriter, "IS_RUNNING_ON_WEBSPOON_MODE", String.valueOf(Const.isRunningOnWebspoonMode()), false, false);
                String locale = this.getLocale(httpRequest);
                this.writeWebContextVar(printWriter, "SESSION_LOCALE", locale);
                this.writeLocaleModule(printWriter, locale);
                this.writeWebContextVar(printWriter, "requireCfg", this.getRequireCfg(), false, false);
                this.writeEnvironmentModuleConfig(printWriter, httpRequest);
                this.writeDocumentWriteResource(printWriter, REQUIREJS_INIT_LOCATION);
                this.writeJsWebResources(printWriter, httpRequest);
                this.writeCssWebResources(printWriter, httpRequest);
            }
        } else {
            httpResponse.sendError(404);
        }
    }

    public void destroy() {
    }

    private void writeWebContextVar(PrintWriter writer, String variable, String value) {
        this.writeWebContextVar(writer, variable, value, true, true);
    }

    private void writeWebContextVar(PrintWriter writer, String variable, String value, boolean deprecated, boolean escapeValue) {
        if (escapeValue) {
            value = this.escapeEnvironmentVar(value);
        }
        if (deprecated) {
            writer.write("\n/** @deprecated - use 'pentaho/environment' module's variable instead */");
        }
        writer.write("\nvar " + variable + " = " + value + ";\n");
    }

    private void writeLocaleModule(PrintWriter writer, String value) {
        value = this.escapeEnvironmentVar(value);
        writer.write("// If RequireJs is available, supply a module");
        writer.write("\nif (typeof(pen) !== 'undefined' && pen.define) {");
        writer.write("\n  pen.define('Locale', { locale: " + value + " });");
        writer.write("\n}\n");
    }

    private void writeEnvironmentModuleConfig(PrintWriter writer, HttpServletRequest request) {
        String application = this.escapeEnvironmentVar(this.getApplication(request));
        String locale = this.escapeEnvironmentVar(this.getLocale(request));
        String serverRoot = this.escapeEnvironmentVar(this.getServerRoot());
        String serverPackages = this.escapeEnvironmentVar(this.getServerPackages());
        String serverServices = this.escapeEnvironmentVar(this.getServerServices());
        writer.write("\nrequireCfg.config[\"pentaho/environment\"] = {");
        writer.write("\n  application: " + application + ",");
        writer.write("\n  theme: null,");
        writer.write("\n  locale: " + locale + ",");
        writer.write("\n  user: {");
        writer.write("\n    id: null,");
        writer.write("\n    home: null");
        writer.write("\n  },");
        writer.write("\n  server: {");
        writer.write("\n    root: " + serverRoot + ",");
        writer.write("\n    packages: " + serverPackages + ",");
        writer.write("\n    services: " + serverServices);
        writer.write("\n  },");
        writer.write("\n  reservedChars: null");
        writer.write("\n};\n");
    }

    private void writeJsWebResources(PrintWriter writer, HttpServletRequest request) {
        String contextName = this.getContextName(request);
        List<String> resources = this.getWebResources(contextName, ".*\\.js");
        this.writeWebResources(writer, resources);
    }

    private void writeCssWebResources(PrintWriter writer, HttpServletRequest request) {
        String contextName = this.getContextName(request);
        List<String> resources = this.getWebResources(contextName, ".*\\.css");
        this.writeWebResources(writer, resources);
    }

    void writeWebResources(PrintWriter writer, List<String> resources) {
        resources.stream().forEach(location -> {
            if (location.startsWith("/")) {
                location = location.substring(1);
            }
            this.writeDocumentWriteResource(writer, (String)location);
        });
    }

    private void writeDocumentWriteResource(PrintWriter writer, String location) {
        boolean isJavascript = Const.isRunningOnWebspoonMode() ? location.contains(".js") : location.endsWith(".js");
        writer.write("document.write(\"");
        if (isJavascript) {
            writer.write("<script type='text/javascript' src=");
        } else {
            writer.write("<link rel='stylesheet' type='text/css' href=");
        }
        if (Const.isRunningOnWebspoonMode()) {
            writer.write("'\" + CONTEXT_PATH + \"/" + location + "'>");
        } else {
            writer.write("'\" + CONTEXT_PATH + \"" + location + "'>");
        }
        writer.append(isJavascript ? "</scr\" + \"ipt>" : "");
        writer.write("\");\n");
    }

    private String escapeEnvironmentVar(String variable) {
        if (variable == null) {
            return null;
        }
        return "\"" + StringEscapeUtils.escapeJavaScript((String)variable) + "\"";
    }

    List<String> getWebResources(String context, String filePattern) {
        Set<IPlatformWebResource> resources = this.contextResourcesMap.get(context);
        if (CollectionUtils.isNotEmpty(resources)) {
            List<String> webResources = resources.stream().filter(iPlatformWebResource -> iPlatformWebResource.getLocation().matches(filePattern)).map(IPlatformWebResource::getLocation).collect(Collectors.toList());
            return webResources;
        }
        return Collections.EMPTY_LIST;
    }

    private String getLocale(HttpServletRequest request) {
        String locale;
        Locale defaultLocale = LanguageChoice.getInstance().getDefaultLocale();
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        if (StringUtils.isEmpty((String)(locale = request.getParameter(LOCALE)))) {
            locale = defaultLocale.toString();
        }
        return locale;
    }

    private String getApplication(HttpServletRequest request) {
        return request.getParameter(APPLICATION);
    }

    private String getContextName(HttpServletRequest request) {
        String context = request.getParameter(CONTEXT);
        return StringUtils.isNotEmpty((String)context) ? context : null;
    }

    String getServerRoot() {
        return CONTEXT_PATH;
    }

    String getServerPackages() {
        return CONTEXT_PATH;
    }

    String getServerServices() {
        String servicesRoot = this.getServicesRoot();
        boolean isRootValid = StringUtils.isNotEmpty((String)servicesRoot);
        if (isRootValid && servicesRoot.startsWith("/")) {
            servicesRoot = servicesRoot.substring(1);
        }
        if (isRootValid && !servicesRoot.endsWith("/")) {
            servicesRoot = servicesRoot + "/";
        }
        return CONTEXT_PATH + servicesRoot;
    }

    private String getRequireCfg() {
        StringBuilder requireCfg = new StringBuilder();
        requireCfg.append("{").append("\n  waitSeconds: ").append(this.getRequireWaitTime()).append(",").append("\n  paths: {},").append("\n  shim: {},").append("\n  map: { \"*\": {} },").append("\n  bundles: {},").append("\n  config: { \"pentaho/modules\": {} },").append("\n  packages: []").append("\n}");
        return requireCfg.toString();
    }

    public void addPlatformWebResource(IPlatformWebResource resource) {
        if (resource == null) {
            return;
        }
        String resourceContext = resource.getContext();
        if (!this.contextResourcesMap.containsKey(resourceContext)) {
            this.contextResourcesMap.put(resourceContext, new HashSet());
        }
        this.contextResourcesMap.get(resourceContext).add(resource);
    }

    public void removePlatformWebResource(IPlatformWebResource resource) {
        if (resource == null) {
            return;
        }
        String resourceContext = resource.getContext();
        if (this.contextResourcesMap.containsKey(resourceContext)) {
            this.contextResourcesMap.get(resourceContext).remove(resource);
        }
    }
}

