/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.pdi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import mondrian.olap.MondrianProperties;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.pdi.AgileBiAuthorizationPolicy;
import org.pentaho.platform.pdi.AgileBiPluginResourceLoader;
import org.pentaho.platform.pdi.vfs.MetadataToMondrianVfs;
import org.pentaho.platform.plugin.services.pluginmgr.PentahoSystemPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdiPlatformActivator
implements BundleActivator {
    public static final IPluginResourceLoader RESOURCE_LOADER = new AgileBiPluginResourceLoader();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void start(BundleContext bundleContext) throws Exception {
        if (PentahoSystem.get(IAuthorizationPolicy.class) == null) {
            PentahoSystem.registerObject((Object)new AgileBiAuthorizationPolicy());
        }
        if (PentahoSystem.get(IPluginResourceLoader.class) == null) {
            PentahoSystem.registerObject((Object)RESOURCE_LOADER);
        }
        if (PentahoSystem.get(IPluginManager.class) == null) {
            PentahoSystem.registerObject((Object)new PentahoSystemPluginManager(){

                public Object getPluginSetting(String pluginId, String key, String defaultValue) {
                    return null;
                }
            });
        }
        if (PentahoSystem.getInitializedStatus() != 0) {
            PentahoSystem.init();
        }
        String solutionPath = PentahoSystem.getApplicationContext().getSolutionPath("system/mondrian/mondrian.properties");
        try {
            MondrianProperties.instance().load((InputStream)new FileInputStream(new File(solutionPath)));
        }
        catch (IOException e) {
            this.logger.error("Error loading mondrian properties", (Throwable)e);
        }
        try {
            ((DefaultFileSystemManager)VFS.getManager()).addProvider("mtm", (FileProvider)new MetadataToMondrianVfs());
        }
        catch (FileSystemException e) {
            if (e.getCode().equals("vfs.impl/multiple-providers-for-scheme.error")) {
                this.logger.error("There is already a vfs provider registered for scheme mtm", (Throwable)e);
            }
            this.logger.error("There is already a vfs provider registered for scheme mtm", (Throwable)e);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

