/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.invocationhandler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.pentaho.hadoop.shim.common.HiveSQLUtils;
import org.pentaho.hadoop.shim.common.invocationhandler.CaptureResultSetInvocationHandler;
import org.pentaho.hadoop.shim.common.invocationhandler.DatabaseMetaDataInvocationHandler;

public class ConnectionInvocationHandler
implements InvocationHandler {
    Connection connection;

    public ConnectionInvocationHandler(Connection obj) {
        this.connection = obj;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Statement st;
        Object o = null;
        try {
            if ("prepareStatement".equals(method.getName())) {
                String sql = (String)args[0];
                args[0] = HiveSQLUtils.processSQLString(sql);
            }
            o = method.invoke((Object)this.connection, args);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable cause = t.getCause();
                if (cause instanceof SQLException) {
                    String methodName = method.getName();
                    if (cause.getMessage().startsWith("Method not supported") || cause.getMessage().equals("enabling autocommit is not supported")) {
                        if ("createStatement".equals(methodName)) {
                            o = this.createStatement(this.connection, args);
                        }
                        if ("isReadOnly".equals(methodName)) {
                            o = Boolean.FALSE;
                        }
                        if ("setReadOnly".equals(methodName)) {
                            o = null;
                        }
                        if ("setAutoCommit".equals(methodName)) {
                            o = null;
                        }
                        throw cause;
                    }
                    throw cause;
                }
                throw cause;
            }
            throw t;
        }
        if (o instanceof DatabaseMetaData) {
            DatabaseMetaData dbmd = (DatabaseMetaData)o;
            return (DatabaseMetaData)Proxy.newProxyInstance(dbmd.getClass().getClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)new DatabaseMetaDataInvocationHandler(dbmd, this));
        }
        if (o instanceof PreparedStatement) {
            st = (PreparedStatement)o;
            return (PreparedStatement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, new CaptureResultSetInvocationHandler<Statement>(st));
        }
        if (o instanceof Statement) {
            st = (Statement)o;
            return (Statement)Proxy.newProxyInstance(st.getClass().getClassLoader(), new Class[]{Statement.class}, new CaptureResultSetInvocationHandler<Statement>(st));
        }
        return o;
    }

    public Statement createStatement(Connection c, Object[] args) throws SQLException {
        if (c.isClosed()) {
            throw new SQLException("Can't create Statement, connection is closed ");
        }
        return c.createStatement();
    }
}

