/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.table;

import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandle;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionPool;
import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceFactoryImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.table.HBaseTableWriteOperationManagerImpl;
import com.pentaho.big.data.bundles.impl.shim.hbase.table.ResultScannerBuilderImpl;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.table.HBaseTable;
import org.pentaho.hadoop.shim.api.hbase.table.HBaseTableWriteOperationManager;
import org.pentaho.hadoop.shim.api.hbase.table.ResultScannerBuilder;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseValueMeta;
import org.pentaho.hadoop.shim.api.internal.hbase.Mapping;

public class HBaseTableImpl
implements HBaseTable {
    private static final Class<?> PKG = HBaseTableImpl.class;
    private final HBaseConnectionPool hBaseConnectionPool;
    private final HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory;
    private final HBaseBytesUtilShim hBaseBytesUtilShim;
    private final String name;

    public HBaseTableImpl(HBaseConnectionPool hBaseConnectionPool, HBaseValueMetaInterfaceFactoryImpl hBaseValueMetaInterfaceFactory, HBaseBytesUtilShim hBaseBytesUtilShim, String name) {
        this.hBaseConnectionPool = hBaseConnectionPool;
        this.hBaseValueMetaInterfaceFactory = hBaseValueMetaInterfaceFactory;
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
        this.name = name;
    }

    public boolean exists() throws IOException {
        boolean bl;
        block8: {
            HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();
            try {
                bl = hBaseConnectionHandle.getConnection().tableExists(this.name);
                if (hBaseConnectionHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseConnectionHandle != null) {
                        try {
                            hBaseConnectionHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            hBaseConnectionHandle.close();
        }
        return bl;
    }

    public boolean disabled() throws IOException {
        boolean bl;
        block8: {
            HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();
            try {
                bl = hBaseConnectionHandle.getConnection().isTableDisabled(this.name);
                if (hBaseConnectionHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseConnectionHandle != null) {
                        try {
                            hBaseConnectionHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            hBaseConnectionHandle.close();
        }
        return bl;
    }

    public boolean available() throws IOException {
        boolean bl;
        block8: {
            HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();
            try {
                bl = hBaseConnectionHandle.getConnection().isTableAvailable(this.name);
                if (hBaseConnectionHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseConnectionHandle != null) {
                        try {
                            hBaseConnectionHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            hBaseConnectionHandle.close();
        }
        return bl;
    }

    public void disable() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().disableTable(this.name);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void enable() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().enableTable(this.name);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void delete() throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().deleteTable(this.name);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void create(List<String> colFamilyNames, Properties creationProps) throws IOException {
        try (HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();){
            hBaseConnectionHandle.getConnection().createTable(this.name, colFamilyNames, creationProps);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ResultScannerBuilder createScannerBuilder(byte[] keyLowerBound, byte[] keyUpperBound) {
        return new ResultScannerBuilderImpl(this.hBaseConnectionPool, this.hBaseValueMetaInterfaceFactory, this.hBaseBytesUtilShim, this.name, 0, keyLowerBound, keyUpperBound);
    }

    public ResultScannerBuilder createScannerBuilder(Mapping tableMapping, String dateOrNumberConversionMaskForKey, String keyStartS, String keyStopS, String scannerCacheSize, LogChannelInterface log, VariableSpace vars) throws KettleException {
        byte[] keyLowerBound = null;
        byte[] keyUpperBound = null;
        Mapping.KeyType keyType = Mapping.KeyType.valueOf(tableMapping.getKeyType().name());
        if (!Const.isEmpty((String)keyStartS)) {
            Number num;
            DecimalFormat df;
            Date d;
            SimpleDateFormat sdf;
            String[] parts;
            keyStartS = vars.environmentSubstitute(keyStartS);
            String convM = dateOrNumberConversionMaskForKey;
            if (tableMapping.getKeyType() == Mapping.KeyType.BINARY) {
                keyLowerBound = HBaseValueMeta.encodeKeyValue(keyStartS, keyType, this.hBaseBytesUtilShim);
            } else if (tableMapping.getKeyType() != Mapping.KeyType.STRING) {
                parts = keyStartS.split("@");
                if (parts.length == 2) {
                    keyStartS = parts[0];
                    convM = parts[1];
                }
                if (!Const.isEmpty((String)convM) && convM.length() > 0) {
                    if (tableMapping.getKeyType() == Mapping.KeyType.DATE || tableMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE) {
                        sdf = new SimpleDateFormat();
                        sdf.applyPattern(convM);
                        try {
                            d = sdf.parse(keyStartS);
                            keyLowerBound = HBaseValueMeta.encodeKeyValue(d, keyType, this.hBaseBytesUtilShim);
                        }
                        catch (ParseException e) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseLowerBoundKeyValue", (String[])new String[]{keyStartS}), (Throwable)e);
                        }
                    } else {
                        df = new DecimalFormat();
                        df.applyPattern(convM);
                        num = null;
                        try {
                            num = df.parse(keyStartS);
                            keyLowerBound = HBaseValueMeta.encodeKeyValue(num, keyType, this.hBaseBytesUtilShim);
                        }
                        catch (ParseException e) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseLowerBoundKeyValue", (String[])new String[]{keyStartS}), (Throwable)e);
                        }
                    }
                } else {
                    keyLowerBound = HBaseValueMeta.encodeKeyValue(keyStartS, keyType, this.hBaseBytesUtilShim);
                }
            } else {
                keyLowerBound = HBaseValueMeta.encodeKeyValue(keyStartS, keyType, this.hBaseBytesUtilShim);
            }
            if (!Const.isEmpty((String)keyStopS)) {
                keyStopS = vars.environmentSubstitute(keyStopS);
                convM = dateOrNumberConversionMaskForKey;
                if (tableMapping.getKeyType() == Mapping.KeyType.BINARY) {
                    keyUpperBound = HBaseValueMeta.encodeKeyValue(keyStopS, keyType, this.hBaseBytesUtilShim);
                } else if (tableMapping.getKeyType() != Mapping.KeyType.STRING) {
                    parts = keyStopS.split("@");
                    if (parts.length == 2) {
                        keyStopS = parts[0];
                        convM = parts[1];
                    }
                    if (!Const.isEmpty((String)convM) && convM.length() > 0) {
                        if (tableMapping.getKeyType() == Mapping.KeyType.DATE || tableMapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE) {
                            sdf = new SimpleDateFormat();
                            sdf.applyPattern(convM);
                            try {
                                d = sdf.parse(keyStopS);
                                keyUpperBound = HBaseValueMeta.encodeKeyValue(d, keyType, this.hBaseBytesUtilShim);
                            }
                            catch (ParseException e) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseUpperBoundKeyValue", (String[])new String[]{keyStopS}), (Throwable)e);
                            }
                        } else {
                            df = new DecimalFormat();
                            df.applyPattern(convM);
                            num = null;
                            try {
                                num = df.parse(keyStopS);
                                keyUpperBound = HBaseValueMeta.encodeKeyValue(num, keyType, this.hBaseBytesUtilShim);
                            }
                            catch (ParseException e) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseInput.Error.UnableToParseUpperBoundKeyValue", (String[])new String[]{keyStopS}), (Throwable)e);
                            }
                        }
                    } else {
                        keyUpperBound = HBaseValueMeta.encodeKeyValue(keyStopS, keyType, this.hBaseBytesUtilShim);
                    }
                } else {
                    keyUpperBound = HBaseValueMeta.encodeKeyValue(keyStopS, keyType, this.hBaseBytesUtilShim);
                }
            }
        }
        int cacheSize = 0;
        if (!Const.isEmpty((String)scannerCacheSize)) {
            String temp = vars.environmentSubstitute(scannerCacheSize);
            cacheSize = Integer.parseInt(temp);
            if (log != null) {
                log.logBasic(BaseMessages.getString(PKG, (String)"HBaseInput.Message.SettingScannerCaching", (Object[])new Object[]{cacheSize}));
            }
        }
        return new ResultScannerBuilderImpl(this.hBaseConnectionPool, this.hBaseValueMetaInterfaceFactory, this.hBaseBytesUtilShim, this.name, cacheSize, keyLowerBound, keyUpperBound);
    }

    public List<String> getColumnFamilies() throws IOException {
        List<String> list;
        block8: {
            HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle();
            try {
                list = hBaseConnectionHandle.getConnection().getTableFamiles(this.name);
                if (hBaseConnectionHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseConnectionHandle != null) {
                        try {
                            hBaseConnectionHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            hBaseConnectionHandle.close();
        }
        return list;
    }

    public boolean keyExists(byte[] key) throws IOException {
        boolean bl;
        block8: {
            HBaseConnectionHandle hBaseConnectionHandle = this.hBaseConnectionPool.getConnectionHandle(this.name);
            try {
                bl = hBaseConnectionHandle.getConnection().sourceTableRowExists(key);
                if (hBaseConnectionHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hBaseConnectionHandle != null) {
                        try {
                            hBaseConnectionHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            hBaseConnectionHandle.close();
        }
        return bl;
    }

    public HBaseTableWriteOperationManager createWriteOperationManager(Long writeBufferSize) throws IOException {
        Properties targetTableProps = new Properties();
        if (writeBufferSize != null) {
            targetTableProps.setProperty("htable.writeBufferSize", writeBufferSize.toString());
        }
        return new HBaseTableWriteOperationManagerImpl(this.hBaseConnectionPool.getConnectionHandle(this.name, targetTableProps), writeBufferSize != null);
    }

    public void close() throws IOException {
    }
}

