/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.browse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.pentaho.big.data.impl.browse.model.NamedClusterDirectory;
import org.pentaho.big.data.impl.browse.model.NamedClusterFile;
import org.pentaho.big.data.impl.browse.model.NamedClusterTree;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseFileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.Tree;
import org.pentaho.di.plugins.fileopensave.api.providers.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileNotFoundException;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class NamedClusterProvider
extends BaseFileProvider<NamedClusterFile> {
    public static final String NAME = "Hadoop Clusters";
    public static final String TYPE = "clusters";
    public static final String SCHEME = "hc";
    private NamedClusterService namedClusterManager;
    private MetastoreLocator metastoreLocator;

    public NamedClusterProvider(NamedClusterService namedClusterManager, MetastoreLocator metastoreLocator) {
        this.namedClusterManager = namedClusterManager;
        this.metastoreLocator = metastoreLocator;
    }

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    public Class<NamedClusterFile> getFileClass() {
        return NamedClusterFile.class;
    }

    public boolean isAvailable() {
        return true;
    }

    public Tree getTree() {
        NamedClusterTree namedClusterTree = new NamedClusterTree(NAME);
        try {
            List names = this.namedClusterManager.listNames(this.metastoreLocator.getMetastore());
            names.forEach(name -> {
                NamedClusterDirectory namedClusterDirectory = new NamedClusterDirectory();
                namedClusterDirectory.setName((String)name);
                namedClusterDirectory.setPath("hc://" + name);
                namedClusterDirectory.setRoot(NAME);
                namedClusterDirectory.setHasChildren(true);
                namedClusterDirectory.setCanDelete(false);
                namedClusterTree.addChild(namedClusterDirectory);
            });
        }
        catch (MetaStoreException metaStoreException) {
            // empty catch block
        }
        return namedClusterTree;
    }

    public List<NamedClusterFile> getFiles(NamedClusterFile file, String filters) throws FileException {
        FileObject fileObject;
        try {
            fileObject = KettleVFS.getFileObject((String)file.getPath());
            if (!fileObject.exists()) {
                throw new FileNotFoundException(file.getPath(), TYPE);
            }
        }
        catch (FileSystemException | KettleFileException e) {
            throw new FileNotFoundException(file.getPath(), TYPE);
        }
        return this.populateChildren(file, fileObject, filters);
    }

    private boolean hasChildren(FileObject fileObject) {
        try {
            return fileObject != null && fileObject.getType().hasChildren();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    private FileObject[] getChildren(FileObject fileObject) {
        try {
            return fileObject != null ? fileObject.getChildren() : new FileObject[]{};
        }
        catch (FileSystemException e) {
            return new FileObject[0];
        }
    }

    private List<NamedClusterFile> populateChildren(NamedClusterFile parent, FileObject fileObject, String filters) {
        ArrayList<NamedClusterFile> files = new ArrayList<NamedClusterFile>();
        if (fileObject != null && this.hasChildren(fileObject)) {
            FileObject[] children;
            for (FileObject child : children = this.getChildren(fileObject)) {
                if (this.hasChildren(child)) {
                    files.add(NamedClusterDirectory.create(parent.getPath(), child));
                    continue;
                }
                if (child == null || !Utils.matches((String)child.getName().getBaseName(), (String)filters)) continue;
                files.add(NamedClusterFile.create(parent.getPath(), child));
            }
        }
        return files;
    }

    public List<NamedClusterFile> delete(List<NamedClusterFile> files) throws FileException {
        ArrayList<NamedClusterFile> deletedFiles = new ArrayList<NamedClusterFile>();
        for (NamedClusterFile file : files) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)file.getPath());
                if (!fileObject.delete()) continue;
                deletedFiles.add(file);
            }
            catch (FileSystemException | KettleFileException throwable) {}
        }
        return deletedFiles;
    }

    public NamedClusterFile add(NamedClusterFile folder) throws FileException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)folder.getPath());
            fileObject.createFolder();
            String parent = folder.getPath().substring(0, folder.getPath().length() - 1);
            return NamedClusterFile.create(parent, fileObject);
        }
        catch (FileSystemException | KettleFileException throwable) {
            return null;
        }
    }

    public NamedClusterFile getFile(NamedClusterFile file) {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath());
            if (fileObject.getType().equals((Object)FileType.FOLDER)) {
                return NamedClusterDirectory.create(null, fileObject);
            }
            return NamedClusterFile.create(null, fileObject);
        }
        catch (FileSystemException | KettleFileException throwable) {
            return null;
        }
    }

    public boolean fileExists(NamedClusterFile dir, String path) throws FileException {
        path = this.sanitizeName(dir, path);
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)path);
            return fileObject.exists();
        }
        catch (FileSystemException | KettleFileException e) {
            throw new FileException();
        }
    }

    public String getNewName(NamedClusterFile destDir, String newPath) throws FileException {
        String extension = Utils.getExtension((String)newPath);
        String parent = Utils.getParent((String)newPath);
        String name = Utils.getName((String)newPath).replace("." + extension, "");
        int i = 1;
        String testName = this.sanitizeName(destDir, newPath);
        try {
            while (KettleVFS.getFileObject((String)testName).exists()) {
                testName = Utils.isValidExtension((String)extension) ? this.sanitizeName(destDir, parent + name + " " + i + "." + extension) : this.sanitizeName(destDir, newPath + " " + i);
                ++i;
            }
        }
        catch (FileSystemException | KettleFileException e) {
            return testName;
        }
        return testName;
    }

    public boolean isSame(File file1, File file2) {
        return file1 instanceof NamedClusterFile && file2 instanceof NamedClusterFile;
    }

    public NamedClusterFile rename(NamedClusterFile file, String newPath, boolean overwrite) throws FileException {
        return this.doMove(file, newPath, overwrite);
    }

    public NamedClusterFile copy(NamedClusterFile file, String toPath, boolean b) throws FileException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath());
            FileObject copyObject = KettleVFS.getFileObject((String)toPath);
            copyObject.copyFrom(fileObject, Selectors.SELECT_SELF);
            if (file instanceof NamedClusterDirectory) {
                return NamedClusterDirectory.create(copyObject.getParent().getPublicURIString(), fileObject);
            }
            return NamedClusterFile.create(copyObject.getParent().getPublicURIString(), fileObject);
        }
        catch (FileSystemException | KettleFileException e) {
            throw new FileException();
        }
    }

    public NamedClusterFile move(NamedClusterFile namedClusterFile, String s, boolean b) throws FileException {
        return null;
    }

    private NamedClusterFile doMove(NamedClusterFile file, String newPath, boolean overwrite) {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath());
            FileObject renameObject = KettleVFS.getFileObject((String)newPath);
            if (overwrite && renameObject.exists()) {
                renameObject.delete();
            }
            fileObject.moveTo(renameObject);
            if (file instanceof NamedClusterDirectory) {
                return NamedClusterDirectory.create(renameObject.getParent().getPublicURIString(), renameObject);
            }
            return NamedClusterFile.create(renameObject.getParent().getPublicURIString(), renameObject);
        }
        catch (FileSystemException | KettleFileException e) {
            return null;
        }
    }

    public InputStream readFile(NamedClusterFile file) throws FileException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)file.getPath());
            return fileObject.getContent().getInputStream();
        }
        catch (FileSystemException | KettleFileException e) {
            return null;
        }
    }

    public NamedClusterFile writeFile(InputStream inputStream, NamedClusterFile destDir, String path, boolean overwrite) throws FileException {
        FileObject fileObject = null;
        try {
            fileObject = KettleVFS.getFileObject((String)path);
        }
        catch (KettleFileException ke) {
            throw new FileException();
        }
        if (fileObject != null) {
            NamedClusterFile namedClusterFile;
            block11: {
                OutputStream outputStream = fileObject.getContent().getOutputStream();
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    outputStream.flush();
                    namedClusterFile = NamedClusterFile.create(destDir.getPath(), fileObject);
                    if (outputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                outputStream.close();
            }
            return namedClusterFile;
        }
        return null;
    }

    public NamedClusterFile getParent(NamedClusterFile file) {
        NamedClusterFile vfsFile = new NamedClusterFile();
        vfsFile.setPath(file.getParent());
        return vfsFile;
    }

    public void clearProviderCache() {
    }
}

