/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.sqoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.pentaho.big.data.kettle.plugins.job.AbstractJobEntry;
import org.pentaho.big.data.kettle.plugins.job.JobEntryMode;
import org.pentaho.big.data.kettle.plugins.job.JobEntryUtils;
import org.pentaho.big.data.kettle.plugins.job.PropertyEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.LoggingProxy;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopConfig;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopLog4jFilter;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopUtils;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.log4j.KettleLogChannelAppender;
import org.pentaho.di.core.logging.log4j.Log4jKettleLayout;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.HadoopClientServices;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.core.ShimIdentifierInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.platform.api.util.LogUtil;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

public abstract class AbstractSqoopJobEntry<S extends SqoopConfig>
extends AbstractJobEntry<S>
implements Cloneable,
JobEntryInterface {
    private final String NamedClusterNameProperty = "pentahoNamedCluster";
    private final NamedClusterService namedClusterService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private DatabaseMeta usedDbConnection;
    private Appender sqoopToKettleAppender;
    private LoggingProxy stdErrProxy;
    private String[] LOGS_TO_MONITOR = new String[]{"org.apache.sqoop", "org.apache.hadoop", "com.pentaho.big.data.bundles.impl.shim.sqoop.knox"};
    private final Map<String, Level> logLevelCache;

    protected abstract String getToolName();

    protected AbstractSqoopJobEntry(NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.logLevelCache = Maps.newHashMap();
    }

    public void loadXML(Node node, List<DatabaseMeta> databaseMetas, List<SlaveServer> slaveServers, Repository repository) throws KettleXMLException {
        super.loadXML(node, databaseMetas, slaveServers, repository);
        this.loadUsedDataBaseConnection(databaseMetas, (SqoopConfig)this.getJobConfig());
        if (!this.loadNamedCluster(this.metaStore)) {
            ((SqoopConfig)this.getJobConfig()).loadClusterConfig(node);
        }
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        super.loadRep(rep, id_jobentry, databases, slaveServers);
        this.loadUsedDataBaseConnection(databases, (SqoopConfig)this.getJobConfig());
        if (!this.loadNamedCluster(this.metaStore)) {
            try {
                ((SqoopConfig)this.getJobConfig()).loadClusterConfig(rep, id_jobentry);
            }
            catch (KettleException ke) {
                this.logError(ke.getMessage(), ke);
            }
        }
    }

    public String getXML() {
        return super.getXML() + ((SqoopConfig)this.getJobConfig()).getClusterXML();
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        super.saveRep(rep, id_job);
        ((SqoopConfig)this.getJobConfig()).saveClusterConfig(rep, id_job, this);
    }

    private boolean loadNamedCluster(IMetaStore metaStore) {
        try {
            String clusterName = this.getParentJobMeta() == null ? ((SqoopConfig)this.getJobConfig()).getClusterName() : this.getParentJob().getJobMeta().environmentSubstitute(((SqoopConfig)this.getJobConfig()).getClusterName());
            return this.loadNamedCluster(clusterName);
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
            return false;
        }
    }

    private boolean loadNamedCluster(String clusterName) {
        try {
            NamedCluster namedCluster = null;
            if (!Strings.isNullOrEmpty((String)clusterName) && this.namedClusterService.contains(clusterName, this.metaStore)) {
                namedCluster = this.namedClusterService.read(clusterName, this.metaStore);
            }
            if (namedCluster != null) {
                ((SqoopConfig)this.getJobConfig()).setNamedCluster(namedCluster);
                return true;
            }
        }
        catch (Throwable t) {
            this.logDebug(t.getMessage(), new Object[]{t});
        }
        return false;
    }

    @VisibleForTesting
    void loadUsedDataBaseConnection(List<DatabaseMeta> databases, S config) {
        String database = ((SqoopConfig)config).getDatabase();
        DatabaseMeta databaseMeta = DatabaseMeta.findDatabase(databases, (String)database);
        this.setUsedDbConnection(databaseMeta);
        if (database == null) {
            ((SqoopConfig)config).copyConnectionInfoToAdvanced();
        }
    }

    public void attachLoggingAppenders() {
        this.sqoopToKettleAppender = new KettleLogChannelAppender(this.log, new Log4jKettleLayout(StandardCharsets.UTF_8, true));
        SqoopLog4jFilter filter = new SqoopLog4jFilter(this.log.getLogChannelId());
        ThreadContext.put((String)"logChannelId", (String)this.log.getLogChannelId());
        Logger sqoopLogger = LogManager.getLogger((String)this.LOGS_TO_MONITOR[0]);
        if (sqoopLogger != null) {
            this.stdErrProxy = new LoggingProxy(System.err, sqoopLogger, Level.INFO);
            System.setErr(this.stdErrProxy);
        }
        LogUtil.addAppender((Appender)this.sqoopToKettleAppender, (Logger)sqoopLogger, (Level)Level.INFO, (Filter)filter);
    }

    public void removeLoggingAppenders() {
        try {
            if (this.sqoopToKettleAppender != null) {
                Logger sqoopLogger = LogManager.getLogger((String)this.LOGS_TO_MONITOR[0]);
                LogUtil.removeAppender((Appender)this.sqoopToKettleAppender, (Logger)sqoopLogger);
                this.sqoopToKettleAppender = null;
            }
            if (this.stdErrProxy != null) {
                System.setErr(this.stdErrProxy.getWrappedStream());
                this.stdErrProxy = null;
            }
        }
        catch (Exception ex) {
            this.logError(AbstractSqoopJobEntry.getString("ErrorDetachingLogging", new String[0]));
            this.logDebug(Throwables.getStackTraceAsString((Throwable)ex));
        }
    }

    public List<String> getValidationWarnings(SqoopConfig config) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (StringUtil.isEmpty((String)config.getConnect())) {
            warnings.add(AbstractSqoopJobEntry.getString("ValidationError.Connect.Message", config.getConnect()));
        }
        try {
            JobEntryUtils.asLong((String)config.getBlockingPollingInterval(), (VariableSpace)this.variables);
        }
        catch (NumberFormatException ex) {
            warnings.add(AbstractSqoopJobEntry.getString("ValidationError.BlockingPollingInterval.Message", config.getBlockingPollingInterval()));
        }
        return warnings;
    }

    protected void handleUncaughtThreadException(Thread t, Throwable e, Result jobResult) {
        this.logError(AbstractSqoopJobEntry.getString("ErrorRunningSqoopTool", new String[0]), e);
        this.removeLoggingAppenders();
        this.setJobResultFailed(jobResult);
    }

    protected Runnable getExecutionRunnable(final Result jobResult) throws KettleException {
        return new Runnable(){

            @Override
            public void run() {
                AbstractSqoopJobEntry.this.executeSqoop(jobResult);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSqoop(Result jobResult) {
        SqoopConfig config = (SqoopConfig)this.getJobConfig();
        Properties properties = new Properties();
        this.attachLoggingAppenders();
        try {
            PropertyEntry entry;
            List shimIdentifers;
            this.configure(config, properties);
            List<String> args = SqoopUtils.getCommandLineArgs(config, this.getVariables());
            args.add(0, this.getToolName());
            String configuredShimIdentifier = config.getNamedCluster().getShimIdentifier();
            if (!StringUtil.isEmpty((String)configuredShimIdentifier) && (shimIdentifers = PentahoSystem.getAll(ShimIdentifierInterface.class)).stream().noneMatch(identifier -> identifier.getId().equals(configuredShimIdentifier))) {
                String installedShimIdentifiers = shimIdentifers.stream().map(ShimIdentifierInterface::getId).collect(Collectors.joining(",", "{", "}"));
                throw new KettleException("Invalid driver version value: " + config.getNamedCluster().getShimIdentifier() + " Available valid values: " + installedShimIdentifiers);
            }
            if (!this.loadNamedCluster(this.getMetaStore()) && (entry = (PropertyEntry)config.getCustomArguments().stream().filter(p -> p.getKey() != null && p.getKey().equals("pentahoNamedCluster")).findAny().orElse(null)) != null) {
                this.loadNamedCluster(entry.getValue());
            }
            NamedCluster tempCluster = null;
            if (StringUtil.isEmpty((String)config.getNamedCluster().getName())) {
                tempCluster = this.namedClusterService.getNamedClusterByHost(config.getNamedCluster().getHdfsHost(), this.getMetaStore());
                if (tempCluster != null) {
                    config.setNamedCluster(tempCluster);
                } else {
                    throw new KettleException("An Hadoop Cluster matching Namenode Host could not be found");
                }
            }
            if (!StringUtil.isEmpty((String)configuredShimIdentifier)) {
                config.getNamedCluster().setShimIdentifier(configuredShimIdentifier);
            }
            NamedCluster namedCluster = config.getNamedCluster().clone();
            namedCluster.copyVariablesFrom((VariableSpace)this);
            HadoopClientServices hadoopClientServices = (HadoopClientServices)this.namedClusterServiceLocator.getService(namedCluster, HadoopClientServices.class);
            int result = hadoopClientServices.runSqoop(args, properties);
            if (result != 0) {
                this.setJobResultFailed(jobResult);
            }
        }
        catch (Exception ex) {
            this.logError(AbstractSqoopJobEntry.getString("ErrorRunningSqoopTool", new String[0]), ex);
            this.setJobResultFailed(jobResult);
        }
        finally {
            this.removeLoggingAppenders();
        }
    }

    public void configure(S sqoopConfig, Properties properties) throws KettleException {
        this.configureDatabase(sqoopConfig);
    }

    public void configureDatabase(S sqoopConfig) throws KettleException {
        DatabaseMeta databaseMeta = this.getParentJob().getJobMeta().findDatabase(((SqoopConfig)sqoopConfig).getDatabase());
        if (((SqoopConfig)sqoopConfig).getModeAsEnum() == JobEntryMode.QUICK_SETUP && databaseMeta != null) {
            ((SqoopConfig)sqoopConfig).setConnectionInfo(databaseMeta.environmentSubstitute(databaseMeta.getName()), databaseMeta.environmentSubstitute(databaseMeta.getURL()), databaseMeta.environmentSubstitute(databaseMeta.getUsername()), Encr.decryptPasswordOptionallyEncrypted((String)databaseMeta.environmentSubstitute(databaseMeta.getPassword())));
        }
    }

    public boolean isDatabaseSupported(Class<? extends DatabaseInterface> databaseType) {
        return true;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.usedDbConnection};
    }

    public DatabaseMeta getUsedDbConnection() {
        return this.usedDbConnection;
    }

    public void setUsedDbConnection(DatabaseMeta usedDbConnection) {
        this.usedDbConnection = usedDbConnection;
    }

    @VisibleForTesting
    protected void setLogChannel(LogChannelInterface logChannel) {
        this.log = logChannel;
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    private static String getString(String key, String ... parameters) {
        return BaseMessages.getString(AbstractSqoopJobEntry.class, (String)key, (String[])parameters);
    }
}

