/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class SchedulerService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.SchedulerService.";
    public static final String SCHEDULER_THREADS = "oozie.service.SchedulerService.threads";
    private final XLog log = XLog.getLog(this.getClass());
    private ScheduledExecutorService scheduler;

    @Override
    public void init(Services services) {
        this.scheduler = new ScheduledThreadPoolExecutor(services.getConf().getInt(SCHEDULER_THREADS, 5));
    }

    @Override
    public void destroy() {
        try {
            long limit = System.currentTimeMillis() + 30000L;
            this.scheduler.shutdownNow();
            while (!this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.log.info("Waiting for scheduler to shutdown");
                if (System.currentTimeMillis() <= limit) continue;
                this.log.warn("Gave up, continuing without waiting for scheduler to shutdown");
                break;
            }
        }
        catch (InterruptedException ex) {
            this.log.warn(ex);
        }
    }

    @Override
    public Class<? extends Service> getInterface() {
        return SchedulerService.class;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void schedule(final Callable<Void> callable, long delay, long interval, Unit unit) {
        this.log.trace("Scheduling callable [{0}], interval [{1}] seconds, delay [{2}] in [{3}]", new Object[]{callable.getClass(), delay, interval, unit});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (Services.get().getSystemMode() == OozieClient.SYSTEM_MODE.SAFEMODE) {
                    SchedulerService.this.log.trace("schedule[run/callable] System is in SAFEMODE. Therefore nothing will run");
                    return;
                }
                try {
                    callable.call();
                }
                catch (Exception ex) {
                    SchedulerService.this.log.warn("Error executing callable [{0}], {1}", callable.getClass().getSimpleName(), ex.getMessage(), ex);
                }
            }
        };
        if (!this.scheduler.isShutdown()) {
            this.scheduler.scheduleWithFixedDelay(r, delay * unit.getMillis(), interval * unit.getMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.log.warn("Scheduler shutting down, ignoring scheduling of [{0}]", callable.getClass());
        }
    }

    public void schedule(final Runnable runnable, long delay, long interval, Unit unit) {
        this.log.trace("Scheduling runnable [{0}], interval [{1}], delay [{2}] in [{3}]", new Object[]{runnable.getClass(), delay, interval, unit});
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (Services.get().getSystemMode() == OozieClient.SYSTEM_MODE.SAFEMODE) {
                    SchedulerService.this.log.trace("schedule[run/Runnable] System is in SAFEMODE. Therefore nothing will run");
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    SchedulerService.this.log.warn("Error executing runnable [{0}], {1}", runnable.getClass().getSimpleName(), ex.getMessage(), ex);
                }
            }
        };
        if (!this.scheduler.isShutdown()) {
            this.scheduler.scheduleWithFixedDelay(r, delay * unit.getMillis(), interval * unit.getMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.log.warn("Scheduler shutting down, ignoring scheduling of [{0}]", runnable.getClass());
        }
    }

    public static enum Unit {
        MILLISEC(1L),
        SEC(1000L),
        MIN(60000L),
        HOUR(3600000L);

        private long millis;

        private Unit(long millis) {
            this.millis = millis;
        }

        private long getMillis() {
            return this.millis;
        }
    }
}

