/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.SyncCoordDataset;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class CoordELFunctions {
    private static final String DATASET = "oozie.coord.el.dataset.bean";
    private static final String COORD_ACTION = "oozie.coord.el.app.bean";
    public static final String CONFIGURATION = "oozie.coord.el.conf";
    public static final String INSTANCE_SEPARATOR = "#";
    public static final String DIR_SEPARATOR = ",";
    private static String END_OF_OPERATION_INDICATOR_FILE = "_SUCCESS";

    public static int ph1_coord_days(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.DAY);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val;
    }

    public static int ph1_coord_months(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MONTH);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val;
    }

    public static int ph1_coord_hours(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MINUTE);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val * 60;
    }

    public static int ph1_coord_minutes(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MINUTE);
        eval.setVariable("endOfDuration", (Object)TimeUnit.NONE);
        return val;
    }

    public static int ph1_coord_endOfDays(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.DAY);
        eval.setVariable("endOfDuration", (Object)TimeUnit.END_OF_DAY);
        return val;
    }

    public static int ph1_coord_endOfMonths(int val) {
        val = ParamChecker.checkGTZero(val, "n");
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable("timeunit", (Object)TimeUnit.MONTH);
        eval.setVariable("endOfDuration", (Object)TimeUnit.END_OF_MONTH);
        return val;
    }

    public static int ph2_coord_tzOffset() {
        Date actionCreationTime = CoordELFunctions.getActionCreationtime();
        TimeZone dsTZ = ParamChecker.notNull(CoordELFunctions.getDatasetTZ(), "DatasetTZ");
        TimeZone jobTZ = ParamChecker.notNull(CoordELFunctions.getJobTZ(), "JobTZ");
        Calendar dsTime = Calendar.getInstance(dsTZ);
        dsTime.setTime(actionCreationTime);
        Calendar jobTime = Calendar.getInstance(jobTZ);
        jobTime.setTime(actionCreationTime);
        return (dsTime.get(15) - jobTime.get(15)) / 60000;
    }

    public static int ph3_coord_tzOffset() {
        return CoordELFunctions.ph2_coord_tzOffset();
    }

    public static String ph2_coord_dateOffset(String strBaseDate, int offset, String unit) throws Exception {
        Calendar baseCalDate = DateUtils.getCalendar(strBaseDate);
        StringBuilder buffer = new StringBuilder();
        baseCalDate.add(TimeUnit.valueOf(unit).getCalendarUnit(), offset);
        buffer.append(DateUtils.formatDateUTC(baseCalDate));
        return buffer.toString();
    }

    public static String ph3_coord_dateOffset(String strBaseDate, int offset, String unit) throws Exception {
        return CoordELFunctions.ph2_coord_dateOffset(strBaseDate, offset, unit);
    }

    public static String ph3_coord_future(int n, int instance) throws Exception {
        ParamChecker.checkGEZero(n, "future:n");
        ParamChecker.checkGTZero(instance, "future:instance");
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_future_sync(n, instance);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    private static String coord_future_sync(int n, int instance) throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String retVal = "";
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit();
        int[] instCount = new int[1];
        Calendar nominalInstanceCal = CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(), instCount);
        if (nominalInstanceCal != null) {
            Calendar initInstance = CoordELFunctions.getInitialInstanceCal();
            nominalInstanceCal = (Calendar)initInstance.clone();
            nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), instCount[0] * datasetFrequency);
            SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
            if (ds == null) {
                throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
            }
            String uriTemplate = ds.getUriTemplate();
            Configuration conf = (Configuration)eval.getVariable(CONFIGURATION);
            if (conf == null) {
                throw new RuntimeException("Associated Configuration should be defined with key oozie.coord.el.conf");
            }
            int available = 0;
            boolean resolved = false;
            String user = ParamChecker.notEmpty((String)eval.getVariable("user.name"), "user.name");
            String group = ParamChecker.notEmpty((String)eval.getVariable("group.name"), "group.name");
            String doneFlag = ds.getDoneFlag();
            for (int checkedInstance = 0; instance >= checkedInstance; ++checkedInstance) {
                String uriPath;
                ELEvaluator uriEval = CoordELFunctions.getUriEvaluator(nominalInstanceCal);
                String pathWithDoneFlag = uriPath = uriEval.evaluate(uriTemplate, String.class);
                if (doneFlag.length() > 0) {
                    pathWithDoneFlag = pathWithDoneFlag + "/" + doneFlag;
                }
                if (CoordELFunctions.isPathAvailable(pathWithDoneFlag, user, group, conf)) {
                    XLog.getLog(CoordELFunctions.class).debug("Found future(" + available + "): " + pathWithDoneFlag);
                    if (available == n) {
                        XLog.getLog(CoordELFunctions.class).debug("Found future File: " + pathWithDoneFlag);
                        resolved = true;
                        retVal = DateUtils.formatDateUTC(nominalInstanceCal);
                        eval.setVariable("resolved_path", uriPath);
                        break;
                    }
                    ++available;
                }
                nominalInstanceCal = (Calendar)initInstance.clone();
                instCount[0] = instCount[0] + 1;
                nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), instCount[0] * datasetFrequency);
            }
            if (!resolved) {
                eval.setVariable("is_resolved", Boolean.FALSE);
                retVal = "${coord:future(" + n + ", " + instance + ")}";
            } else {
                eval.setVariable("is_resolved", Boolean.TRUE);
            }
        } else {
            eval.setVariable("is_resolved", Boolean.TRUE);
            retVal = "";
        }
        return retVal;
    }

    public static String ph2_coord_nominalTime() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction action = ParamChecker.notNull((SyncCoordAction)eval.getVariable(COORD_ACTION), "Coordinator Action");
        return DateUtils.formatDateUTC(action.getNominalTime());
    }

    public static String ph3_coord_nominalTime() throws Exception {
        return CoordELFunctions.ph2_coord_nominalTime();
    }

    public static String ph2_coord_formatTime(String dateTimeStr, String format) throws Exception {
        Date dateTime = DateUtils.parseDateUTC(dateTimeStr);
        return DateUtils.formatDateCustom(dateTime, format);
    }

    public static String ph3_coord_formatTime(String dateTimeStr, String format) throws Exception {
        return CoordELFunctions.ph2_coord_formatTime(dateTimeStr, format);
    }

    public static String ph2_coord_actionId() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction action = ParamChecker.notNull((SyncCoordAction)eval.getVariable(COORD_ACTION), "Coordinator Action");
        return action.getActionId();
    }

    public static String ph3_coord_actionId() throws Exception {
        return CoordELFunctions.ph2_coord_actionId();
    }

    public static String ph2_coord_name() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction action = ParamChecker.notNull((SyncCoordAction)eval.getVariable(COORD_ACTION), "Coordinator Action");
        return action.getName();
    }

    public static String ph3_coord_name() throws Exception {
        return CoordELFunctions.ph2_coord_name();
    }

    public static String ph2_coord_actualTime() throws Exception {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return DateUtils.formatDateUTC(coordAction.getActualTime());
    }

    public static String ph3_coord_actualTime() throws Exception {
        return CoordELFunctions.ph2_coord_actualTime();
    }

    public static String ph3_coord_dataIn(String dataInName) {
        String uris = "";
        ELEvaluator eval = ELEvaluator.getCurrent();
        uris = (String)eval.getVariable(".datain." + dataInName);
        Boolean unresolved = (Boolean)eval.getVariable(".datain." + dataInName + ".unresolved");
        if (unresolved != null && unresolved.booleanValue()) {
            return "${coord:dataIn('" + dataInName + "')}";
        }
        return uris;
    }

    public static String ph3_coord_dataOut(String dataOutName) {
        String uris = "";
        ELEvaluator eval = ELEvaluator.getCurrent();
        uris = (String)eval.getVariable(".dataout." + dataOutName);
        return uris;
    }

    public static String ph2_coord_current(int n) throws Exception {
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_current_sync(n);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static int ph2_coord_hoursInDay(int n) throws Exception {
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        Calendar nominalInstanceCal = CoordELFunctions.getEffectiveNominalTime();
        if (nominalInstanceCal == null) {
            return -1;
        }
        nominalInstanceCal.add(CoordELFunctions.getDSTimeUnit().getCalendarUnit(), datasetFrequency * n);
        nominalInstanceCal.setTimeZone(CoordELFunctions.getDatasetTZ());
        return DateUtils.hoursInDay(nominalInstanceCal);
    }

    public static int ph3_coord_hoursInDay(int n) throws Exception {
        return CoordELFunctions.ph2_coord_hoursInDay(n);
    }

    public static int ph2_coord_daysInMonth(int n) throws Exception {
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        Calendar nominalInstanceCal = CoordELFunctions.getEffectiveNominalTime();
        if (nominalInstanceCal == null) {
            return -1;
        }
        nominalInstanceCal.add(CoordELFunctions.getDSTimeUnit().getCalendarUnit(), datasetFrequency * n);
        nominalInstanceCal.setTimeZone(CoordELFunctions.getDatasetTZ());
        return nominalInstanceCal.getActualMaximum(5);
    }

    public static int ph3_coord_daysInMonth(int n) throws Exception {
        return CoordELFunctions.ph2_coord_daysInMonth(n);
    }

    public static String ph3_coord_latest(int n) throws Exception {
        if (n > 0) {
            throw new IllegalArgumentException("paramter should be <= 0 but it is " + n);
        }
        if (CoordELFunctions.isSyncDataSet()) {
            return CoordELFunctions.coord_latest_sync(n);
        }
        throw new UnsupportedOperationException("Asynchronous Dataset is not supported yet");
    }

    public static void configureEvaluator(ELEvaluator evaluator, SyncCoordDataset ds, SyncCoordAction coordAction) {
        evaluator.setVariable(COORD_ACTION, coordAction);
        evaluator.setVariable(DATASET, ds);
    }

    public static String evalAndWrap(ELEvaluator eval, String expr) throws Exception {
        try {
            eval.setVariable(".wrap", null);
            String result = eval.evaluate(expr, String.class);
            if (eval.getVariable(".wrap") != null) {
                return "${" + result + "}";
            }
            return result;
        }
        catch (Exception e) {
            throw new Exception("Unable to evaluate :" + expr + ":\n", e);
        }
    }

    public static String ph1_coord_current_echo(String n) {
        return CoordELFunctions.echoUnResolved("current", n);
    }

    public static String ph2_coord_current_echo(String n) {
        return CoordELFunctions.echoUnResolved("current", n);
    }

    public static String ph1_coord_dateOffset_echo(String n, String offset, String unit) {
        return CoordELFunctions.echoUnResolved("dateOffset", n + " , " + offset + " , " + unit);
    }

    public static String ph1_coord_formatTime_echo(String dateTime, String format) {
        return CoordELFunctions.echoUnResolved("formatTime", "'" + dateTime + "'" + " , " + format);
    }

    public static String ph1_coord_latest_echo(String n) {
        return CoordELFunctions.echoUnResolved("latest", n);
    }

    public static String ph2_coord_latest_echo(String n) {
        return CoordELFunctions.ph1_coord_latest_echo(n);
    }

    public static String ph1_coord_future_echo(String n, String instance) {
        return CoordELFunctions.echoUnResolved("future", n + ", " + instance + "");
    }

    public static String ph2_coord_future_echo(String n, String instance) {
        return CoordELFunctions.ph1_coord_future_echo(n, instance);
    }

    public static String ph1_coord_dataIn_echo(String n) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String val = (String)eval.getVariable("oozie.dataname." + n);
        if (val == null || !val.equals("data-in")) {
            XLog.getLog(CoordELFunctions.class).error("data_in_name " + n + " is not valid");
            throw new RuntimeException("data_in_name " + n + " is not valid");
        }
        return CoordELFunctions.echoUnResolved("dataIn", "'" + n + "'");
    }

    public static String ph1_coord_dataOut_echo(String n) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String val = (String)eval.getVariable("oozie.dataname." + n);
        if (val == null || !val.equals("data-out")) {
            XLog.getLog(CoordELFunctions.class).error("data_out_name " + n + " is not valid");
            throw new RuntimeException("data_out_name " + n + " is not valid");
        }
        return CoordELFunctions.echoUnResolved("dataOut", "'" + n + "'");
    }

    public static String ph1_coord_nominalTime_echo() {
        return CoordELFunctions.echoUnResolved("nominalTime", "");
    }

    public static String ph1_coord_nominalTime_echo_wrap() {
        return CoordELFunctions.echoUnResolved("nominalTime", "");
    }

    public static String ph1_coord_nominalTime_echo_fixed() {
        return "2009-03-06T010:00";
    }

    public static String ph1_coord_actualTime_echo_wrap() {
        return CoordELFunctions.echoUnResolved("actualTime", "");
    }

    public static String ph1_coord_actionId_echo() {
        return CoordELFunctions.echoUnResolved("actionId", "");
    }

    public static String ph1_coord_name_echo() {
        return CoordELFunctions.echoUnResolved("name", "");
    }

    public static String coord_minutes_echo(String n) {
        return CoordELFunctions.echoUnResolved("minutes", n);
    }

    public static String coord_hours_echo(String n) {
        return CoordELFunctions.echoUnResolved("hours", n);
    }

    public static String coord_days_echo(String n) {
        return CoordELFunctions.echoUnResolved("days", n);
    }

    public static String coord_endOfDay_echo(String n) {
        return CoordELFunctions.echoUnResolved("endOfDay", n);
    }

    public static String coord_months_echo(String n) {
        return CoordELFunctions.echoUnResolved("months", n);
    }

    public static String coord_endOfMonth_echo(String n) {
        return CoordELFunctions.echoUnResolved("endOfMonth", n);
    }

    public static String coord_actualTime_echo() {
        return CoordELFunctions.echoUnResolved("actualTime", "");
    }

    public static String ph1_coord_hoursInDay_echo(String n) {
        return "24";
    }

    public static String ph1_coord_daysInMonth_echo(String n) {
        return "30";
    }

    public static String ph1_coord_tzOffset_echo() {
        return "3";
    }

    private static String coord_current_sync(int n) throws Exception {
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit();
        int[] instCount = new int[1];
        Calendar nominalInstanceCal = CoordELFunctions.getCurrentInstance(CoordELFunctions.getActionCreationtime(), instCount);
        if (nominalInstanceCal == null) {
            XLog.getLog(CoordELFunctions.class).warn("If the initial instance of the dataset is later than the nominal time, an empty string is returned. This means that no data is available at the current-instance specified by the user and the user could try modifying his initial-instance to an earlier time.");
            return "";
        }
        nominalInstanceCal = CoordELFunctions.getInitialInstanceCal();
        int absInstanceCount = instCount[0] + n;
        nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), datasetFrequency * absInstanceCount);
        if (nominalInstanceCal.getTime().compareTo(CoordELFunctions.getInitialInstance()) < 0) {
            XLog.getLog(CoordELFunctions.class).warn("If the initial instance of the dataset is later than the current-instance specified, such as coord:current({0}) in this case, an empty string is returned. This means that no data is available at the current-instance specified by the user and the user could try modifying his initial-instance to an earlier time.", n);
            return "";
        }
        String str = DateUtils.formatDateUTC(nominalInstanceCal);
        return str;
    }

    private static String coord_latest_sync(int offset) throws Exception {
        if (offset > 0) {
            throw new RuntimeException("For latest there is no meaning of positive instance. n should be <=0" + offset);
        }
        ELEvaluator eval = ELEvaluator.getCurrent();
        String retVal = "";
        int datasetFrequency = CoordELFunctions.getDSFrequency();
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit();
        int[] instCount = new int[1];
        Calendar nominalInstanceCal = CoordELFunctions.getCurrentInstance(CoordELFunctions.getActualTime(), instCount);
        if (nominalInstanceCal != null) {
            Calendar initInstance = CoordELFunctions.getInitialInstanceCal();
            SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
            if (ds == null) {
                throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
            }
            String uriTemplate = ds.getUriTemplate();
            Configuration conf = (Configuration)eval.getVariable(CONFIGURATION);
            if (conf == null) {
                throw new RuntimeException("Associated Configuration should be defined with key oozie.coord.el.conf");
            }
            int available = 0;
            boolean resolved = false;
            String user = ParamChecker.notEmpty((String)eval.getVariable("user.name"), "user.name");
            String group = ParamChecker.notEmpty((String)eval.getVariable("group.name"), "group.name");
            String doneFlag = ds.getDoneFlag();
            while (nominalInstanceCal.compareTo(initInstance) >= 0) {
                String uriPath;
                ELEvaluator uriEval = CoordELFunctions.getUriEvaluator(nominalInstanceCal);
                String pathWithDoneFlag = uriPath = uriEval.evaluate(uriTemplate, String.class);
                if (doneFlag.length() > 0) {
                    pathWithDoneFlag = pathWithDoneFlag + "/" + doneFlag;
                }
                if (CoordELFunctions.isPathAvailable(pathWithDoneFlag, user, group, conf)) {
                    XLog.getLog(CoordELFunctions.class).debug("Found latest(" + available + "): " + pathWithDoneFlag);
                    if (available == offset) {
                        XLog.getLog(CoordELFunctions.class).debug("Found Latest File: " + pathWithDoneFlag);
                        resolved = true;
                        retVal = DateUtils.formatDateUTC(nominalInstanceCal);
                        eval.setVariable("resolved_path", uriPath);
                        break;
                    }
                    --available;
                }
                nominalInstanceCal = (Calendar)initInstance.clone();
                instCount[0] = instCount[0] - 1;
                nominalInstanceCal.add(dsTimeUnit.getCalendarUnit(), instCount[0] * datasetFrequency);
            }
            if (!resolved) {
                eval.setVariable("is_resolved", Boolean.FALSE);
                retVal = "${coord:latest(" + offset + ")}";
            } else {
                eval.setVariable("is_resolved", Boolean.TRUE);
            }
        } else {
            eval.setVariable("is_resolved", Boolean.FALSE);
        }
        return retVal;
    }

    private static boolean isPathAvailable(String sPath, String user, String group, Configuration conf) throws IOException, HadoopAccessorException {
        Path path = new Path(sPath);
        return Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, path.toUri(), conf).exists(path);
    }

    private static ELEvaluator getUriEvaluator(Calendar tm) {
        ELEvaluator retEval = new ELEvaluator();
        retEval.setVariable("YEAR", tm.get(1));
        retEval.setVariable("MONTH", tm.get(2) + 1 < 10 ? "0" + (tm.get(2) + 1) : Integer.valueOf(tm.get(2) + 1));
        retEval.setVariable("DAY", tm.get(5) < 10 ? "0" + tm.get(5) : Integer.valueOf(tm.get(5)));
        retEval.setVariable("HOUR", tm.get(11) < 10 ? "0" + tm.get(11) : Integer.valueOf(tm.get(11)));
        retEval.setVariable("MINUTE", tm.get(12) < 10 ? "0" + tm.get(12) : Integer.valueOf(tm.get(12)));
        return retEval;
    }

    private static boolean isSyncDataSet() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getType().equalsIgnoreCase("SYNC");
    }

    private static String checkIfResolved(String functionName, String n) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        String replace = (String)eval.getVariable("resolve_" + functionName);
        if (replace == null || replace != null && replace.equalsIgnoreCase("false")) {
            eval.setVariable(".wrap", "true");
            return "coord:" + functionName + "(" + n + ")";
        }
        return null;
    }

    private static String echoUnResolved(String functionName, String n) {
        return CoordELFunctions.echoUnResolvedPre(functionName, n, "coord:");
    }

    private static String echoUnResolvedPre(String functionName, String n, String prefix) {
        ELEvaluator eval = ELEvaluator.getCurrent();
        eval.setVariable(".wrap", "true");
        return prefix + functionName + "(" + n + ")";
    }

    private static Date getInitialInstance() {
        return CoordELFunctions.getInitialInstanceCal().getTime();
    }

    private static Calendar getInitialInstanceCal() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        Calendar effInitTS = Calendar.getInstance();
        effInitTS.setTime(ds.getInitInstance());
        effInitTS.setTimeZone(ds.getTimeZone());
        DateUtils.moveToEnd(effInitTS, CoordELFunctions.getDSEndOfFlag());
        return effInitTS;
    }

    private static Date getActionCreationtime() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return coordAction.getNominalTime();
    }

    private static Date getActualTime() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return coordAction.getActualTime();
    }

    private static TimeZone getJobTZ() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordAction coordAction = (SyncCoordAction)eval.getVariable(COORD_ACTION);
        if (coordAction == null) {
            throw new RuntimeException("Associated Application instance should be defined with key oozie.coord.el.app.bean");
        }
        return coordAction.getTimeZone();
    }

    private static Calendar getCurrentInstance(Date effectiveTime, int[] instanceCount) {
        Date datasetInitialInstance = CoordELFunctions.getInitialInstance();
        TimeUnit dsTimeUnit = CoordELFunctions.getDSTimeUnit();
        TimeZone dsTZ = CoordELFunctions.getDatasetTZ();
        Calendar current = Calendar.getInstance();
        current.setTime(datasetInitialInstance);
        current.setTimeZone(dsTZ);
        Calendar calEffectiveTime = Calendar.getInstance();
        calEffectiveTime.setTime(effectiveTime);
        calEffectiveTime.setTimeZone(dsTZ);
        instanceCount[0] = 0;
        if (current.compareTo(calEffectiveTime) > 0) {
            return null;
        }
        Calendar origCurrent = (Calendar)current.clone();
        while (current.compareTo(calEffectiveTime) <= 0) {
            current = (Calendar)origCurrent.clone();
            instanceCount[0] = instanceCount[0] + 1;
            current.add(dsTimeUnit.getCalendarUnit(), instanceCount[0] * CoordELFunctions.getDSFrequency());
        }
        instanceCount[0] = instanceCount[0] - 1;
        current = (Calendar)origCurrent.clone();
        current.add(dsTimeUnit.getCalendarUnit(), instanceCount[0] * CoordELFunctions.getDSFrequency());
        return current;
    }

    private static Calendar getEffectiveNominalTime() {
        Date datasetInitialInstance = CoordELFunctions.getInitialInstance();
        TimeZone dsTZ = CoordELFunctions.getDatasetTZ();
        Calendar current = Calendar.getInstance();
        current.setTime(datasetInitialInstance);
        current.setTimeZone(dsTZ);
        Calendar calEffectiveTime = Calendar.getInstance();
        calEffectiveTime.setTime(CoordELFunctions.getActionCreationtime());
        calEffectiveTime.setTimeZone(dsTZ);
        if (current.compareTo(calEffectiveTime) > 0) {
            return null;
        }
        return calEffectiveTime;
    }

    private static int getDSFrequency() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getFrequency();
    }

    private static TimeUnit getDSTimeUnit() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getTimeUnit();
    }

    private static TimeZone getDatasetTZ() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getTimeZone();
    }

    private static TimeUnit getDSEndOfFlag() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        SyncCoordDataset ds = (SyncCoordDataset)eval.getVariable(DATASET);
        if (ds == null) {
            throw new RuntimeException("Associated Dataset should be defined with key oozie.coord.el.dataset.bean");
        }
        return ds.getEndOfDuration();
    }

    public static String coord_user() {
        ELEvaluator eval = ELEvaluator.getCurrent();
        return (String)eval.getVariable("user.name");
    }
}

