/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.List;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.command.Command;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.store.SLAStore;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;

public class SLAEventsCommand
extends Command<List<SLAEventBean>, SLAStore> {
    private long seqId;
    private int maxNoEvents;
    private long lastSeqId = -1L;

    public SLAEventsCommand(long seqId, int maxNoEvnts) {
        super("SLAEventsCommand", "SLAEventsCommand", 1, 4);
        this.seqId = seqId;
        this.maxNoEvents = maxNoEvnts;
    }

    @Override
    protected List<SLAEventBean> call(SLAStore store) throws StoreException, CommandException {
        long[] lsId = new long[1];
        List<SLAEventBean> slaEvntList = store.getSLAEventListNewerSeqLimited(this.seqId, this.maxNoEvents, lsId);
        store.getEntityManager().clear();
        this.setLastSeqId(lsId[0]);
        return slaEvntList;
    }

    public void setLastSeqId(long lastSeqId) {
        this.lastSeqId = lastSeqId;
    }

    public long getLastSeqId() {
        return this.lastSeqId;
    }

    @Override
    public Class<? extends Store> getStoreClass() {
        return SLAStore.class;
    }
}

