/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionReadyCommand;
import org.apache.oozie.command.coord.CoordActionTimeOut;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordActionInputCheckCommand
extends CoordinatorCommand<Void> {
    private String actionId;
    private final XLog log = XLog.getLog(this.getClass());
    private int COMMAND_REQUEUE_INTERVAL = 60000;
    private CoordinatorActionBean coordAction = null;

    public CoordActionInputCheckCommand(String actionId) {
        super("coord_action_input", "coord_action_input", 1, 1);
        this.actionId = actionId;
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        this.log.debug("After store.get() for action ID " + this.actionId + " : " + this.coordAction.getStatus());
        Date nominalTime = this.coordAction.getNominalTime();
        Date currentTime = new Date();
        if (nominalTime.compareTo(currentTime) > 0) {
            this.log.info("[" + this.actionId + "]::ActionInputCheck:: nominal Time is newer than current time, so requeue and wait. Current=" + currentTime + ", nominal=" + nominalTime);
            this.queueCallable(new CoordActionInputCheckCommand(this.coordAction.getId()), Math.max(nominalTime.getTime() - currentTime.getTime(), (long)this.COMMAND_REQUEUE_INTERVAL));
            store.updateCoordinatorAction(this.coordAction);
            return null;
        }
        if (this.coordAction.getStatus() == CoordinatorAction.Status.WAITING) {
            this.log.info("[" + this.actionId + "]::ActionInputCheck:: Action is in WAITING state.");
            StringBuilder actionXml = new StringBuilder(this.coordAction.getActionXml());
            Instrumentation.Cron cron = new Instrumentation.Cron();
            try {
                XConfiguration actionConf = new XConfiguration(new StringReader(this.coordAction.getRunConf()));
                cron.start();
                StringBuilder existList = new StringBuilder();
                StringBuilder nonExistList = new StringBuilder();
                StringBuilder nonResolvedList = new StringBuilder();
                CoordCommandUtils.getResolvedList(this.coordAction.getMissingDependencies(), nonExistList, nonResolvedList);
                String[] uriList = nonExistList.toString().split("#");
                if (uriList.length > 0) {
                    this.log.info("[" + this.actionId + "]::ActionInputCheck:: Missing deps:" + uriList[0] + ",  NonResolvedList:" + nonResolvedList.toString());
                } else {
                    this.log.info("[" + this.actionId + "]::ActionInputCheck:: No missing deps,  NonResolvedList:" + nonResolvedList.toString());
                }
                boolean status = this.checkInput(actionXml, existList, nonExistList, actionConf);
                this.coordAction.setLastModifiedTime(currentTime);
                this.coordAction.setActionXml(actionXml.toString());
                if (nonResolvedList.length() > 0 && !status) {
                    nonExistList.append(";").append((CharSequence)nonResolvedList);
                }
                this.coordAction.setMissingDependencies(nonExistList.toString());
                if (status) {
                    this.coordAction.setStatus(CoordinatorAction.Status.READY);
                    this.queueCallable(new CoordActionReadyCommand(this.coordAction.getJobId()), 100L);
                } else {
                    long waitingTime = (currentTime.getTime() - Math.max(this.coordAction.getNominalTime().getTime(), this.coordAction.getCreatedTime().getTime())) / 60000L;
                    int timeOut = this.coordAction.getTimeOut();
                    if (timeOut >= 0 && waitingTime > (long)timeOut) {
                        this.queueCallable(new CoordActionTimeOut(this.coordAction), 100L);
                        this.coordAction.setStatus(CoordinatorAction.Status.TIMEDOUT);
                    } else {
                        this.queueCallable(new CoordActionInputCheckCommand(this.coordAction.getId()), this.COMMAND_REQUEUE_INTERVAL);
                    }
                }
                store.updateCoordActionMin(this.coordAction);
            }
            catch (Exception e) {
                this.log.warn((Object)(this.actionId + ": Exception occurs: " + e + " STORE is active " + store.isActive()), e);
                throw new CommandException(ErrorCode.E1005, e.getMessage(), e);
            }
            cron.stop();
        } else {
            this.log.info("[" + this.actionId + "]::ActionInputCheck:: Ignoring action. Should be in WAITING state, but state=" + this.coordAction.getStatus());
        }
        return null;
    }

    protected boolean checkInput(StringBuilder actionXml, StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml.toString());
        boolean allExist = this.checkResolvedUris(eAction, existList, nonExistList, conf);
        if (allExist) {
            this.log.debug("[" + this.actionId + "]::ActionInputCheck:: Checking Latest/future");
            allExist = this.checkUnresolvedInstances(eAction, conf);
        }
        if (allExist) {
            this.materializeDataProperties(eAction, conf);
            actionXml.replace(0, actionXml.length(), XmlUtils.prettyPrint(eAction).toString());
        }
        return allExist;
    }

    private void materializeDataProperties(Element eAction, Configuration conf) throws Exception {
        ELEvaluator eval = CoordELEvaluator.createDataEvaluator(eAction, conf, this.actionId);
        Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
        if (configElem != null) {
            for (Element propElem : configElem.getChildren("property", configElem.getNamespace())) {
                this.resolveTagContents("value", propElem, eval);
            }
        }
    }

    private void resolveTagContents(String tagName, Element elem, ELEvaluator eval) throws Exception {
        if (elem == null) {
            return;
        }
        Element tagElem = elem.getChild(tagName, elem.getNamespace());
        if (tagElem != null) {
            String updated = CoordELFunctions.evalAndWrap(eval, tagElem.getText());
            tagElem.removeContent();
            tagElem.addContent(updated);
        } else {
            this.log.warn(" Value NOT FOUND " + tagName);
        }
    }

    private boolean checkUnresolvedInstances(Element eAction, Configuration actionConf) throws Exception {
        boolean ret;
        String strAction = XmlUtils.prettyPrint(eAction).toString();
        Date nominalTime = DateUtils.parseDateUTC(eAction.getAttributeValue("action-nominal-time"));
        String actualTimeStr = eAction.getAttributeValue("action-actual-time");
        Date actualTime = null;
        if (actualTimeStr == null) {
            this.log.debug("Unable to get action-actual-time from action xml, this job is submitted from previous version. Assign current date to actual time, action = " + this.actionId);
            actualTime = new Date();
        } else {
            actualTime = DateUtils.parseDateUTC(actualTimeStr);
        }
        StringBuffer resultedXml = new StringBuffer();
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        if (inputList != null && !(ret = this.materializeUnresolvedEvent(inputList.getChildren("data-in", eAction.getNamespace()), nominalTime, actualTime, actionConf))) {
            resultedXml.append(strAction);
            return false;
        }
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        if (outputList != null) {
            for (Element dEvent : outputList.getChildren("data-out", eAction.getNamespace())) {
                if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
                throw new CommandException(ErrorCode.E1006, "coord:latest()/future()", " not permitted in output-event ");
            }
        }
        return true;
    }

    private boolean materializeUnresolvedEvent(List<Element> eDataEvents, Date nominalTime, Date actualTime, Configuration conf) throws Exception {
        for (Element dEvent : eDataEvents) {
            if (dEvent.getChild("unresolved-instances", dEvent.getNamespace()) == null) continue;
            ELEvaluator eval = CoordELEvaluator.createLazyEvaluator(actualTime, nominalTime, dEvent, conf);
            String uresolvedInstance = dEvent.getChild("unresolved-instances", dEvent.getNamespace()).getTextTrim();
            String[] unresolvedList = uresolvedInstance.split("#");
            StringBuffer resolvedTmp = new StringBuffer();
            for (int i = 0; i < unresolvedList.length; ++i) {
                String ret = CoordELFunctions.evalAndWrap(eval, unresolvedList[i]);
                Boolean isResolved = (Boolean)eval.getVariable("is_resolved");
                if (!isResolved.booleanValue()) {
                    this.log.info("[" + this.actionId + "]::Cannot resolve: " + ret);
                    return false;
                }
                if (resolvedTmp.length() > 0) {
                    resolvedTmp.append("#");
                }
                resolvedTmp.append((String)eval.getVariable("resolved_path"));
            }
            if (resolvedTmp.length() > 0) {
                if (dEvent.getChild("uris", dEvent.getNamespace()) != null) {
                    resolvedTmp.append("#").append(dEvent.getChild("uris", dEvent.getNamespace()).getTextTrim());
                    dEvent.removeChild("uris", dEvent.getNamespace());
                }
                Element uriInstance = new Element("uris", dEvent.getNamespace());
                uriInstance.addContent(resolvedTmp.toString());
                dEvent.getContent().add(1, uriInstance);
            }
            dEvent.removeChild("unresolved-instances", dEvent.getNamespace());
        }
        return true;
    }

    private boolean checkResolvedUris(Element eAction, StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws IOException {
        this.log.info("[" + this.actionId + "]::ActionInputCheck:: In checkResolvedUris...");
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        if (inputList != null) {
            if (nonExistList.length() > 0) {
                this.checkListOfPaths(existList, nonExistList, conf);
            }
            return nonExistList.length() == 0;
        }
        return true;
    }

    private boolean checkListOfPaths(StringBuilder existList, StringBuilder nonExistList, Configuration conf) throws IOException {
        String[] uriList = nonExistList.toString().split("#");
        if (uriList[0] != null) {
            this.log.info("[" + this.actionId + "]::ActionInputCheck:: In checkListOfPaths: " + uriList[0] + " is Missing.");
        }
        nonExistList.delete(0, nonExistList.length());
        boolean allExists = true;
        String existSeparator = "";
        String nonExistSeparator = "";
        for (int i = 0; i < uriList.length; ++i) {
            if (allExists) {
                allExists = this.pathExists(uriList[i], conf);
                this.log.info("[" + this.actionId + "]::ActionInputCheck:: File:" + uriList[i] + ", Exists? :" + allExists);
            }
            if (allExists) {
                existList.append(existSeparator).append(uriList[i]);
                existSeparator = "#";
                continue;
            }
            nonExistList.append(nonExistSeparator).append(uriList[i]);
            nonExistSeparator = "#";
        }
        return allExists;
    }

    private boolean pathExists(String sPath, Configuration actionConf) throws IOException {
        this.log.debug("checking for the file " + sPath);
        Path path = new Path(sPath);
        String user = ParamChecker.notEmpty(actionConf.get("user.name"), "user.name");
        String group = ParamChecker.notEmpty(actionConf.get("group.name"), "group.name");
        try {
            return Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, path.toUri(), actionConf).exists(path);
        }
        catch (HadoopAccessorException e) {
            throw new IOException(e);
        }
    }

    private String createURIs(Element event, String instances, StringBuilder unresolvedInstances) throws Exception {
        if (instances == null || instances.length() == 0) {
            return "";
        }
        String[] instanceList = instances.split("#");
        StringBuilder uris = new StringBuilder();
        for (int i = 0; i < instanceList.length; ++i) {
            int funcType = CoordCommandUtils.getFuncType(instanceList[i]);
            if (funcType == CoordCommandUtils.LATEST || funcType == CoordCommandUtils.FUTURE) {
                if (unresolvedInstances.length() > 0) {
                    unresolvedInstances.append("#");
                }
                unresolvedInstances.append(instanceList[i]);
                continue;
            }
            ELEvaluator eval = CoordELEvaluator.createURIELEvaluator(instanceList[i]);
            if (uris.length() > 0) {
                uris.append("#");
            }
            uris.append(CoordELFunctions.evalAndWrap(eval, event.getChild("dataset", event.getNamespace()).getChild("uri-template", event.getNamespace()).getTextTrim()));
        }
        return uris.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordActionInputCheckCommand for actionid=" + this.actionId);
        try {
            this.coordAction = (CoordinatorActionBean)store.getEntityManager().find(CoordinatorActionBean.class, (Object)this.actionId);
            this.setLogInfo(this.coordAction);
            if (this.lock(this.coordAction.getJobId())) {
                this.call(store);
            } else {
                this.queueCallable(new CoordActionInputCheckCommand(this.actionId), 30000L);
                this.log.warn("CoordActionInputCheckCommand lock was not acquired - failed jobId=" + this.coordAction.getJobId() + ", actionId=" + this.actionId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordActionInputCheckCommand(this.actionId), 30000L);
            this.log.warn("CoordActionInputCheckCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + this.coordAction.getJobId() + ", actionId=" + this.actionId + " Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordActionInputCheckCommand for actionid=" + this.actionId);
        }
        return null;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }
}

