/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.orc.OrcConverter;
import org.pentaho.hadoop.shim.common.format.orc.OrcMetaDataReader;
import org.pentaho.hadoop.shim.common.format.orc.OrcSchemaConverter;

public class PentahoOrcRecordReader
implements IPentahoInputFormat.IPentahoRecordReader {
    protected static Logger logger = LogManager.getLogger(PentahoOrcRecordReader.class);
    protected List<? extends IOrcInputField> dialogInputFields;
    protected List<? extends IOrcInputField> orcInputFields;
    protected VectorizedRowBatch batch;
    protected RecordReader recordReader;
    protected int currentBatchRow;
    protected TypeDescription typeDescription;
    protected Map<String, Integer> schemaToOrcSubcripts;
    protected OrcConverter orcConverter = new OrcConverter();

    protected PentahoOrcRecordReader(String fileName, Configuration conf, List<? extends IOrcInputField> dialogInputFields) {
        this.dialogInputFields = dialogInputFields;
        Reader reader = PentahoOrcRecordReader.getReader(fileName, conf);
        this.readRows(fileName, reader);
    }

    protected PentahoOrcRecordReader(String fileName, List<? extends IOrcInputField> dialogInputFields, Reader reader) {
        this.dialogInputFields = dialogInputFields;
        this.readRows(fileName, reader);
    }

    private void readRows(String fileName, Reader reader) {
        try {
            this.recordReader = reader.rows();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get record reader for file " + fileName, e);
        }
        this.typeDescription = reader.getSchema();
        OrcSchemaConverter orcSchemaConverter = new OrcSchemaConverter();
        this.orcInputFields = orcSchemaConverter.buildInputFields(this.typeDescription);
        OrcMetaDataReader orcMetaDataReader = new OrcMetaDataReader(reader);
        orcMetaDataReader.read(this.orcInputFields);
        this.batch = this.typeDescription.createRowBatch();
        HashMap<String, Integer> orcColumnNumberMap = new HashMap<String, Integer>();
        int orcFieldNumber = 0;
        for (String string : this.typeDescription.getFieldNames()) {
            orcColumnNumberMap.put(string, orcFieldNumber++);
        }
        this.schemaToOrcSubcripts = new HashMap<String, Integer>();
        for (IOrcInputField iOrcInputField : this.dialogInputFields) {
            if (iOrcInputField == null) continue;
            Integer colNumber = (Integer)orcColumnNumberMap.get(iOrcInputField.getFormatFieldName());
            if (colNumber == null) {
                throw new IllegalArgumentException("Column " + iOrcInputField.getFormatFieldName() + " does not exist in the ORC file.  Please use the getFields button");
            }
            this.schemaToOrcSubcripts.put(iOrcInputField.getPentahoFieldName(), colNumber);
        }
        try {
            this.setNextBatch();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("No rows to read in " + fileName, e);
        }
    }

    static Reader getReader(String fileName, Configuration conf) {
        try {
            S3NCredentialUtils util = new S3NCredentialUtils();
            util.applyS3CredentialsToHadoopConfigurationIfNecessary(fileName, conf);
            Path filePath = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(fileName));
            FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)conf);
            if (!fs.exists(filePath)) {
                throw new NoSuchFileException(fileName);
            }
            if (fs.getFileStatus(filePath).isDirectory()) {
                PathFilter pathFilter = file -> file.getName().endsWith(".orc");
                FileStatus[] fileStatuses = fs.listStatus(filePath, pathFilter);
                if (fileStatuses.length == 0) {
                    throw new NoSuchFileException(fileName);
                }
                filePath = fileStatuses[0].getPath();
            }
            return OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).filesystem(fs));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read data from file " + fileName, e);
        }
    }

    protected boolean setNextBatch() throws IOException {
        this.currentBatchRow = 0;
        return this.recordReader.nextBatch(this.batch);
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    public Iterator<RowMetaAndData> iterator() {
        return new Iterator<RowMetaAndData>(){

            @Override
            public boolean hasNext() {
                if (PentahoOrcRecordReader.this.currentBatchRow < PentahoOrcRecordReader.this.batch.size) {
                    return true;
                }
                try {
                    return PentahoOrcRecordReader.this.setNextBatch();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }

            @Override
            public RowMetaAndData next() {
                RowMetaAndData rowMeta = PentahoOrcRecordReader.this.orcConverter.convertFromOrc(PentahoOrcRecordReader.this.batch, PentahoOrcRecordReader.this.currentBatchRow, PentahoOrcRecordReader.this.dialogInputFields, PentahoOrcRecordReader.this.typeDescription, PentahoOrcRecordReader.this.schemaToOrcSubcripts, PentahoOrcRecordReader.this.orcInputFields);
                ++PentahoOrcRecordReader.this.currentBatchRow;
                return rowMeta;
            }
        };
    }
}

