/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileDepthSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.util.VersionInfo;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.PluginFolder;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ShimRuntimeException;
import org.pentaho.hadoop.shim.api.internal.DistributedCacheUtil;
import org.pentaho.hadoop.shim.api.internal.fs.FileSystem;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedCacheUtilImpl
implements DistributedCacheUtil {
    protected static Logger logger = LoggerFactory.getLogger(DistributedCacheUtilImpl.class);
    private static final String PATH_LIB = "lib";
    private static final String PATH_PLUGINS = "plugins";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Pattern NOT_LIB_FILES = Pattern.compile("^((?!/lib).)*$");
    private static final FsPermission CACHED_FILE_PERMISSION = new FsPermission(493);
    private static final FsPermission PUBLIC_CACHED_FILE_PERMISSION = new FsPermission(511);
    public static final String PENTAHO_BIG_DATA_PLUGIN_FOLDER_NAME = "pentaho-big-data-plugin";
    private static final String CONFIG_PROPERTIES = "config.properties";
    private static final String AUTH_PREFIX = "pentaho.authentication";

    public Path getLockFileAt(Path dir) {
        return new Path(dir, ".lock");
    }

    public boolean isKettleEnvironmentInstalledAt(org.apache.hadoop.fs.FileSystem fs, Path root) throws IOException {
        Path[] directories = new Path[]{new Path(root, PATH_LIB)};
        Path lock = this.getLockFileAt(root);
        for (Path dir : directories) {
            if (fs.exists(dir) && fs.getFileStatus(dir).isDirectory()) continue;
            return false;
        }
        return !fs.exists(lock);
    }

    public void installKettleEnvironment(FileObject pmrArchive, org.apache.hadoop.fs.FileSystem fs, Path destination, FileObject bigDataPlugin, String additionalPlugins, String excludePluginFileNames, String shimIdentifier) throws IOException, KettleFileException {
        if (pmrArchive == null) {
            throw new NullPointerException("pmrArchive is required");
        }
        if (destination == null) {
            throw new NullPointerException("destination is required");
        }
        if (bigDataPlugin == null) {
            throw new NullPointerException("big data plugin required");
        }
        FileObject extracted = this.extractToTemp(pmrArchive);
        Path lockFile = this.getLockFileAt(destination);
        FSDataOutputStream out = fs.create(lockFile, true);
        out.close();
        this.stageForCache(extracted, fs, destination, "", true, false);
        java.nio.file.Path shimDriverInstallationDirectory = Paths.get(Const.getShimDriverDeploymentLocation(), new String[0]);
        this.stagePentahoHadoopShims(fs, destination, shimDriverInstallationDirectory);
        this.stageBigDataPlugin(fs, destination, bigDataPlugin, shimIdentifier);
        if (StringUtils.isNotEmpty((String)additionalPlugins)) {
            this.stagePluginsForCache(fs, new Path(destination, PATH_PLUGINS), additionalPlugins, excludePluginFileNames);
        }
        fs.delete(lockFile, true);
    }

    private Map<String, String> getDrivers(java.nio.file.Path dir) throws IOException {
        Map<String, String> files = new HashMap<String, String>();
        if (dir.toFile().exists()) {
            try (Stream<java.nio.file.Path> input = Files.walk(dir, new FileVisitOption[0]);){
                files = input.filter(x -> x.toFile().isFile()).collect(Collectors.toMap(java.nio.file.Path::toString, x -> x.toString().replace(dir.toString() + File.separator, "")));
            }
        }
        return files;
    }

    private void stagePentahoHadoopShims(org.apache.hadoop.fs.FileSystem fs, Path dest, java.nio.file.Path shimDriverInstallationDirectory) throws IOException {
        Map<String, String> files = this.getDrivers(shimDriverInstallationDirectory);
        files.forEach((localPath, relativePath) -> {
            try {
                this.stageForCache(KettleVFS.getFileObject((String)localPath), fs, new Path(dest, "drivers/" + relativePath), "", true, false);
            }
            catch (IOException | KettleFileException e) {
                logger.info("Failed to stage the shims to distributed cache.");
            }
        });
    }

    private void stageBigDataPlugin(org.apache.hadoop.fs.FileSystem fs, Path dest, FileObject pluginFolder, String shimIdentifier) throws KettleFileException, IOException {
        FileObject shimLibsDir;
        FileObject shimDir;
        Path pluginsDir = new Path(dest, PATH_PLUGINS);
        Path bigDataPluginDir = new Path(pluginsDir, pluginFolder.getName().getBaseName());
        for (FileObject f : pluginFolder.findFiles((FileSelector)new FileDepthSelector(1, 1))) {
            if ("hadoop-configurations".equals(f.getName().getBaseName()) || "pentaho-mapreduce-libraries.zip".equals(f.getName().getBaseName())) continue;
            this.stageForCache(f, fs, new Path(bigDataPluginDir, f.getName().getBaseName()), "", true, false);
        }
        FileObject pmrLibsDir = null;
        FileObject hadoopConfigurationsDir = pluginFolder.getChild("hadoop-configurations");
        if (hadoopConfigurationsDir != null && (shimDir = hadoopConfigurationsDir.getChild(shimIdentifier)) != null && (shimLibsDir = shimDir.getChild(PATH_LIB)) != null) {
            pmrLibsDir = shimLibsDir.getChild("pmr");
        }
        Path pdiLib = new Path(dest, PATH_LIB);
        if (pmrLibsDir != null) {
            for (FileObject f : pmrLibsDir.getChildren()) {
                this.stageForCache(f, fs, new Path(pdiLib, f.getName().getBaseName()), "", true, false);
            }
        }
    }

    public void stagePluginsForCache(org.apache.hadoop.fs.FileSystem fs, Path pluginsDir, String pluginFolderNames, String excludePluginFileNames) throws KettleFileException, IOException {
        if (pluginFolderNames == null) {
            throw new IllegalArgumentException("pluginFolderNames required");
        }
        if (!fs.exists(pluginsDir)) {
            fs.mkdirs(pluginsDir);
        }
        for (String localPluginPath : pluginFolderNames.split(",")) {
            Object[] localFileTuple = this.findPluginFolder(localPluginPath);
            if (localFileTuple == null || localFileTuple.length == 0 || !((FileObject)localFileTuple[0]).exists()) {
                throw new KettleFileException(BaseMessages.getString(DistributedCacheUtilImpl.class, (String)"DistributedCacheUtil.PluginDirectoryNotFound", (String[])new String[]{localPluginPath}));
            }
            FileObject localFile = (FileObject)localFileTuple[0];
            String relativePath = (String)localFileTuple[1];
            Path pluginDir = new Path(pluginsDir, relativePath);
            this.stageForCache(localFile, fs, pluginDir, excludePluginFileNames, true, false);
        }
    }

    public void configureWithKettleEnvironment(Configuration conf, org.apache.hadoop.fs.FileSystem fs, Path kettleInstallDir) throws IOException {
        Path libDir = new Path(kettleInstallDir, PATH_LIB);
        List<Path> libraryJars = this.findFiles(fs, libDir, null);
        this.addCachedFilesToClasspath(libraryJars, conf);
        List<Path> nonLibFiles = this.findFiles(fs, kettleInstallDir, NOT_LIB_FILES);
        this.addCachedFiles(nonLibFiles, conf);
    }

    public void addCachedFilesToClasspath(List<Path> files, Configuration conf) throws IOException {
        DistributedCache.createSymlink((Configuration)conf);
        for (Path file : files) {
            this.addFileToClassPath(this.disqualifyPath(file), conf);
        }
    }

    public void addFileToClassPath(Path file, Configuration conf) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VersionInfo.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(cl);
        String classpath = conf.get("mapred.job.classpath.files");
        conf.set("mapred.job.classpath.files", classpath == null ? file.toString() : classpath + this.getClusterPathSeparator() + file.toString());
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((Configuration)conf);
        URI uri = fs.makeQualified(file).toUri();
        DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
    }

    public void addCachedFiles(List<Path> paths, Configuration conf) {
        DistributedCache.createSymlink((Configuration)conf);
        for (Path path : paths) {
            DistributedCache.addCacheFile((URI)URI.create(path.toUri() + "#" + path.getName()), (Configuration)conf);
        }
    }

    public Path disqualifyPath(Path path) {
        return new Path(path.toUri().getPath());
    }

    @Deprecated
    public void stageForCache(FileObject source, org.apache.hadoop.fs.FileSystem fs, Path dest, boolean overwrite) throws IOException, KettleFileException {
        this.stageForCache(source, fs, dest, "", overwrite, false);
    }

    public void stageForCache(FileObject source, org.apache.hadoop.fs.FileSystem fs, Path dest, String excludePluginFileNames, boolean overwrite, boolean isPublic) throws IOException, KettleFileException {
        if (!source.exists()) {
            throw new KettleFileException(BaseMessages.getString(DistributedCacheUtilImpl.class, (String)"DistributedCacheUtil.SourceDoesNotExist", (Object[])new Object[]{source}));
        }
        if (fs.exists(dest)) {
            if (overwrite) {
                fs.delete(dest, true);
            } else {
                throw new KettleFileException(BaseMessages.getString(DistributedCacheUtilImpl.class, (String)"DistributedCacheUtil.DestinationExists", (String[])new String[]{dest.toUri().getPath()}));
            }
        }
        short replication = (short)fs.getConf().getInt("mapred.submit.replication", 10);
        if (source.getURL().toString().endsWith(CONFIG_PROPERTIES)) {
            this.copyConfigProperties(source, fs, dest);
        } else {
            if (source.isFolder() && excludePluginFileNames.length() > 0) {
                String tempDirName = "";
                try (FileObject tempDir = KettleVFS.createTempFile((String)"", (String)source.getName().getBaseName(), (String)System.getProperty("java.io.tmpdir"));){
                    tempDirName = tempDir.getName().getPath() + File.separator + source.getName().getBaseName();
                }
                FileUtils.copyDirectory((File)new File(source.getName().getPath()), (File)new File(tempDirName));
                tempDir = KettleVFS.getFileObject((String)tempDirName);
                try {
                    this.removeExcludedFiles(tempDir, excludePluginFileNames);
                    Path local = new Path(tempDir.getURL().getPath());
                    fs.copyFromLocalFile(local, dest);
                    tempDir.delete();
                }
                finally {
                    if (tempDir != null) {
                        tempDir.close();
                    }
                }
            }
            Path local = new Path(source.getURL().getPath());
            fs.copyFromLocalFile(local, dest);
        }
        if (isPublic) {
            fs.setPermission(dest, PUBLIC_CACHED_FILE_PERMISSION);
        } else {
            fs.setPermission(dest, CACHED_FILE_PERMISSION);
        }
        fs.setReplication(dest, replication);
    }

    private void removeExcludedFiles(FileObject tempPluginDir, String filesToExclude) throws FileSystemException {
        final List<String> excludeList = Arrays.asList(filesToExclude.split(","));
        tempPluginDir.delete(new FileSelector(){

            public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                String jarName;
                FileName scannedName = fileSelectInfo.getFile().getName();
                if ("jar".equals(scannedName.getExtension()) && !Strings.isNullOrEmpty((String)(jarName = scannedName.getBaseName()))) {
                    for (String excludeFile : excludeList) {
                        if (!jarName.startsWith(excludeFile)) continue;
                        return true;
                    }
                }
                return false;
            }

            public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                return FileType.FOLDER.equals((Object)fileSelectInfo.getFile().getType());
            }
        });
    }

    private void copyConfigProperties(FileObject source, org.apache.hadoop.fs.FileSystem fs, Path dest) {
        try (FSDataOutputStream output = fs.create(dest);
             InputStream input = source.getContent().getInputStream();){
            List lines = IOUtils.readLines((InputStream)input);
            for (String line : lines) {
                if (line.startsWith(AUTH_PREFIX)) continue;
                IOUtils.write((String)line, (OutputStream)output);
                IOUtils.write((String)String.format("%n", new Object[0]), (OutputStream)output);
            }
        }
        catch (IOException e) {
            throw new ShimRuntimeException("Error copying modified version of config.properties", e);
        }
    }

    public List<String> findFiles(FileObject root, final String extension) throws FileSystemException {
        FileObject[] files = root.findFiles(new FileSelector(){

            public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                return extension == null || extension.equals(fileSelectInfo.getFile().getName().getExtension());
            }

            public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                return FileType.FOLDER.equals((Object)fileSelectInfo.getFile().getType());
            }
        });
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (FileObject file : files) {
            try {
                paths.add(file.getURL().toURI().getPath());
            }
            catch (URISyntaxException ex) {
                throw new FileSystemException("Error getting URI of file: " + file.getURL().getPath());
            }
        }
        return paths;
    }

    public List<Path> findFiles(org.apache.hadoop.fs.FileSystem fs, Path path, Pattern fileNamePattern) throws IOException {
        FileStatus[] files = fs.listStatus(path);
        ArrayList<Path> found = new ArrayList<Path>(files.length);
        for (FileStatus file : files) {
            if (fileNamePattern != null && !fileNamePattern.matcher(file.getPath().toString()).matches()) continue;
            found.add(file.getPath());
        }
        return found;
    }

    public boolean deleteDirectory(FileObject dir) throws FileSystemException {
        dir.delete((FileSelector)new AllFileSelector());
        return !dir.exists();
    }

    public FileObject extractToTemp(FileObject archive) throws IOException, KettleFileException {
        if (archive == null) {
            throw new NullPointerException("archive is required");
        }
        FileObject dest = KettleVFS.createTempFile((String)"", (String)"", (String)System.getProperty("java.io.tmpdir"));
        return this.extract(archive, dest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileObject extract(FileObject archive, FileObject dest) throws IOException, KettleFileException {
        if (!archive.exists()) {
            throw new IllegalArgumentException("archive does not exist: " + archive.getURL().getPath());
        }
        if (dest.exists()) {
            throw new IllegalArgumentException("destination already exists");
        }
        dest.createFolder();
        try {
            byte[] buffer = new byte[8192];
            int len = 0;
            try (ZipInputStream zis = new ZipInputStream(archive.getContent().getInputStream());){
                ZipEntry ze;
                block12: while ((ze = zis.getNextEntry()) != null) {
                    FileObject entry = KettleVFS.getFileObject((String)(dest + Const.FILE_SEPARATOR + ze.getName()));
                    FileObject parent = entry.getParent();
                    if (parent != null) {
                        parent.createFolder();
                    }
                    if (ze.isDirectory()) {
                        entry.createFolder();
                        continue;
                    }
                    OutputStream os = KettleVFS.getOutputStream((FileObject)entry, (boolean)false);
                    try {
                        while (true) {
                            if ((len = zis.read(buffer)) <= 0) continue block12;
                            os.write(buffer, 0, len);
                        }
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                return dest;
            }
        }
        catch (Exception ex) {
            if (this.deleteDirectory(dest)) throw new KettleFileException("error extracting archive", (Throwable)ex);
            throw new KettleFileException("Could not clean up temp dir after error extracting", (Throwable)ex);
        }
    }

    protected Object[] findPluginFolder(String pluginFolderName) throws KettleFileException {
        List pluginFolders = PluginFolder.populateFolders(null);
        if (pluginFolders != null) {
            for (PluginFolderInterface pluginFolder : pluginFolders) {
                FileObject folder = KettleVFS.getFileObject((String)pluginFolder.getFolder());
                try {
                    FileObject[] files;
                    if (!folder.exists() || (files = folder.findFiles((FileSelector)new PluginFolderSelector(pluginFolderName))) == null || files.length <= 0) continue;
                    return new Object[]{files[0], folder.getName().getRelativeName(files[0].getName())};
                }
                catch (FileSystemException ex) {
                    throw new KettleFileException("Error searching for folder '" + pluginFolderName + "'", (Throwable)ex);
                }
            }
        }
        return new Object[0];
    }

    public String getClusterPathSeparator() {
        return System.getProperty("hadoop.cluster.path.separator", ",");
    }

    @Override
    public boolean isKettleEnvironmentInstalledAt(FileSystem fs, org.pentaho.hadoop.shim.api.internal.fs.Path kettleEnvInstallDir) throws IOException {
        return this.isKettleEnvironmentInstalledAt(ShimUtils.asFileSystem(fs), ShimUtils.asPath(kettleEnvInstallDir));
    }

    @Override
    public void configureWithKettleEnvironment(org.pentaho.hadoop.shim.api.internal.Configuration conf, FileSystem fs, org.pentaho.hadoop.shim.api.internal.fs.Path kettleEnvInstallDir) throws KettleFileException, IOException {
        this.configureWithKettleEnvironment((Configuration)ShimUtils.asConfiguration(conf), ShimUtils.asFileSystem(fs), ShimUtils.asPath(kettleEnvInstallDir));
    }

    @Override
    public void installKettleEnvironment(FileObject pmrLibArchive, FileSystem fs, org.pentaho.hadoop.shim.api.internal.fs.Path destination, FileObject bigDataPluginFolder, String additionalPlugins, String excludePluginFileNames, String shimIdentifier) throws KettleFileException, IOException {
        this.installKettleEnvironment(pmrLibArchive, ShimUtils.asFileSystem(fs), ShimUtils.asPath(destination), bigDataPluginFolder, additionalPlugins, excludePluginFileNames, shimIdentifier);
    }

    @Override
    public void stageForCache(FileObject source, FileSystem fs, org.pentaho.hadoop.shim.api.internal.fs.Path dest, String excludePluginFileNames, boolean overwrite, boolean isPublic) throws IOException {
        try {
            this.stageForCache(source, ShimUtils.asFileSystem(fs), ShimUtils.asPath(dest), excludePluginFileNames, overwrite, isPublic);
        }
        catch (KettleFileException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addCachedFilesToClasspath(org.pentaho.hadoop.shim.api.internal.Configuration conf, FileSystem fs, org.pentaho.hadoop.shim.api.internal.fs.Path source, Pattern fileNamePattern) throws IOException {
        List<Path> libraryJars = this.findFiles(ShimUtils.asFileSystem(fs), ShimUtils.asPath(source), fileNamePattern);
        this.addCachedFilesToClasspath(libraryJars, (Configuration)ShimUtils.asConfiguration(conf));
    }

    @Override
    public void addCachedFiles(org.pentaho.hadoop.shim.api.internal.Configuration conf, FileSystem fs, org.pentaho.hadoop.shim.api.internal.fs.Path source, Pattern fileNamePattern) throws IOException {
        List<Path> nonLibFiles = this.findFiles(ShimUtils.asFileSystem(fs), ShimUtils.asPath(source), fileNamePattern);
        this.addCachedFiles(nonLibFiles, (Configuration)ShimUtils.asConfiguration(conf));
    }

    private class PluginFolderSelector
    implements FileSelector {
        String pluginFolderName;

        public PluginFolderSelector(String pluginFolderName) {
            this.pluginFolderName = pluginFolderName;
        }

        public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
            if (fileSelectInfo.getFile().equals(fileSelectInfo.getBaseFolder())) {
                return false;
            }
            int baseNameLength = fileSelectInfo.getBaseFolder().getName().getPath().length() + 1;
            String relativeName = fileSelectInfo.getFile().getName().getPath().substring(baseNameLength);
            return this.pluginFolderName.equals(relativeName);
        }

        public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
            return true;
        }
    }
}

