/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.FileObject;
import org.apache.hadoop.conf.Configuration;
import org.pentaho.big.data.api.shims.LegacyShimLocator;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.core.ShimIdentifierInterface;

public class ShimConfigsLoader {
    private static final Class<?> PKG = ShimConfigsLoader.class;
    private static LogChannelInterface log = new LogChannel((Object)ShimConfigsLoader.class.getName());
    public static Set<String> CLUSTER_NAME_FOR_LOGGING = new HashSet<String>();
    public static Set<String> SITE_FILE_NAME = new HashSet<String>();
    public static final String CONFIGS_DIR_PREFIX = "metastore" + File.separator + "pentaho" + File.separator + "NamedCluster" + File.separator + "Configs";

    public static Properties loadConfigProperties(String additionalPath) {
        return ShimConfigsLoader.getConfigProperties(ShimConfigsLoader.getURLToResourceFile(ClusterConfigNames.CONFIGS_PROP.toString(), additionalPath));
    }

    public static URL getURLToResourceFile(String siteFileName, String additionalPath) {
        try {
            FileObject currentPath = null;
            if (additionalPath != null && !additionalPath.equals("")) {
                currentPath = KettleVFS.getFileObject((String)(Const.getKettleDirectory() + File.separator + CONFIGS_DIR_PREFIX + File.separator + additionalPath + File.separator + siteFileName));
                if (currentPath.exists()) {
                    return currentPath.getURL();
                }
                currentPath = KettleVFS.getFileObject((String)(Const.getUserHomeDirectory() + File.separator + ".pentaho" + File.separator + CONFIGS_DIR_PREFIX + File.separator + additionalPath + File.separator + siteFileName));
                if (currentPath.exists()) {
                    return currentPath.getURL();
                }
                currentPath = KettleVFS.getFileObject((String)(Const.getUserHomeDirectory() + File.separator + CONFIGS_DIR_PREFIX + File.separator + additionalPath + File.separator + siteFileName));
                if (currentPath.exists()) {
                    return currentPath.getURL();
                }
                PluginInterface pluginInterface = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, "HadoopSpoonPlugin");
                currentPath = KettleVFS.getFileObject((String)(pluginInterface.getPluginDirectory().getPath() + File.separator + CONFIGS_DIR_PREFIX + File.separator + additionalPath + File.separator + siteFileName));
                if (currentPath.exists()) {
                    return currentPath.getURL();
                }
            }
            String defaultShim = LegacyShimLocator.getLegacyDefaultShimName();
            List shimIdentifers = LegacyShimLocator.getInstance().getRegisteredShims();
            for (ShimIdentifierInterface shim : shimIdentifers) {
                if (!shim.getId().equals(defaultShim) || !(currentPath = KettleVFS.getFileObject((String)(LegacyShimLocator.getLegacyDefaultShimDir((String)defaultShim) + File.separator + siteFileName))).exists()) continue;
                log.logBasic(BaseMessages.getString(PKG, (String)"ShimConfigsLoader.UsingLegacyConfig", (String[])new String[0]));
                return currentPath.getURL();
            }
            if (additionalPath != null && !"".equals(additionalPath)) {
                if (!CLUSTER_NAME_FOR_LOGGING.contains(additionalPath)) {
                    SITE_FILE_NAME.clear();
                    log.logBasic(BaseMessages.getString(PKG, (String)"ShimConfigsLoader.UnableToFindConfigs", (String[])new String[0]), new Object[]{siteFileName, additionalPath});
                    CLUSTER_NAME_FOR_LOGGING.add(additionalPath);
                    SITE_FILE_NAME.add(siteFileName);
                } else if (!SITE_FILE_NAME.contains(siteFileName)) {
                    log.logBasic(BaseMessages.getString(PKG, (String)"ShimConfigsLoader.UnableToFindConfigs", (String[])new String[0]), new Object[]{siteFileName, additionalPath});
                    SITE_FILE_NAME.add(siteFileName);
                }
            }
        }
        catch (IOException | KettleFileException ex) {
            log.logError(BaseMessages.getString(PKG, (String)"ShimConfigsLoader.ExceptionReadingFile", (String[])new String[0]), new Object[]{siteFileName, additionalPath, ex.getStackTrace()});
        }
        return null;
    }

    public static void addConfigsAsResources(NamedCluster namedCluster, BiConsumer<? super InputStream, ? super String> configurationConsumer) {
        ShimConfigsLoader.addConfigsAsResources(namedCluster, configurationConsumer, ShimConfigsLoader.createSiteFilesArray());
    }

    public static void addConfigsAsResources(NamedCluster namedCluster, BiConsumer<? super InputStream, ? super String> configurationConsumer, String ... fileNames) {
        ShimConfigsLoader.addConfigsAsResources(namedCluster, configurationConsumer, Arrays.asList(fileNames));
    }

    public static void addConfigsAsResources(NamedCluster namedCluster, BiConsumer<? super InputStream, ? super String> configurationConsumer, List<String> fileNames) {
        for (String siteFile : fileNames) {
            InputStream is = namedCluster.getSiteFileInputStream(siteFile);
            if (is == null) continue;
            configurationConsumer.accept(is, siteFile);
        }
    }

    @Deprecated
    public static void addConfigsAsResources(String additionalPath, Consumer<? super URL> configurationConsumer) {
        ShimConfigsLoader.addConfigsAsResources(additionalPath, configurationConsumer, ShimConfigsLoader.createSiteFilesArray());
    }

    public static void addConfigsAsResources(String additionalPath, Consumer<? super URL> configurationConsumer, String ... fileNames) {
        ShimConfigsLoader.addConfigsAsResources(additionalPath, configurationConsumer, Arrays.asList(fileNames));
    }

    public static void addConfigsAsResources(String additionalPath, Consumer<? super URL> configurationConsumer, ClusterConfigNames ... fileNames) {
        ShimConfigsLoader.setSystemProperties(additionalPath);
        ShimConfigsLoader.addConfigsAsResources(additionalPath, configurationConsumer, Arrays.stream(fileNames).map(ClusterConfigNames::toString).collect(Collectors.toList()));
    }

    public static void setSystemProperties(String additionalPath) {
        Properties properties = ShimConfigsLoader.loadConfigProperties(additionalPath);
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith("java.system.")) continue;
            System.setProperty(propertyName.substring("java.system.".length()), properties.get(propertyName).toString());
        }
    }

    public static void addConfigsAsResources(String additionalPath, Consumer<? super URL> configurationConsumer, List<String> fileNames) {
        fileNames.stream().map(siteFile -> ShimConfigsLoader.getURLToResourceFile(siteFile, additionalPath)).filter(Objects::nonNull).forEach(configurationConsumer);
    }

    private static String[] createSiteFilesArray() {
        return new String[]{ClusterConfigNames.CORE_SITE.toString(), ClusterConfigNames.HDFS_SITE.toString(), ClusterConfigNames.YARN_SITE.toString(), ClusterConfigNames.MAPRED_SITE.toString(), ClusterConfigNames.HBASE_SITE.toString(), ClusterConfigNames.HIVE_SITE.toString()};
    }

    private static Properties getConfigProperties(URL pathToConfigProperties) {
        Properties properties = new Properties();
        try {
            if (pathToConfigProperties != null) {
                FileInputStream fis = new FileInputStream(pathToConfigProperties.getFile());
                properties.load(fis);
                fis.close();
            }
        }
        catch (IOException ex) {
            log.logError(BaseMessages.getString(ShimConfigsLoader.class, (String)"ShimConfigsLoader.ExceptionLoadingProperties", (String[])new String[0]), (Throwable)ex);
        }
        return properties;
    }

    public static Map<String, String> parseFile(URL fileUrl) {
        Configuration c = new Configuration();
        c.addResource(fileUrl);
        return c.getValByRegex(".*");
    }

    public static Map<String, String> parseFile(NamedCluster namedCluster, String fileName) {
        InputStream is;
        Configuration c = new Configuration();
        if (namedCluster != null && (is = namedCluster.getSiteFileInputStream(fileName)) != null) {
            c.addResource(is, fileName);
            return c.getValByRegex(".*");
        }
        return null;
    }

    public static enum ClusterConfigNames {
        CONFIGS_PROP("config.properties"),
        HDFS_SITE("hdfs-site.xml"),
        CORE_SITE("core-site.xml"),
        HIVE_SITE("hive-site.xml"),
        YARN_SITE("yarn-site.xml"),
        HBASE_SITE("hbase-site.xml"),
        MAPRED_SITE("mapred-site.xml"),
        HBASE_DEFAULT("hbase-default.xml");

        private final String configName;

        private ClusterConfigNames(String configName) {
            this.configName = configName;
        }

        public String toString() {
            return this.configName;
        }
    }
}

