/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.logging;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.pentaho.big.data.impl.shim.logging.KettleLogChannelFilter;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.log4j.KettleLogChannelAppender;
import org.pentaho.di.core.logging.log4j.Log4jKettleLayout;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.platform.api.util.LogUtil;

public class WriterAppenderManager
implements Closeable {
    private static final Class<?> PKG = WriterAppenderManager.class;
    private Appender textFileAppender;
    private final Appender kettleLogChannelAppender;
    private FileObject file;
    private String[] loggersToWatch;
    public static Map<LogLevel, Level> LOG_LEVEL_MAP;

    public WriterAppenderManager(LogChannelInterface logChannelInterface, LogLevel logLevel, String name, String[] logs) {
        String logFileName = "pdi-" + name;
        this.loggersToWatch = logs;
        try {
            this.file = KettleVFS.createTempFile((String)logFileName, (String)".log", (String)System.getProperty("java.io.tmpdir"));
            this.textFileAppender = LogUtil.makeAppender((String)logFileName, (Writer)new OutputStreamWriter(KettleVFS.getOutputStream((FileObject)this.file, (boolean)true), Charset.forName("utf-8")), (Layout)new Log4jKettleLayout(Charset.forName("utf-8"), true));
        }
        catch (Exception e) {
            logChannelInterface.logError(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
            logChannelInterface.logError(Const.getStackTracker((Throwable)e));
        }
        ThreadContext.put((String)"logChannelId", (String)logChannelInterface.getLogChannelId());
        this.kettleLogChannelAppender = new KettleLogChannelAppender(logChannelInterface, new Log4jKettleLayout(Charset.forName("utf-8"), true));
        KettleLogChannelFilter pigLogFilter = new KettleLogChannelFilter(logChannelInterface.getLogChannelId());
        Level log4jLevel = this.getLog4jLevel(logLevel);
        for (String logName : this.loggersToWatch) {
            Logger logger = LogManager.getLogger((String)logName);
            LogUtil.addAppender((Appender)this.kettleLogChannelAppender, (Logger)logger, (Level)log4jLevel, (Filter)pigLogFilter);
            LogUtil.addAppender((Appender)this.textFileAppender, (Logger)logger, (Level)log4jLevel, (Filter)pigLogFilter);
            LogUtil.setLevel((Logger)logger, (Level)log4jLevel);
        }
    }

    private Level getLog4jLevel(LogLevel level) {
        Level log4jLevel = LOG_LEVEL_MAP.get(level);
        return log4jLevel != null ? log4jLevel : Level.INFO;
    }

    @Override
    public void close() throws IOException {
        for (String logName : this.loggersToWatch) {
            Logger logger = LogManager.getLogger((String)logName);
            if (this.textFileAppender != null) {
                LogUtil.removeAppender((Appender)this.textFileAppender, (Logger)logger);
            }
            if (this.kettleLogChannelAppender == null) continue;
            LogUtil.removeAppender((Appender)this.kettleLogChannelAppender, (Logger)logger);
        }
    }

    public FileObject getFile() {
        return this.file;
    }

    static {
        HashMap<LogLevel, Level> map = new HashMap<LogLevel, Level>();
        map.put(LogLevel.BASIC, Level.INFO);
        map.put(LogLevel.MINIMAL, Level.INFO);
        map.put(LogLevel.DEBUG, Level.DEBUG);
        map.put(LogLevel.ERROR, Level.ERROR);
        map.put(LogLevel.DETAILED, Level.INFO);
        map.put(LogLevel.ROWLEVEL, Level.DEBUG);
        map.put(LogLevel.NOTHING, Level.OFF);
        LOG_LEVEL_MAP = Collections.unmodifiableMap(map);
    }

    public static class Factory {
        public WriterAppenderManager create(LogChannelInterface logChannelInterface, LogLevel logLevel, String name, String[] logs) {
            return new WriterAppenderManager(logChannelInterface, logLevel, name, logs);
        }
    }
}

