/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerConversionUtil;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMode;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.models.JoinRelationshipModel;
import org.pentaho.agilebi.modeler.models.SchemaModel;
import org.pentaho.agilebi.modeler.strategy.MultiTableAutoModelStrategy;
import org.pentaho.agilebi.modeler.strategy.SimpleAutoModelStrategy;
import org.pentaho.agilebi.modeler.strategy.StarSchemaAutoModelStrategy;
import org.pentaho.agilebi.modeler.util.ISpoonModelerSource;
import org.pentaho.agilebi.modeler.util.ModelGenerator;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceHelper;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.automodel.SchemaTable;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.RelationshipType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableModelerSource
implements ISpoonModelerSource {
    private ModelGenerator generator;
    private DatabaseMeta databaseMeta;
    private SchemaModel schemaModel;
    private List<String> selectedTables;
    private String datasourceName;
    private GeoContext geoContext;
    public static final String SOURCE_TYPE = MultiTableModelerSource.class.getSimpleName();
    private static Logger logger = LoggerFactory.getLogger(MultiTableModelerSource.class);

    public MultiTableModelerSource(DatabaseMeta databaseMeta, SchemaModel schemaModel, String datasourceName, List<String> selectedTables) {
        this(databaseMeta, schemaModel, datasourceName, selectedTables, null);
    }

    public MultiTableModelerSource(DatabaseMeta databaseMeta, SchemaModel schemaModel, String datasourceName, List<String> selectedTables, GeoContext geoContext) {
        this.datasourceName = datasourceName;
        this.databaseMeta = databaseMeta;
        this.schemaModel = schemaModel;
        this.selectedTables = selectedTables;
        this.generator = new ModelGenerator();
        this.geoContext = geoContext;
    }

    @Override
    public Domain generateDomain(boolean doOlap) throws ModelerException {
        Domain domain = null;
        try {
            String locale = "en_US";
            this.generator.setLocale(locale);
            this.generator.setDatabaseMeta(this.databaseMeta);
            this.generator.setModelName(this.datasourceName);
            HashSet<String> usedTables = new HashSet<String>();
            ArrayList<SchemaTable> schemas = new ArrayList<SchemaTable>();
            if (this.selectedTables.size() == 1) {
                String singleTable = this.selectedTables.get(0);
                if (!usedTables.contains(singleTable)) {
                    schemas.add(this.createSchemaTable(singleTable));
                }
            } else {
                for (JoinRelationshipModel joinModel : this.schemaModel.getJoins()) {
                    String toTable;
                    String fromTable = joinModel.getLeftKeyFieldModel().getParentTable().getName();
                    if (!usedTables.contains(fromTable)) {
                        schemas.add(this.createSchemaTable(fromTable));
                        usedTables.add(fromTable);
                    }
                    if (usedTables.contains(toTable = joinModel.getRightKeyFieldModel().getParentTable().getName())) continue;
                    schemas.add(this.createSchemaTable(toTable));
                    usedTables.add(toTable);
                }
            }
            SchemaTable[] tableNames = new SchemaTable[schemas.size()];
            tableNames = schemas.toArray(tableNames);
            this.generator.setTableNames(tableNames);
            domain = this.generator.generateDomain();
            domain.setId(this.datasourceName);
            ModelerWorkspaceHelper helper = new ModelerWorkspaceHelper(locale);
            if (this.selectedTables.size() == 1) {
                helper.setAutoModelStrategy(new SimpleAutoModelStrategy(locale, this.geoContext));
            } else if (doOlap) {
                helper.setAutoModelStrategy(new StarSchemaAutoModelStrategy(locale, this.geoContext));
            } else {
                helper.setAutoModelStrategy(new MultiTableAutoModelStrategy(locale));
            }
            ((LogicalModel)domain.getLogicalModels().get(0)).setProperty("DUAL_MODELING_SCHEMA", (Object)("" + doOlap));
            ModelerWorkspace workspace = new ModelerWorkspace(helper, this.geoContext);
            workspace.setDomain(domain);
            LogicalModel logicalModel = workspace.getLogicalModel(ModelerPerspective.REPORTING);
            logicalModel.setProperty("AGILE_BI_GENERATED_SCHEMA", (Object)"TRUE");
            logicalModel.setName(new LocalizedString(locale, this.datasourceName));
            logicalModel.setDescription(new LocalizedString(locale, "This is the data model for " + this.datasourceName));
            workspace.setModelName(this.datasourceName);
            helper.autoModelRelationalFlat(workspace);
            LogicalModel olapModel = null;
            if (doOlap) {
                String factTableName;
                LogicalTable factTable;
                olapModel = workspace.getLogicalModel(ModelerPerspective.ANALYSIS);
                if (olapModel.getLogicalRelationships().size() != logicalModel.getLogicalRelationships().size()) {
                    ModelerConversionUtil.duplicateRelationshipsForOlap(logicalModel, olapModel);
                }
                if ((factTable = this.findFactTable(factTableName = this.getSchemaTablePair(this.schemaModel.getFactTable().getName())[1], olapModel)) == null) {
                    throw new IllegalStateException("Fact table not found");
                }
                factTable.getPhysicalTable().setProperty("FACT_TABLE", (Object)true);
                workspace.getAvailableTables().setFactTable(factTable.getPhysicalTable());
                if (this.selectedTables.size() == 1) {
                    helper.setAutoModelStrategy(new SimpleAutoModelStrategy(locale, this.geoContext));
                } else {
                    helper.setAutoModelStrategy(new StarSchemaAutoModelStrategy(locale, this.geoContext));
                }
                helper.autoModelFlat(workspace);
                workspace.setModellingMode(ModelerMode.ANALYSIS_AND_REPORTING);
            } else {
                workspace.setModellingMode(ModelerMode.REPORTING_ONLY);
            }
            this.generateLogicalRelationships(logicalModel, false);
            if (doOlap) {
                this.generateLogicalRelationships(olapModel, true);
            }
            helper.populateDomain(workspace);
            for (LogicalTable businessTable : logicalModel.getLogicalTables()) {
                businessTable.setName(new LocalizedString(locale, businessTable.getPhysicalTable().getName(locale)));
            }
            if (olapModel != null) {
                for (LogicalTable businessTable : olapModel.getLogicalTables()) {
                    businessTable.setName(new LocalizedString(locale, businessTable.getPhysicalTable().getName(locale)));
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
            logger.info(e.getLocalizedMessage());
            throw new ModelerException(e.getLocalizedMessage(), e);
        }
        return domain;
    }

    private SchemaTable createSchemaTable(String table) {
        String schemaName = "";
        String tableName = table;
        if (table.indexOf(".") > 0) {
            String[] pair = this.getSchemaTablePair(table);
            schemaName = pair[0];
            tableName = pair[1];
        }
        return new SchemaTable(schemaName, tableName);
    }

    private String[] getSchemaTablePair(String table) {
        if (table.indexOf(".") < 0) {
            return new String[]{"", table};
        }
        String[] pair = new String[2];
        String[] parts = table.split("\\.");
        pair[0] = parts[0];
        pair[1] = StringUtils.join((Object[])Arrays.copyOfRange(parts, 1, parts.length), (String)".");
        return pair;
    }

    private LogicalTable findFactTable(String table, LogicalModel logicalModel) {
        LogicalTable factTable = null;
        for (LogicalTable lTable : logicalModel.getLogicalTables()) {
            Object prop;
            if (!lTable.getId().endsWith("_OLAP") || (prop = lTable.getPhysicalTable().getProperty("target_table")) == null || !prop.equals(table)) continue;
            factTable = lTable;
            break;
        }
        return factTable;
    }

    private void generateLogicalRelationships(LogicalModel logicalModel, boolean doOlap) throws IllegalStateException {
        for (JoinRelationshipModel joinModel : this.schemaModel.getJoins()) {
            String lTable = joinModel.getLeftKeyFieldModel().getParentTable().getName();
            String rTable = joinModel.getRightKeyFieldModel().getParentTable().getName();
            lTable = this.getSchemaTablePair(lTable)[1];
            rTable = this.getSchemaTablePair(rTable)[1];
            LogicalTable fromTable = null;
            LogicalColumn fromColumn = null;
            LogicalTable toTable = null;
            LogicalColumn toColumn = null;
            block1: for (LogicalTable logicalTable : logicalModel.getLogicalTables()) {
                if (doOlap && !logicalTable.getId().endsWith("_OLAP") || !doOlap && logicalTable.getId().endsWith("_OLAP")) continue;
                if (logicalTable.getPhysicalTable().getProperty("target_table").equals(lTable)) {
                    fromTable = logicalTable;
                    for (LogicalColumn logicalColumn : fromTable.getLogicalColumns()) {
                        if (!logicalColumn.getPhysicalColumn().getProperty("target_column").equals(joinModel.getLeftKeyFieldModel().getName())) continue;
                        fromColumn = logicalColumn;
                        break;
                    }
                }
                if (!logicalTable.getPhysicalTable().getProperty("target_table").equals(rTable)) continue;
                toTable = logicalTable;
                for (LogicalColumn logicalColumn : toTable.getLogicalColumns()) {
                    if (!logicalColumn.getPhysicalColumn().getProperty("target_column").equals(joinModel.getRightKeyFieldModel().getName())) continue;
                    toColumn = logicalColumn;
                    continue block1;
                }
            }
            if (fromTable == null || fromColumn == null || toTable == null || toColumn == null) {
                throw new IllegalStateException("Invalid Relationship");
            }
            LogicalRelationship logicalRelationship = new LogicalRelationship();
            logicalRelationship.setRelationshipType(RelationshipType._1_1);
            logicalRelationship.setFromTable(fromTable);
            logicalRelationship.setFromColumn(fromColumn);
            logicalRelationship.setToTable(toTable);
            logicalRelationship.setToColumn(toColumn);
            logicalModel.addLogicalRelationship(logicalRelationship);
        }
    }

    @Override
    public String getDatabaseName() {
        String name = null;
        if (this.databaseMeta != null) {
            name = this.databaseMeta.getDatabaseName();
        }
        return name;
    }

    @Override
    public void initialize(Domain domain) throws ModelerException {
    }

    @Override
    public void serializeIntoDomain(Domain d) {
        LogicalModel lm = (LogicalModel)d.getLogicalModels().get(0);
        lm.setProperty("source_type", (Object)SOURCE_TYPE);
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    @Override
    public Domain generateDomain() throws ModelerException {
        return this.generateDomain(false);
    }
}

