/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.data.ColumnMapping;
import org.pentaho.agilebi.modeler.models.annotations.data.DataProvider;
import org.pentaho.agilebi.modeler.models.annotations.util.KeyValueClosure;
import org.pentaho.agilebi.modeler.models.annotations.util.XMLUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.model.concept.types.DataType;

public class ModelAnnotationGroupXmlWriter {
    private ModelAnnotationGroup modelAnnotations;

    public ModelAnnotationGroup getModelAnnotations() {
        return this.modelAnnotations;
    }

    public void setModelAnnotations(ModelAnnotationGroup modelAnnotations) {
        this.modelAnnotations = modelAnnotations;
    }

    public ModelAnnotationGroupXmlWriter(ModelAnnotationGroup modelAnnotationGroup) {
        this.modelAnnotations = modelAnnotationGroup;
    }

    public String getXML() {
        try {
            return XMLUtil.prettyPrint(this.getModelAnnotationsXml());
        }
        catch (Exception e) {
            return this.getModelAnnotationsXml();
        }
    }

    private String getModelAnnotationsXml() {
        final StringBuffer xml = new StringBuffer();
        xml.append("    <annotations>");
        if (this.getModelAnnotations() != null) {
            for (ModelAnnotation modelAnnotation : this.getModelAnnotations()) {
                if (StringUtils.isBlank((String)modelAnnotation.getName())) {
                    modelAnnotation.setName(UUID.randomUUID().toString());
                }
                xml.append("      <annotation>");
                xml.append("        ").append(XMLHandler.addTagValue((String)"name", (String)modelAnnotation.getName()));
                xml.append("        ").append(XMLHandler.addTagValue((String)"field", (String)((AnnotationType)modelAnnotation.getAnnotation()).getField()));
                if (modelAnnotation.getType() != null) {
                    xml.append("        ").append(XMLHandler.addTagValue((String)"type", (String)modelAnnotation.getType().toString()));
                    xml.append("         <properties>");
                    modelAnnotation.iterateProperties(new KeyValueClosure(){

                        @Override
                        public void execute(String key, Serializable serializable) {
                            if (!"field".equals(key)) {
                                xml.append("            ").append(XMLHandler.openTag((String)"property"));
                                xml.append("               ").append(XMLHandler.addTagValue((String)"name", (String)key));
                                xml.append("               ").append(XMLHandler.openTag((String)"value"));
                                xml.append(XMLHandler.buildCDATA((String)serializable.toString()));
                                xml.append(XMLHandler.closeTag((String)"value"));
                                xml.append("            ").append(XMLHandler.closeTag((String)"property"));
                            }
                        }
                    });
                    xml.append("         </properties>");
                }
                xml.append("      </annotation>");
            }
            xml.append("    ").append(XMLHandler.addTagValue((String)"sharedDimension", (boolean)this.getModelAnnotations().isSharedDimension()));
            xml.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.getModelAnnotations().getDescription()));
            xml.append(this.getDataProvidersXml(this.getModelAnnotations().getDataProviders()));
        }
        xml.append("    </annotations>");
        return xml.toString();
    }

    private String getDataProvidersXml(List<DataProvider> dataProviders) {
        StringBuffer xml = new StringBuffer();
        if (dataProviders != null && !dataProviders.isEmpty()) {
            xml.append("    <data-providers>");
            for (DataProvider provider : dataProviders) {
                xml.append("    <data-provider>");
                xml.append("        ").append(XMLHandler.addTagValue((String)"name", (String)provider.getName()));
                xml.append("        ").append(XMLHandler.addTagValue((String)"schemaName", (String)provider.getSchemaName()));
                xml.append("        ").append(XMLHandler.addTagValue((String)"tableName", (String)provider.getTableName()));
                xml.append("        ").append(XMLHandler.addTagValue((String)"databaseMetaRef", (String)provider.getDatabaseMetaNameRef()));
                xml.append(this.getColumnMappingsXml(provider.getColumnMappings()));
                xml.append("    </data-provider>");
            }
            xml.append("    </data-providers>");
        }
        return xml.toString();
    }

    private String getColumnMappingsXml(List<ColumnMapping> columnMappings) {
        StringBuffer xml = new StringBuffer();
        if (columnMappings != null && !columnMappings.isEmpty()) {
            xml.append("    <column-mappings>");
            for (ColumnMapping columnMapping : columnMappings) {
                xml.append("    <column-mapping>");
                xml.append("        ").append(XMLHandler.addTagValue((String)"name", (String)columnMapping.getName()));
                xml.append("        ").append(XMLHandler.addTagValue((String)"columnName", (String)columnMapping.getColumnName()));
                DataType dataType = columnMapping.getColumnDataType();
                if (dataType != null) {
                    xml.append("        ").append(XMLHandler.addTagValue((String)"dataType", (String)columnMapping.getColumnDataType().name()));
                }
                xml.append("    </column-mapping>");
            }
            xml.append("    </column-mappings>");
        }
        return xml.toString();
    }
}

